/*
 * Decompiled with CFR 0.152.
 */
package boomerang.example;

import boomerang.BackwardQuery;
import boomerang.Boomerang;
import boomerang.DefaultBoomerangOptions;
import boomerang.Query;
import boomerang.results.BackwardBoomerangResults;
import boomerang.scene.AnalysisScope;
import boomerang.scene.CallGraph;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.SootDataFlowScope;
import boomerang.scene.Statement;
import boomerang.scene.Val;
import boomerang.scene.jimple.BoomerangPretransformer;
import boomerang.scene.jimple.SootCallGraph;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import soot.G;
import soot.PackManager;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootMethod;
import soot.Transform;
import soot.Transformer;
import soot.options.Options;

public class ExampleMain1 {
    public static void main(String ... args) {
        String sootClassPath = ExampleMain1.getSootClassPath();
        String mainClass = "boomerang.example.BoomerangExampleTarget1";
        ExampleMain1.setupSoot(sootClassPath, mainClass);
        ExampleMain1.analyze();
    }

    private static String getSootClassPath() {
        String sootClassPath = System.getProperty("user.dir") + File.separator + "target" + File.separator + "classes";
        File classPathDir = new File(sootClassPath);
        if (!classPathDir.exists() && !(classPathDir = new File(sootClassPath = System.getProperty("user.dir") + File.separator + "boomerangPDS" + File.separator + "target" + File.separator + "classes")).exists()) {
            throw new RuntimeException("Classpath could not be found.");
        }
        return sootClassPath;
    }

    private static void setupSoot(String sootClassPath, String mainClass) {
        G.v();
        G.reset();
        Options.v().set_whole_program(true);
        Options.v().setPhaseOption("cg.spark", "on");
        Options.v().set_output_format(12);
        Options.v().set_no_bodies_for_excluded(true);
        Options.v().set_allow_phantom_refs(true);
        LinkedList<String> includeList = new LinkedList<String>();
        includeList.add("java.lang.*");
        includeList.add("java.util.*");
        includeList.add("java.io.*");
        includeList.add("sun.misc.*");
        includeList.add("java.net.*");
        includeList.add("javax.servlet.*");
        includeList.add("javax.crypto.*");
        Options.v().set_include(includeList);
        Options.v().setPhaseOption("jb", "use-original-names:true");
        Options.v().set_soot_classpath(sootClassPath);
        Options.v().set_prepend_classpath(true);
        Scene.v().loadNecessaryClasses();
        SootClass c = Scene.v().forceResolve(mainClass, 3);
        if (c != null) {
            c.setApplicationClass();
        }
        for (SootMethod m : c.getMethods()) {
            System.out.println(m);
        }
    }

    private static void analyze() {
        Transform transform = new Transform("wjtp.ifds", ExampleMain1.createAnalysisTransformer());
        PackManager.v().getPack("wjtp").add(transform);
        PackManager.v().getPack("cg").apply();
        BoomerangPretransformer.v().apply();
        PackManager.v().getPack("wjtp").apply();
    }

    private static Transformer createAnalysisTransformer() {
        return new SceneTransformer(){

            protected void internalTransform(String phaseName, Map options) {
                SootCallGraph sootCallGraph = new SootCallGraph();
                AnalysisScope scope = new AnalysisScope((CallGraph)sootCallGraph){

                    @Override
                    protected Collection<? extends Query> generate(ControlFlowGraph.Edge cfgEdge) {
                        Statement statement = cfgEdge.getTarget();
                        if (statement.toString().contains("queryFor") && statement.containsInvokeExpr()) {
                            Val arg = statement.getInvokeExpr().getArg(0);
                            return Collections.singleton(BackwardQuery.make(cfgEdge, arg));
                        }
                        return Collections.emptySet();
                    }
                };
                Boomerang solver = new Boomerang((CallGraph)sootCallGraph, SootDataFlowScope.make((Scene)Scene.v()), new DefaultBoomerangOptions());
                Collection<Query> seeds = scope.computeSeeds();
                for (Query query : seeds) {
                    System.out.println("Solving query: " + query);
                    BackwardBoomerangResults backwardQueryResults = solver.solve((BackwardQuery)query);
                    System.out.println("All allocation sites of the query variable are:");
                    System.out.println(backwardQueryResults.getAllocationSites());
                    System.out.println("All aliasing access path of the query variable are:");
                    System.out.println(backwardQueryResults.getAllAliases());
                }
            }
        };
    }
}

