/*
 * Decompiled with CFR 0.152.
 */
package boomerang.flowfunction;

import boomerang.BoomerangOptions;
import boomerang.ForwardQuery;
import boomerang.flowfunction.FlowFunctionUtils;
import boomerang.flowfunction.IForwardFlowFunction;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.Field;
import boomerang.scene.InvokeExpr;
import boomerang.scene.Method;
import boomerang.scene.Pair;
import boomerang.scene.Statement;
import boomerang.scene.StaticFieldVal;
import boomerang.scene.Val;
import boomerang.solver.ForwardBoomerangSolver;
import boomerang.solver.Strategies;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sync.pds.solver.SyncPDSSolver;
import sync.pds.solver.nodes.ExclusionNode;
import sync.pds.solver.nodes.Node;
import sync.pds.solver.nodes.NodeWithLocation;
import sync.pds.solver.nodes.PopNode;
import sync.pds.solver.nodes.PushNode;
import wpds.interfaces.State;

public class DefaultForwardFlowFunction
implements IForwardFlowFunction {
    private final BoomerangOptions options;
    private Strategies strategies;
    private ForwardBoomerangSolver solver;

    public DefaultForwardFlowFunction(BoomerangOptions opts) {
        this.options = opts;
    }

    public Set<Val> returnFlow(Method method, Statement curr, Val value) {
        HashSet out = Sets.newHashSet();
        if (curr.isThrowStmt() && !this.options.throwFlows()) {
            return Collections.emptySet();
        }
        if (curr.isReturnStmt() && curr.getReturnOp().equals((Object)value)) {
            out.add(value);
        }
        if (!method.isStatic() && method.getThisLocal().equals((Object)value)) {
            out.add(value);
        }
        for (Val param : method.getParameterLocals()) {
            if (!param.equals((Object)value)) continue;
            out.add(value);
        }
        if (value.isStatic()) {
            out.add(value);
        }
        return out;
    }

    public Set<Val> callFlow(Statement callSite, Val fact, Method callee) {
        if (!callSite.containsInvokeExpr()) {
            throw new RuntimeException("Call site does not contain an invoke expression.");
        }
        if (callee.isStaticInitializer()) {
            return Collections.emptySet();
        }
        HashSet out = Sets.newHashSet();
        InvokeExpr invokeExpr = callSite.getInvokeExpr();
        if (invokeExpr.isInstanceInvokeExpr() && invokeExpr.getBase().equals((Object)fact) && !callee.isStatic()) {
            out.add(callee.getThisLocal());
        }
        int i = 0;
        List parameterLocals = callee.getParameterLocals();
        for (Val arg : invokeExpr.getArgs()) {
            if (arg.equals((Object)fact) && parameterLocals.size() > i) {
                out.add(parameterLocals.get(i));
            }
            ++i;
        }
        if (fact.isStatic()) {
            out.add(fact.withNewMethod(callee));
        }
        return out;
    }

    public Set<State> normalFlow(ForwardQuery query, ControlFlowGraph.Edge nextEdge, Val fact) {
        Statement succ = nextEdge.getStart();
        HashSet out = Sets.newHashSet();
        if (this.killFlow(succ, fact)) {
            return out;
        }
        if (!succ.isFieldWriteWithBase(fact)) {
            if (!(this.options.trackReturnOfInstanceOf() && query.getType().isNullType() && succ.isInstanceOfStatement(fact))) {
                out.add(new Node((Object)nextEdge, (Object)fact));
            }
        } else {
            out.add(new ExclusionNode((Object)nextEdge, (Object)fact, (Object)succ.getWrittenField()));
        }
        if (succ.isAssign()) {
            Collection phiVals;
            Pair arrayBase;
            StaticFieldVal sf;
            Pair ifr;
            Val leftOp = succ.getLeftOp();
            Val rightOp = succ.getRightOp();
            if (rightOp.equals((Object)fact)) {
                if (succ.isFieldStore()) {
                    ifr = succ.getFieldStore();
                    if (!(!this.options.trackFields() || this.options.ignoreInnerClassFields() && ((Field)ifr.getY()).isInnerClassField())) {
                        out.add(new PushNode((Object)nextEdge, ifr.getX(), ifr.getY(), SyncPDSSolver.PDSSystem.FIELDS));
                    }
                } else if (succ.isStaticFieldStore()) {
                    sf = succ.getStaticField();
                    if (this.options.trackFields()) {
                        this.strategies.getStaticFieldStrategy().handleForward(nextEdge, rightOp, sf, out);
                    }
                } else if (leftOp.isArrayRef()) {
                    arrayBase = succ.getArrayBase();
                    if (this.options.trackFields()) {
                        this.strategies.getArrayHandlingStrategy().handleForward(nextEdge, (Pair<Val, Integer>)arrayBase, out);
                    }
                } else {
                    out.add(new Node((Object)nextEdge, (Object)leftOp));
                }
            }
            if (succ.isFieldLoad()) {
                ifr = succ.getFieldLoad();
                if (((Val)ifr.getX()).equals((Object)fact)) {
                    NodeWithLocation succNode = new NodeWithLocation((Object)nextEdge, (Object)leftOp, ifr.getY());
                    out.add(new PopNode((Object)succNode, SyncPDSSolver.PDSSystem.FIELDS));
                }
            } else if (succ.isStaticFieldLoad()) {
                sf = succ.getStaticField();
                if (fact.isStatic() && fact.equals((Object)sf)) {
                    out.add(new Node((Object)nextEdge, (Object)leftOp));
                }
            } else if (rightOp.isArrayRef()) {
                arrayBase = succ.getArrayBase();
                if (((Val)arrayBase.getX()).equals((Object)fact)) {
                    NodeWithLocation succNode = new NodeWithLocation((Object)nextEdge, (Object)leftOp, (Object)Field.array((int)((Integer)arrayBase.getY())));
                    out.add(new PopNode((Object)succNode, SyncPDSSolver.PDSSystem.FIELDS));
                }
            } else if (rightOp.isCast()) {
                if (rightOp.getCastOp().equals((Object)fact)) {
                    out.add(new Node((Object)nextEdge, (Object)leftOp));
                }
            } else if (rightOp.isInstanceOfExpr() && query.getType().isNullType() && this.options.trackReturnOfInstanceOf()) {
                if (rightOp.getInstanceOfOp().equals((Object)fact)) {
                    out.add(new Node((Object)nextEdge, (Object)fact.withSecondVal(leftOp)));
                }
            } else if (succ.isPhiStatement() && (phiVals = succ.getPhiVals()).contains(fact)) {
                out.add(new Node((Object)nextEdge, (Object)succ.getLeftOp()));
            }
        }
        return out;
    }

    protected boolean killFlow(Statement curr, Val value) {
        if (curr.isThrowStmt() || curr.isCatchStmt()) {
            return true;
        }
        if (curr.isAssign()) {
            if (curr.getLeftOp().equals((Object)value)) {
                Pair ifr;
                return !curr.isFieldLoad() || !((Val)(ifr = curr.getFieldLoad()).getX()).equals((Object)value);
            }
            if (curr.isStaticFieldStore()) {
                StaticFieldVal sf = curr.getStaticField();
                if (value.isStatic() && value.equals((Object)sf)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Collection<State> callToReturnFlow(ForwardQuery query, ControlFlowGraph.Edge edge, Val fact) {
        if (FlowFunctionUtils.isSystemArrayCopy(edge.getStart().getInvokeExpr().getMethod())) {
            return this.systemArrayCopyFlow(edge, fact);
        }
        return this.normalFlow(query, edge, fact);
    }

    protected Collection<State> systemArrayCopyFlow(ControlFlowGraph.Edge edge, Val value) {
        Statement callSite = edge.getStart();
        if (value.equals((Object)callSite.getInvokeExpr().getArg(0))) {
            Val arg = callSite.getInvokeExpr().getArg(2);
            return Collections.singleton(new Node((Object)edge, (Object)arg));
        }
        return Collections.emptySet();
    }

    @Override
    public void setSolver(ForwardBoomerangSolver solver, Multimap<Field, Statement> fieldLoadStatements, Multimap<Field, Statement> fieldStoreStatements) {
        this.solver = solver;
        this.strategies = new Strategies(this.options, solver, fieldLoadStatements, fieldStoreStatements);
    }
}

