/*
 * Decompiled with CFR 0.152.
 */
package boomerang.results;

import boomerang.Query;
import boomerang.results.AffectedLocation;
import boomerang.results.PathElement;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.Method;
import boomerang.scene.Pair;
import boomerang.scene.Statement;
import boomerang.scene.Val;
import java.util.List;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import wpds.impl.PAutomaton;

public class NullPointerDereference
implements AffectedLocation {
    public static final int RULE_INDEX = 0;
    private final ControlFlowGraph.Edge statement;
    private final Val variable;
    private PAutomaton<Statement, INode<Val>> openingContext;
    private PAutomaton<Statement, INode<Val>> closingContext;
    private List<PathElement> dataFlowPath;
    private final ControlFlowGraph.Edge sourceStatement;
    private final Val sourceVariable;
    private Query query;

    public NullPointerDereference(ControlFlowGraph.Edge statement) {
        this(null, statement, null, null, null, null);
    }

    public NullPointerDereference(Query query, ControlFlowGraph.Edge statement, Val variable, PAutomaton<Statement, INode<Val>> openingContext, PAutomaton<Statement, INode<Val>> closingContext, List<PathElement> dataFlowPath) {
        this.query = query;
        this.sourceStatement = query.cfgEdge();
        this.sourceVariable = query.var();
        this.statement = statement;
        this.variable = variable;
        this.openingContext = openingContext;
        this.closingContext = closingContext;
        this.dataFlowPath = dataFlowPath;
    }

    @Override
    public Val getVariable() {
        return this.variable;
    }

    @Override
    public List<PathElement> getDataFlowPath() {
        return this.dataFlowPath;
    }

    @Override
    public String getMessage() {
        return "Potential **null pointer** dereference";
    }

    @Override
    public int getRuleIndex() {
        return 0;
    }

    @Override
    public ControlFlowGraph.Edge getStatement() {
        return this.statement;
    }

    public ControlFlowGraph.Edge getSourceStatement() {
        return this.sourceStatement;
    }

    public Val getSourceVariable() {
        return this.sourceVariable;
    }

    public Method getMethod() {
        return this.getStatement().getStart().getMethod();
    }

    public PAutomaton<Statement, INode<Val>> getOpeningContext() {
        return this.openingContext;
    }

    public PAutomaton<Statement, INode<Val>> getClosingContext() {
        return this.closingContext;
    }

    public String toString() {
        String str = "Null Pointer: \n";
        str = str + "defined at " + this.getSourceStatement().getStart().getMethod();
        str = str + (this.getVariable() != null ? "\tVariable: " + this.getVariable() : "");
        str = str + "\n\tStatement: " + this.getStatement() + "\n\tMethod: " + this.getMethod();
        return str;
    }

    public Query getQuery() {
        return this.query;
    }

    public static boolean isNullPointerNode(Node<ControlFlowGraph.Edge, Val> nullPointerNode) {
        Val invocationBase;
        Val fact = (Val)nullPointerNode.fact();
        Method m = fact.m();
        if (!m.isStatic() && m.getThisLocal().equals((Object)fact)) {
            return false;
        }
        Statement curr = ((ControlFlowGraph.Edge)nullPointerNode.stmt()).getStart();
        if (curr.containsInvokeExpr() && curr.getInvokeExpr().isInstanceInvokeExpr() && (invocationBase = curr.getInvokeExpr().getBase()).equals((Object)fact)) {
            return true;
        }
        if (curr.isAssign()) {
            Val lengthOp;
            Pair ifr;
            if (curr.isFieldLoad() && ((Val)(ifr = curr.getFieldLoad()).getX()).equals((Object)fact)) {
                return true;
            }
            if (curr.getRightOp().isLengthExpr() && (lengthOp = curr.getRightOp().getLengthOp()).equals((Object)fact)) {
                return true;
            }
        }
        return false;
    }
}

