/*
 * Decompiled with CFR 0.152.
 */
package boomerang.scene;

import boomerang.Query;
import boomerang.scene.CallGraph;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.Method;
import boomerang.scene.Statement;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AnalysisScope {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalysisScope.class);
    private CallGraph cg;
    private boolean scanLibraryClasses = false;
    private final Set<Query> seeds = Sets.newHashSet();
    private Collection<Method> processed = Sets.newHashSet();
    private int statementCount;

    public AnalysisScope(CallGraph cg) {
        this.cg = cg;
    }

    public void setScanLibraryClasses(boolean enabled) {
        this.scanLibraryClasses = enabled;
    }

    public Collection<Query> computeSeeds() {
        Collection entryPoints = this.cg.getEntryPoints();
        LOGGER.info("Computing seeds starting at {} entry method(s).", (Object)entryPoints.size());
        Stopwatch watch = Stopwatch.createStarted();
        LinkedList worklist = Lists.newLinkedList();
        worklist.addAll(entryPoints);
        while (!worklist.isEmpty()) {
            Method m = (Method)worklist.pop();
            if (!this.processed.add(m)) continue;
            LOGGER.trace("Processing {}", (Object)m);
            for (Statement u : m.getStatements()) {
                ++this.statementCount;
                if (u.containsInvokeExpr()) {
                    Collection edgesOutOf = this.cg.edgesOutOf(u);
                    for (CallGraph.Edge e : edgesOutOf) {
                        Method tgt = e.tgt();
                        if (!this.scanLibraryClasses && !tgt.getDeclaringClass().isApplicationClass() || this.processed.contains(tgt)) continue;
                        worklist.add(tgt);
                    }
                }
                for (Statement succ : u.getMethod().getControlFlowGraph().getSuccsOf(u)) {
                    this.seeds.addAll(this.generate(new ControlFlowGraph.Edge(u, succ)));
                }
            }
        }
        LOGGER.info("Found {} seeds in {} in {} LOC .", new Object[]{this.seeds.size(), watch, this.statementCount});
        return this.seeds;
    }

    protected boolean analyseClassInitializers() {
        return false;
    }

    protected abstract Collection<? extends Query> generate(ControlFlowGraph.Edge var1);
}

