/*
 * Decompiled with CFR 0.152.
 */
package boomerang.stats;

import boomerang.BackwardQuery;
import boomerang.ForwardQuery;
import boomerang.Query;
import boomerang.WeightedBoomerang;
import boomerang.results.BackwardBoomerangResults;
import boomerang.results.ForwardBoomerangResults;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.Field;
import boomerang.scene.Method;
import boomerang.scene.Val;
import boomerang.solver.AbstractBoomerangSolver;
import boomerang.solver.BackwardBoomerangSolver;
import boomerang.solver.ForwardBoomerangSolver;
import boomerang.stats.IBoomerangStats;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import wpds.impl.Rule;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.interfaces.Location;
import wpds.interfaces.State;

public class AdvancedBoomerangStats<W extends Weight>
implements IBoomerangStats<W> {
    private Map<Query, AbstractBoomerangSolver<W>> queries = Maps.newHashMap();
    private Set<WeightedTransition<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W>> globalFieldTransitions = Sets.newHashSet();
    private int fieldTransitionCollisions;
    private Set<WeightedTransition<ControlFlowGraph.Edge, INode<Val>, W>> globalCallTransitions = Sets.newHashSet();
    private int callTransitionCollisions;
    private Set<Rule<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W>> globalFieldRules = Sets.newHashSet();
    private int fieldRulesCollisions;
    private Set<Rule<ControlFlowGraph.Edge, INode<Val>, W>> globalCallRules = Sets.newHashSet();
    private int callRulesCollisions;
    private Set<Node<ControlFlowGraph.Edge, Val>> reachedForwardNodes = Sets.newHashSet();
    private int reachedForwardNodeCollisions;
    private Set<Node<ControlFlowGraph.Edge, Val>> reachedBackwardNodes = Sets.newHashSet();
    private int reachedBackwardNodeCollisions;
    private Set<Method> callVisitedMethods = Sets.newHashSet();
    private Set<Method> fieldVisitedMethods = Sets.newHashSet();
    private int arrayFlows;
    private int staticFlows;
    private boolean COUNT_TOP_METHODS = false;
    private Map<String, Integer> backwardFieldMethodsRules = new TreeMap<String, Integer>();
    private Map<String, Integer> backwardCallMethodsRules = new TreeMap<String, Integer>();
    private Map<String, Integer> forwardFieldMethodsRules = new TreeMap<String, Integer>();
    private Map<String, Integer> forwardCallMethodsRules = new TreeMap<String, Integer>();

    public static <K> Map<K, Integer> sortByValues(Map<K, Integer> map) {
        Comparator valueComparator = (k1, k2) -> {
            if ((Integer)map.get(k2) > (Integer)map.get(k1)) {
                return 1;
            }
            return -1;
        };
        TreeMap<K, Integer> sortedByValues = new TreeMap<K, Integer>(valueComparator);
        sortedByValues.putAll(map);
        return sortedByValues;
    }

    @Override
    public void registerSolver(Query key, AbstractBoomerangSolver<W> solver) {
        if (this.queries.containsKey(key)) {
            return;
        }
        this.queries.put(key, solver);
        solver.getFieldAutomaton().registerListener((t, w, aut) -> {
            if (!this.globalFieldTransitions.add(new WeightedTransition(t, w))) {
                ++this.fieldTransitionCollisions;
            }
            this.fieldVisitedMethods.add(((ControlFlowGraph.Edge)((Node)((INode)t.getStart()).fact()).stmt()).getMethod());
            if (t.getLabel() instanceof Field.ArrayField) {
                ++this.arrayFlows;
            }
        });
        solver.getCallAutomaton().registerListener((t, w, aut) -> {
            if (!this.globalCallTransitions.add(new WeightedTransition(t, w))) {
                ++this.callTransitionCollisions;
            }
            this.callVisitedMethods.add(((ControlFlowGraph.Edge)t.getLabel()).getMethod());
            if (((Val)((INode)t.getStart()).fact()).isStatic()) {
                ++this.staticFlows;
            }
        });
        solver.getFieldPDS().registerUpdateListener(rule -> {
            if (!this.globalFieldRules.add(rule)) {
                ++this.fieldRulesCollisions;
            } else if (this.COUNT_TOP_METHODS) {
                this.increaseMethod(((ControlFlowGraph.Edge)((Node)((INode)rule.getS1()).fact()).stmt()).getMethod().toString(), solver instanceof BackwardBoomerangSolver ? this.backwardFieldMethodsRules : this.forwardFieldMethodsRules);
            }
        });
        solver.getCallPDS().registerUpdateListener(rule -> {
            if (!this.globalCallRules.add(rule)) {
                ++this.callRulesCollisions;
            } else if (this.COUNT_TOP_METHODS) {
                this.increaseMethod(((ControlFlowGraph.Edge)rule.getL1()).getMethod().toString(), solver instanceof BackwardBoomerangSolver ? this.backwardCallMethodsRules : this.forwardCallMethodsRules);
            }
        });
        solver.registerListener(reachableNode -> {
            if (solver instanceof ForwardBoomerangSolver) {
                if (!this.reachedForwardNodes.add((Node<ControlFlowGraph.Edge, Val>)reachableNode)) {
                    ++this.reachedForwardNodeCollisions;
                }
            } else if (!this.reachedBackwardNodes.add((Node<ControlFlowGraph.Edge, Val>)reachableNode)) {
                ++this.reachedBackwardNodeCollisions;
            }
        });
    }

    private void increaseMethod(String method, Map<String, Integer> map) {
        Integer i = map.get(method);
        if (i == null) {
            i = new Integer(0);
        }
        i = i + 1;
        map.put(method, i);
    }

    @Override
    public void registerFieldWritePOI(WeightedBoomerang.FieldWritePOI key) {
    }

    public String toString() {
        String s = "=========== Boomerang Stats =============\n";
        int forwardQuery = 0;
        int backwardQuery = 0;
        for (Query q : this.queries.keySet()) {
            if (q instanceof ForwardQuery) {
                ++forwardQuery;
                continue;
            }
            ++backwardQuery;
        }
        s = s + String.format("Queries (Forward/Backward/Total): \t\t %s/%s/%s\n", forwardQuery, backwardQuery, this.queries.keySet().size());
        s = s + String.format("Visited Methods (Field/Call): \t\t %s/%s\n", this.fieldVisitedMethods.size(), this.callVisitedMethods.size());
        s = s + String.format("Reached Forward Nodes(Collisions): \t\t %s (%s)\n", this.reachedForwardNodes.size(), this.reachedForwardNodeCollisions);
        s = s + String.format("Reached Backward Nodes(Collisions): \t\t %s (%s)\n", this.reachedBackwardNodes.size(), this.reachedBackwardNodeCollisions);
        s = s + String.format("Global Field Rules(Collisions): \t\t %s (%s)\n", this.globalFieldRules.size(), this.fieldRulesCollisions);
        s = s + String.format("Global Field Transitions(Collisions): \t\t %s (%s)\n", this.globalFieldTransitions.size(), this.fieldTransitionCollisions);
        s = s + String.format("Global Call Rules(Collisions): \t\t %s (%s)\n", this.globalCallRules.size(), this.callRulesCollisions);
        s = s + String.format("Global Call Transitions(Collisions): \t\t %s (%s)\n", this.globalCallTransitions.size(), this.callTransitionCollisions);
        s = s + String.format("Special Flows (Static/Array): \t\t %s(%s)/%s(%s)\n", this.staticFlows, this.globalCallTransitions.size(), this.arrayFlows, this.globalFieldTransitions.size());
        if (this.COUNT_TOP_METHODS) {
            s = s + this.topMostMethods(this.forwardFieldMethodsRules, "forward field");
            s = s + this.topMostMethods(this.forwardCallMethodsRules, "forward call");
            if (!this.backwardCallMethodsRules.isEmpty()) {
                s = s + this.topMostMethods(this.backwardFieldMethodsRules, "backward field");
                s = s + this.topMostMethods(this.backwardCallMethodsRules, "backward call");
            }
        }
        s = s + this.computeMetrics();
        s = s + "\n";
        return s;
    }

    private String topMostMethods(Map<String, Integer> fieldMethodsRules, String system) {
        Map<String, Integer> sootMethodIntegerMap = AdvancedBoomerangStats.sortByValues(fieldMethodsRules);
        int i = 0;
        String s = "";
        for (Map.Entry<String, Integer> e : sootMethodIntegerMap.entrySet()) {
            if (++i > 11) break;
            s = s + String.format("%s. most %s visited Method(%sx): %s\n", i, system, e.getValue(), e.getKey());
        }
        return s;
    }

    @Override
    public Set<Method> getCallVisitedMethods() {
        return Sets.newHashSet(this.callVisitedMethods);
    }

    private String computeMetrics() {
        int min = Integer.MAX_VALUE;
        int totalReached = 0;
        int max = 0;
        Query maxQuery = null;
        for (Query q : this.queries.keySet()) {
            int size = this.queries.get(q).getReachedStates().size();
            totalReached += size;
            min = Math.min(size, min);
            if (size > max) {
                maxQuery = q;
            }
            max = Math.max(size, max);
        }
        float average = (float)totalReached / (float)this.queries.keySet().size();
        String s = String.format("Reachable nodes (Min/Avg/Max): \t\t%s/%s/%s\n", min, Float.valueOf(average), max);
        s = s + String.format("Maximal Query: \t\t%s\n", maxQuery);
        return s;
    }

    @Override
    public Collection<? extends Node<ControlFlowGraph.Edge, Val>> getForwardReachesNodes() {
        HashSet res = Sets.newHashSet();
        for (Query q : this.queries.keySet()) {
            if (!(q instanceof ForwardQuery)) continue;
            res.addAll(this.queries.get(q).getReachedStates());
        }
        return res;
    }

    @Override
    public void terminated(ForwardQuery query, ForwardBoomerangResults<W> forwardBoomerangResults) {
    }

    @Override
    public void terminated(BackwardQuery query, BackwardBoomerangResults<W> backwardBoomerangResults) {
    }

    private static class WeightedTransition<X extends Location, Y extends State, W> {
        final Transition<X, Y> t;
        final W w;

        public WeightedTransition(Transition<X, Y> t, W w) {
            this.t = t;
            this.w = w;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.t == null ? 0 : this.t.hashCode());
            result = 31 * result + (this.w == null ? 0 : this.w.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WeightedTransition other = (WeightedTransition)obj;
            if (this.t == null ? other.t != null : !this.t.equals(other.t)) {
                return false;
            }
            return !(this.w == null ? other.w != null : !this.w.equals(other.w));
        }
    }
}

