/*
 * Decompiled with CFR 0.152.
 */
package boomerang.weights;

import boomerang.scene.ControlFlowGraph;
import boomerang.scene.Val;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import sync.pds.solver.nodes.Node;
import wpds.impl.Weight;

public class PathTrackingWeight
extends Weight {
    private static PathTrackingWeight one;
    private LinkedHashSet<Node<ControlFlowGraph.Edge, Val>> shortestPathWitness = new LinkedHashSet();
    private Set<LinkedHashSet<Node<ControlFlowGraph.Edge, Val>>> allPathWitness = Sets.newHashSet();
    private String rep;

    private PathTrackingWeight(String rep) {
        this.rep = rep;
    }

    private PathTrackingWeight(LinkedHashSet<Node<ControlFlowGraph.Edge, Val>> allStatement, Set<LinkedHashSet<Node<ControlFlowGraph.Edge, Val>>> allPathWitness) {
        this.shortestPathWitness = allStatement;
        this.allPathWitness = allPathWitness;
    }

    public PathTrackingWeight(Node<ControlFlowGraph.Edge, Val> relevantStatement) {
        this.shortestPathWitness.add(relevantStatement);
        LinkedHashSet<Node<ControlFlowGraph.Edge, Val>> firstDataFlowPath = new LinkedHashSet<Node<ControlFlowGraph.Edge, Val>>();
        firstDataFlowPath.add(relevantStatement);
        this.allPathWitness.add(firstDataFlowPath);
    }

    public static PathTrackingWeight one() {
        if (one == null) {
            one = new PathTrackingWeight("ONE");
        }
        return one;
    }

    public Weight extendWith(Weight o) {
        LinkedHashSet combinedPath;
        if (!(o instanceof PathTrackingWeight)) {
            throw new RuntimeException("Cannot extend to different types of weight!");
        }
        PathTrackingWeight other = (PathTrackingWeight)o;
        LinkedHashSet<Node<ControlFlowGraph.Edge, Val>> newAllStatements = new LinkedHashSet<Node<ControlFlowGraph.Edge, Val>>();
        newAllStatements.addAll(this.shortestPathWitness);
        newAllStatements.addAll(other.shortestPathWitness);
        LinkedHashSet<LinkedHashSet<Node<ControlFlowGraph.Edge, Val>>> newAllPathStatements = new LinkedHashSet<LinkedHashSet<Node<ControlFlowGraph.Edge, Val>>>();
        for (LinkedHashSet<Node<ControlFlowGraph.Edge, Val>> pathPrefix : this.allPathWitness) {
            for (LinkedHashSet<Node<ControlFlowGraph.Edge, Val>> pathSuffix : other.allPathWitness) {
                LinkedHashSet combinedPath2 = Sets.newLinkedHashSet();
                combinedPath2.addAll(pathPrefix);
                combinedPath2.addAll(pathSuffix);
                newAllPathStatements.add(combinedPath2);
            }
        }
        if (this.allPathWitness.isEmpty()) {
            for (LinkedHashSet<Node<ControlFlowGraph.Edge, Val>> pathSuffix : other.allPathWitness) {
                combinedPath = Sets.newLinkedHashSet();
                combinedPath.addAll(pathSuffix);
                newAllPathStatements.add(combinedPath);
            }
        }
        if (other.allPathWitness.isEmpty()) {
            for (LinkedHashSet<Node<ControlFlowGraph.Edge, Val>> pathSuffix : this.allPathWitness) {
                combinedPath = Sets.newLinkedHashSet();
                combinedPath.addAll(pathSuffix);
                newAllPathStatements.add(combinedPath);
            }
        }
        return new PathTrackingWeight(newAllStatements, newAllPathStatements);
    }

    public Weight combineWith(Weight o) {
        LinkedHashSet combinedPath;
        if (!(o instanceof PathTrackingWeight)) {
            throw new RuntimeException("Cannot extend to different types of weight!");
        }
        PathTrackingWeight other = (PathTrackingWeight)o;
        LinkedHashSet<LinkedHashSet<Node<ControlFlowGraph.Edge, Val>>> newAllPathStatements = new LinkedHashSet<LinkedHashSet<Node<ControlFlowGraph.Edge, Val>>>();
        for (LinkedHashSet<Node<ControlFlowGraph.Edge, Val>> pathPrefix : this.allPathWitness) {
            combinedPath = Sets.newLinkedHashSet();
            combinedPath.addAll(pathPrefix);
            newAllPathStatements.add(combinedPath);
        }
        for (LinkedHashSet<Node<ControlFlowGraph.Edge, Val>> pathPrefix : other.allPathWitness) {
            combinedPath = Sets.newLinkedHashSet();
            combinedPath.addAll(pathPrefix);
            newAllPathStatements.add(combinedPath);
        }
        if (this.shortestPathWitness.size() > other.shortestPathWitness.size()) {
            return new PathTrackingWeight(new LinkedHashSet<Node<ControlFlowGraph.Edge, Val>>(other.shortestPathWitness), newAllPathStatements);
        }
        return new PathTrackingWeight(new LinkedHashSet<Node<ControlFlowGraph.Edge, Val>>(this.shortestPathWitness), newAllPathStatements);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.shortestPathWitness == null ? 0 : this.shortestPathWitness.hashCode());
        result = 31 * result + (this.rep == null ? 0 : this.rep.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PathTrackingWeight other = (PathTrackingWeight)((Object)obj);
        if (this.shortestPathWitness == null ? other.shortestPathWitness != null : !this.shortestPathWitness.equals(other.shortestPathWitness)) {
            return false;
        }
        if (this.allPathWitness == null ? other.allPathWitness != null : !this.allPathWitness.equals(other.allPathWitness)) {
            return false;
        }
        return !(this.rep == null ? other.rep != null : !this.rep.equals(other.rep));
    }

    public String toString() {
        return "\nAll statements: " + this.shortestPathWitness;
    }

    public List<Node<ControlFlowGraph.Edge, Val>> getShortestPathWitness() {
        return Lists.newArrayList(this.shortestPathWitness);
    }

    public Set<LinkedHashSet<Node<ControlFlowGraph.Edge, Val>>> getAllPathWitness() {
        return Sets.newHashSet(this.allPathWitness);
    }
}

