/*
 * Decompiled with CFR 0.152.
 */
package boomerang.scene;

import boomerang.scene.Field;
import boomerang.scene.Method;
import boomerang.scene.Statement;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class CallGraph {
    private Set<Edge> edges = Sets.newHashSet();
    private Multimap<Statement, Edge> edgesOutOf = HashMultimap.create();
    private Multimap<Method, Edge> edgesInto = HashMultimap.create();
    private Set<Method> entryPoints = Sets.newHashSet();
    private Multimap<Field, Statement> fieldLoadStatements = HashMultimap.create();
    private Multimap<Field, Statement> fieldStoreStatements = HashMultimap.create();

    public Collection<Edge> edgesOutOf(Statement stmt) {
        return this.edgesOutOf.get((Object)stmt);
    }

    public boolean addEdge(Edge edge) {
        this.edgesOutOf.put((Object)edge.callSite, (Object)edge);
        this.edgesInto.put((Object)edge.tgt(), (Object)edge);
        this.computeStaticFieldsLoadAndStores(edge.tgt());
        return this.edges.add(edge);
    }

    public Collection<Edge> edgesInto(Method m) {
        return this.edgesInto.get((Object)m);
    }

    public int size() {
        return this.edges.size();
    }

    public Set<Edge> getEdges() {
        return this.edges;
    }

    public Collection<Method> getEntryPoints() {
        return this.entryPoints;
    }

    public boolean addEntryPoint(Method m) {
        this.computeStaticFieldsLoadAndStores(m);
        return this.entryPoints.add(m);
    }

    public Set<Method> getReachableMethods() {
        HashSet reachableMethod = Sets.newHashSet();
        reachableMethod.addAll(this.entryPoints);
        reachableMethod.addAll(this.edgesInto.keySet());
        return reachableMethod;
    }

    public Multimap<Field, Statement> getFieldStoreStatements() {
        return this.fieldStoreStatements;
    }

    public Multimap<Field, Statement> getFieldLoadStatements() {
        return this.fieldLoadStatements;
    }

    private void computeStaticFieldsLoadAndStores(Method m) {
        for (Statement s : m.getStatements()) {
            if (s.isStaticFieldStore()) {
                this.fieldStoreStatements.put((Object)s.getStaticField().field(), (Object)s);
            }
            if (!s.isStaticFieldLoad()) continue;
            this.fieldLoadStatements.put((Object)s.getStaticField().field(), (Object)s);
        }
    }

    public static class Edge {
        private final Statement callSite;
        private final Method callee;

        public Edge(Statement callSite, Method callee) {
            assert (callSite.containsInvokeExpr());
            this.callSite = callSite;
            this.callee = callee;
        }

        public Method tgt() {
            return this.callee;
        }

        public Statement src() {
            return this.callSite;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.callSite == null ? 0 : this.callSite.hashCode());
            result = 31 * result + (this.callee == null ? 0 : this.callee.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Edge other = (Edge)obj;
            if (this.callSite == null ? other.callSite != null : !this.callSite.equals(other.callSite)) {
                return false;
            }
            return !(this.callee == null ? other.callee != null : !this.callee.equals(other.callee));
        }

        public String toString() {
            return "Call Graph Edge: " + this.callSite + " calls " + this.tgt();
        }
    }
}

