/*
 * Decompiled with CFR 0.152.
 */
package boomerang.scene;

import boomerang.scene.Method;
import boomerang.scene.Pair;
import boomerang.scene.Statement;
import java.util.Collection;
import java.util.List;
import wpds.interfaces.Location;

public interface ControlFlowGraph {
    public Collection<Statement> getStartPoints();

    public Collection<Statement> getEndPoints();

    public Collection<Statement> getSuccsOf(Statement var1);

    public Collection<Statement> getPredsOf(Statement var1);

    public List<Statement> getStatements();

    public static class Edge
    extends Pair<Statement, Statement>
    implements Location {
        public Edge(Statement start, Statement target) {
            super(start, target);
            if (!start.equals(Statement.epsilon()) && !start.getMethod().equals(target.getMethod())) {
                throw new RuntimeException("Illegal Control Flow Graph Edge constructed");
            }
        }

        @Override
        public String toString() {
            return this.getStart() + " -> " + this.getTarget();
        }

        public Statement getStart() {
            return (Statement)this.getX();
        }

        public Statement getTarget() {
            return (Statement)this.getY();
        }

        public Method getMethod() {
            return this.getStart().getMethod();
        }

        public boolean accepts(Location other) {
            return this.equals(other);
        }
    }
}

