/*
 * Decompiled with CFR 0.152.
 */
package boomerang.scene;

import com.google.common.base.Objects;
import wpds.interfaces.Empty;
import wpds.interfaces.Location;
import wpds.wildcard.ExclusionWildcard;
import wpds.wildcard.Wildcard;

public class Field
implements Location {
    private final String rep;

    private Field(String rep) {
        this.rep = rep;
    }

    protected Field() {
        this.rep = null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rep == null ? 0 : this.rep.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Field other = (Field)obj;
        return !(this.rep == null ? other.rep != null : !this.rep.equals(other.rep));
    }

    public String toString() {
        return this.rep;
    }

    public static Field wildcard() {
        return new WildcardField();
    }

    public static Field empty() {
        return new EmptyField("{}");
    }

    public static Field string(String key) {
        return new Field(key);
    }

    public static Field epsilon() {
        return new EmptyField("eps_f");
    }

    public static Field array(int index) {
        if (index == -1) {
            return new ArrayField();
        }
        return new ArrayField(index);
    }

    public static Field exclusionWildcard(Field exclusion) {
        return new ExclusionWildcardField(exclusion);
    }

    public boolean accepts(Location other) {
        return this.equals(other);
    }

    public boolean isInnerClassField() {
        return false;
    }

    public static class ArrayField
    extends Field {
        int index = -1;

        private ArrayField(int index) {
            super("array");
            if (index < 0) {
                throw new RuntimeException("Illegal Array field construction");
            }
            this.index = index;
        }

        public ArrayField() {
            super("array");
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ArrayField that = (ArrayField)o;
            return this.index == that.index;
        }

        @Override
        public String toString() {
            return super.toString() + (this.index == -1 ? " ANY_INDEX" : "Index: " + this.index);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.index});
        }

        @Override
        public boolean accepts(Location other) {
            if (this.equals(other)) {
                return true;
            }
            return this.index == -1 && other instanceof ArrayField;
        }

        public int getIndex() {
            return this.index;
        }
    }

    private static class ExclusionWildcardField
    extends Field
    implements ExclusionWildcard<Field> {
        private final Field excludes;

        public ExclusionWildcardField(Field excl) {
            this.excludes = excl;
        }

        public Field excludes() {
            return this.excludes;
        }

        @Override
        public String toString() {
            return "not " + this.excludes;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.excludes == null ? 0 : this.excludes.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExclusionWildcardField other = (ExclusionWildcardField)obj;
            return !(this.excludes == null ? other.excludes != null : !this.excludes.equals(other.excludes));
        }
    }

    private static class WildcardField
    extends Field
    implements Wildcard {
        public WildcardField() {
            super("*");
        }
    }

    private static class EmptyField
    extends Field
    implements Empty {
        public EmptyField(String rep) {
            super(rep);
        }
    }
}

