/*
 * Decompiled with CFR 0.152.
 */
package boomerang.scene;

import boomerang.scene.DataFlowScope;
import boomerang.scene.DeclaredMethod;
import boomerang.scene.Method;
import boomerang.scene.jimple.JimpleDeclaredMethod;
import boomerang.scene.jimple.JimpleMethod;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.MethodOrMethodContext;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.util.queue.QueueReader;

public class SootDataFlowScope {
    private static final Logger LOGGER = LoggerFactory.getLogger(SootDataFlowScope.class);
    private static final String HASH_CODE_SUB_SIG = "int hashCode()";
    private static final String TO_STRING_SUB_SIG = "java.lang.String toString()";
    private static final String EQUALS_SUB_SIG = "boolean equals(java.lang.Object)";
    private static final String CLONE_SIG = "java.lang.Object clone()";
    public static Predicate<SootClass>[] classFilters;
    public static Predicate<SootMethod>[] methodFilters;

    public static DataFlowScope make(Scene scene) {
        SootDataFlowScope.reset();
        return new DataFlowScope(){

            @Override
            public boolean isExcluded(DeclaredMethod method) {
                JimpleDeclaredMethod m = (JimpleDeclaredMethod)method;
                return ((SootClass)m.getDeclaringClass().getDelegate()).isPhantom() || m.isNative();
            }

            @Override
            public boolean isExcluded(Method method) {
                JimpleMethod m = (JimpleMethod)method;
                return ((SootClass)m.getDeclaringClass().getDelegate()).isPhantom() || m.isNative();
            }
        };
    }

    public static DataFlowScope excludeComplex(Scene scene) {
        SootDataFlowScope.reset();
        return new DataFlowScope(){

            @Override
            public boolean isExcluded(DeclaredMethod method) {
                JimpleDeclaredMethod m = (JimpleDeclaredMethod)method;
                for (Predicate<SootClass> predicate : classFilters) {
                    if (!predicate.apply((Object)((SootClass)m.getDeclaringClass().getDelegate()))) continue;
                    return true;
                }
                for (Predicate<SootClass> predicate : methodFilters) {
                    if (!predicate.apply((Object)((SootMethod)m.getDelegate()))) continue;
                    return true;
                }
                return ((SootClass)m.getDeclaringClass().getDelegate()).isPhantom() || m.isNative();
            }

            @Override
            public boolean isExcluded(Method method) {
                JimpleMethod m = (JimpleMethod)method;
                for (Predicate<SootClass> predicate : classFilters) {
                    if (!predicate.apply((Object)((SootClass)m.getDeclaringClass().getDelegate()))) continue;
                    return true;
                }
                for (Predicate<SootClass> predicate : methodFilters) {
                    if (!predicate.apply((Object)m.getDelegate())) continue;
                    return true;
                }
                return ((SootClass)m.getDeclaringClass().getDelegate()).isPhantom() || m.isNative();
            }
        };
    }

    private static void reset() {
        classFilters = new Predicate[]{new MapFilter(), new IterableFilter()};
        methodFilters = new Predicate[]{new SubSignatureFilter(HASH_CODE_SUB_SIG), new SubSignatureFilter(TO_STRING_SUB_SIG), new SubSignatureFilter(EQUALS_SUB_SIG), new SubSignatureFilter(CLONE_SIG)};
    }

    private static class SubSignatureFilter
    implements Predicate<SootMethod> {
        private Set<SootMethod> excludes = Sets.newHashSet();

        public SubSignatureFilter(String subSig) {
            QueueReader l = Scene.v().getReachableMethods().listener();
            while (l.hasNext()) {
                SootMethod m = ((MethodOrMethodContext)l.next()).method();
                if (!m.getSubSignature().equals(subSig)) continue;
                this.excludes.add(m);
            }
            if (this.excludes.isEmpty()) {
                LOGGER.debug("Excludes empty for {}", (Object)subSig);
            }
        }

        public boolean apply(SootMethod m) {
            return this.excludes.contains(m);
        }
    }

    private static class IterableFilter
    implements Predicate<SootClass> {
        private static final String ITERABLE = "java.lang.Iterable";
        private Set<SootClass> excludes = Sets.newHashSet();

        public IterableFilter() {
            List iterableSubClasses = Scene.v().getActiveHierarchy().getImplementersOf(Scene.v().getSootClass(ITERABLE));
            this.excludes.addAll(iterableSubClasses);
            for (SootClass c : Scene.v().getClasses()) {
                if (!c.hasOuterClass() || !this.excludes.contains(c.getOuterClass())) continue;
                this.excludes.add(c);
            }
            if (this.excludes.isEmpty()) {
                LOGGER.debug("Excludes empty for {}", (Object)ITERABLE);
            }
        }

        public boolean apply(SootClass c) {
            return this.excludes.contains(c);
        }
    }

    private static class MapFilter
    implements Predicate<SootClass> {
        private static final String MAP = "java.util.Map";
        private static final String GUAVA_MAP = "com.google.common.collect.Multimap";
        private Set<SootClass> excludes = Sets.newHashSet();

        public MapFilter() {
            SootClass c;
            List mapSubClasses = Scene.v().getActiveHierarchy().getImplementersOf(Scene.v().getSootClass(MAP));
            this.excludes.add(Scene.v().getSootClass(MAP));
            this.excludes.addAll(mapSubClasses);
            if (Scene.v().containsClass(GUAVA_MAP) && (c = Scene.v().getSootClass(GUAVA_MAP)).isInterface()) {
                this.excludes.addAll(Scene.v().getActiveHierarchy().getImplementersOf(c));
            }
            for (SootClass c2 : Scene.v().getClasses()) {
                if (!c2.hasOuterClass() || !this.excludes.contains(c2.getOuterClass())) continue;
                this.excludes.add(c2);
            }
            if (this.excludes.isEmpty()) {
                LOGGER.debug("Excludes empty for {}", (Object)MAP);
            }
        }

        public boolean apply(SootClass c) {
            return this.excludes.contains(c);
        }
    }
}

