/*
 * Decompiled with CFR 0.152.
 */
package boomerang.scene;

import boomerang.scene.Field;
import boomerang.scene.IfStatement;
import boomerang.scene.InvokeExpr;
import boomerang.scene.Method;
import boomerang.scene.Pair;
import boomerang.scene.StaticFieldVal;
import boomerang.scene.Val;
import java.util.Collection;
import wpds.interfaces.Empty;
import wpds.interfaces.Location;

public abstract class Statement
implements Location {
    private static Statement epsilon;
    private final String rep;
    protected final Method method;

    protected Statement(Method method) {
        this.rep = null;
        this.method = method;
    }

    private Statement(String rep) {
        this.rep = rep;
        this.method = null;
    }

    public static Statement epsilon() {
        if (epsilon == null) {
            epsilon = new EpsStatement();
        }
        return epsilon;
    }

    public String toString() {
        return this.rep;
    }

    public Method getMethod() {
        return this.method;
    }

    public abstract boolean containsStaticFieldAccess();

    public abstract boolean containsInvokeExpr();

    public abstract Field getWrittenField();

    public abstract boolean isFieldWriteWithBase(Val var1);

    public abstract Field getLoadedField();

    public abstract boolean isFieldLoadWithBase(Val var1);

    public boolean isParameter(Val value) {
        if (this.containsInvokeExpr()) {
            InvokeExpr invokeExpr = this.getInvokeExpr();
            if (invokeExpr.isInstanceInvokeExpr() && invokeExpr.getBase().equals(value)) {
                return true;
            }
            for (Val arg : invokeExpr.getArgs()) {
                if (!arg.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public int getParameter(Val value) {
        if (this.containsInvokeExpr()) {
            InvokeExpr invokeExpr = this.getInvokeExpr();
            if (invokeExpr.isInstanceInvokeExpr() && invokeExpr.getBase().equals(value)) {
                return -2;
            }
            int index = 0;
            for (Val arg : invokeExpr.getArgs()) {
                if (arg.equals(value)) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    public boolean isReturnOperator(Val val) {
        if (this.isReturnStmt()) {
            return this.getReturnOp().equals(val);
        }
        return false;
    }

    public boolean uses(Val value) {
        if (value.isStatic()) {
            return true;
        }
        if (this.assignsValue(value)) {
            return true;
        }
        if (this.isFieldStore() && this.getFieldStore().getX().equals(value)) {
            return true;
        }
        if (this.isReturnOperator(value)) {
            return true;
        }
        return this.isParameter(value);
    }

    public boolean assignsValue(Val value) {
        return this.isAssign() && this.getLeftOp().equals(value);
    }

    public abstract boolean isAssign();

    public abstract Val getLeftOp();

    public abstract Val getRightOp();

    public abstract boolean isInstanceOfStatement(Val var1);

    public abstract boolean isCast();

    public abstract boolean isPhiStatement();

    public abstract InvokeExpr getInvokeExpr();

    public abstract boolean isReturnStmt();

    public abstract boolean isThrowStmt();

    public abstract boolean isIfStmt();

    public abstract IfStatement getIfStmt();

    public abstract Val getReturnOp();

    public abstract boolean isMultiArrayAllocation();

    public abstract boolean isStringAllocation();

    public abstract boolean isFieldStore();

    public abstract boolean isArrayStore();

    public abstract boolean isArrayLoad();

    public abstract boolean isFieldLoad();

    public abstract boolean isIdentityStmt();

    public abstract Pair<Val, Field> getFieldStore();

    public abstract Pair<Val, Field> getFieldLoad();

    public abstract boolean isStaticFieldLoad();

    public abstract boolean isStaticFieldStore();

    public abstract StaticFieldVal getStaticField();

    public abstract boolean killAtIfStmt(Val var1, Statement var2);

    public abstract Collection<Val> getPhiVals();

    public abstract Pair<Val, Integer> getArrayBase();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.rep == null ? 0 : this.rep.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Statement other = (Statement)obj;
        if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
            return false;
        }
        return !(this.rep == null ? other.rep != null : !this.rep.equals(other.rep));
    }

    public abstract int getStartLineNumber();

    public abstract int getStartColumnNumber();

    public abstract int getEndLineNumber();

    public abstract int getEndColumnNumber();

    public abstract boolean isCatchStmt();

    public boolean accepts(Location other) {
        return this.equals(other);
    }

    private static class EpsStatement
    extends Statement
    implements Empty {
        public EpsStatement() {
            super("Eps_s");
        }

        @Override
        public Method getMethod() {
            return null;
        }

        @Override
        public boolean containsStaticFieldAccess() {
            return false;
        }

        @Override
        public boolean containsInvokeExpr() {
            return false;
        }

        @Override
        public Field getWrittenField() {
            return null;
        }

        @Override
        public boolean isFieldWriteWithBase(Val base) {
            return false;
        }

        @Override
        public Field getLoadedField() {
            return null;
        }

        @Override
        public boolean isFieldLoadWithBase(Val base) {
            return false;
        }

        @Override
        public boolean isParameter(Val value) {
            return false;
        }

        @Override
        public boolean assignsValue(Val value) {
            return false;
        }

        @Override
        public boolean isReturnOperator(Val val) {
            return false;
        }

        @Override
        public boolean uses(Val value) {
            return false;
        }

        @Override
        public boolean isAssign() {
            return false;
        }

        @Override
        public Val getLeftOp() {
            return null;
        }

        @Override
        public Val getRightOp() {
            return null;
        }

        @Override
        public boolean isInstanceOfStatement(Val fact) {
            return false;
        }

        @Override
        public boolean isCast() {
            return false;
        }

        @Override
        public InvokeExpr getInvokeExpr() {
            return null;
        }

        @Override
        public boolean isReturnStmt() {
            return false;
        }

        @Override
        public boolean isThrowStmt() {
            return false;
        }

        @Override
        public boolean isIfStmt() {
            return false;
        }

        @Override
        public IfStatement getIfStmt() {
            return null;
        }

        @Override
        public Val getReturnOp() {
            return null;
        }

        @Override
        public boolean isMultiArrayAllocation() {
            return false;
        }

        @Override
        public boolean isStringAllocation() {
            return false;
        }

        @Override
        public boolean isFieldStore() {
            return false;
        }

        @Override
        public boolean isArrayStore() {
            return false;
        }

        @Override
        public boolean isArrayLoad() {
            return false;
        }

        @Override
        public boolean isFieldLoad() {
            return false;
        }

        @Override
        public boolean isIdentityStmt() {
            return false;
        }

        @Override
        public boolean killAtIfStmt(Val fact, Statement successor) {
            return false;
        }

        @Override
        public Pair<Val, Field> getFieldStore() {
            return null;
        }

        @Override
        public Pair<Val, Field> getFieldLoad() {
            return null;
        }

        @Override
        public boolean isStaticFieldLoad() {
            return false;
        }

        @Override
        public boolean isStaticFieldStore() {
            return false;
        }

        @Override
        public StaticFieldVal getStaticField() {
            return null;
        }

        @Override
        public boolean isPhiStatement() {
            return false;
        }

        @Override
        public Collection<Val> getPhiVals() {
            return null;
        }

        @Override
        public Pair<Val, Integer> getArrayBase() {
            return null;
        }

        @Override
        public int getStartLineNumber() {
            return 0;
        }

        @Override
        public int getStartColumnNumber() {
            return 0;
        }

        @Override
        public int getEndColumnNumber() {
            return 0;
        }

        @Override
        public int getEndLineNumber() {
            return 0;
        }

        @Override
        public boolean isCatchStmt() {
            return false;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }
    }
}

