/*
 * Decompiled with CFR 0.152.
 */
package boomerang.scene.jimple;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.BodyTransformer;
import soot.MethodOrMethodContext;
import soot.RefType;
import soot.Scene;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.ClassConstant;
import soot.jimple.Constant;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.NullConstant;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.internal.JAssignStmt;
import soot.jimple.internal.JInstanceFieldRef;
import soot.jimple.internal.JNopStmt;
import soot.jimple.internal.JReturnStmt;
import soot.jimple.internal.JimpleLocal;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.tagkit.AttributeValueException;
import soot.tagkit.Host;
import soot.tagkit.LineNumberTag;
import soot.tagkit.Tag;
import soot.util.Chain;
import soot.util.queue.QueueReader;

public class BoomerangPretransformer
extends BodyTransformer {
    public static boolean TRANSFORM_CONSTANTS = true;
    public static String UNITIALIZED_FIELD_TAG_NAME = "UnitializedField";
    public static Tag UNITIALIZED_FIELD_TAG = new Tag(){

        public String getName() {
            return UNITIALIZED_FIELD_TAG_NAME;
        }

        public byte[] getValue() throws AttributeValueException {
            return new byte[0];
        }
    };
    private static BoomerangPretransformer instance;
    private int replaceCounter;
    private boolean applied;

    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        this.addNopStmtToMethods(b);
        if (TRANSFORM_CONSTANTS) {
            this.transformConstantAtFieldWrites(b);
        }
    }

    private void transformConstantAtFieldWrites(Body body) {
        Set<Unit> cwnc = this.getStmtsWithConstants(body);
        for (Unit u : cwnc) {
            JReturnStmt other;
            JAssignStmt newUnit;
            JimpleLocal paramVal;
            String label;
            AssignStmt assignStmt;
            if (u instanceof AssignStmt && this.isFieldRef((assignStmt = (AssignStmt)u).getLeftOp()) && assignStmt.getRightOp() instanceof Constant && !(assignStmt.getRightOp() instanceof ClassConstant)) {
                label = "varReplacer" + new Integer(this.replaceCounter++).toString();
                paramVal = new JimpleLocal(label, assignStmt.getRightOp().getType());
                newUnit = new JAssignStmt((Value)paramVal, assignStmt.getRightOp());
                body.getLocals().add((Object)paramVal);
                body.getUnits().insertBefore((Unit)newUnit, u);
                other = new JAssignStmt(assignStmt.getLeftOp(), (Value)paramVal);
                other.addAllTagsOf((Host)u);
                body.getUnits().insertBefore((Unit)other, u);
                body.getUnits().remove((Object)u);
            }
            if (u instanceof Stmt && ((Stmt)u).containsInvokeExpr() && !u.toString().contains("test.assertions.Assertions:") && !u.toString().contains("intQueryFor")) {
                Stmt stmt = (Stmt)u;
                if (stmt.getInvokeExpr().getMethod().getSignature().equals("<java.math.BigInteger: java.math.BigInteger valueOf(long)>")) continue;
                List useBoxes = stmt.getInvokeExpr().getUseBoxes();
                for (Value v : stmt.getInvokeExpr().getArgs()) {
                    if (!(v instanceof Constant) || v instanceof ClassConstant) continue;
                    String label2 = "varReplacer" + new Integer(this.replaceCounter++).toString();
                    JimpleLocal paramVal2 = new JimpleLocal(label2, v.getType());
                    JAssignStmt newUnit2 = new JAssignStmt((Value)paramVal2, v);
                    newUnit2.addAllTagsOf((Host)u);
                    body.getLocals().add((Object)paramVal2);
                    body.getUnits().insertBefore((Unit)newUnit2, u);
                    for (ValueBox b : useBoxes) {
                        this.backPropagateSourceLineTags(b, (AssignStmt)newUnit2);
                        if (!b.getValue().equals(v)) continue;
                        b.setValue((Value)paramVal2);
                    }
                }
            }
            if (!(u instanceof ReturnStmt)) continue;
            ReturnStmt returnStmt = (ReturnStmt)u;
            label = "varReplacer" + new Integer(this.replaceCounter++).toString();
            paramVal = new JimpleLocal(label, returnStmt.getOp().getType());
            newUnit = new JAssignStmt((Value)paramVal, returnStmt.getOp());
            newUnit.addAllTagsOf((Host)u);
            body.getLocals().add((Object)paramVal);
            body.getUnits().insertBefore((Unit)newUnit, u);
            other = new JReturnStmt((Value)paramVal);
            body.getUnits().insertBefore((Unit)other, u);
            body.getUnits().remove((Object)u);
        }
    }

    private void backPropagateSourceLineTags(ValueBox valueBox, AssignStmt assignStmt) {
        Tag tag = valueBox.getTag("SourceLnPosTag");
        if (tag != null) {
            assignStmt.removeTag("SourceLnPosTag");
            assignStmt.addTag(tag);
        }
        if ((tag = valueBox.getTag("LineNumberTag")) != null) {
            assignStmt.removeTag("LineNumberTag");
            assignStmt.addTag(tag);
        }
    }

    private void addNopStmtToMethods(Body b) {
        JNopStmt nopStmt = new JNopStmt();
        for (Unit u : b.getUnits()) {
            if (u.getJavaSourceStartLineNumber() <= 0) continue;
            nopStmt.addAllTagsOf((Host)u);
            break;
        }
        b.getUnits().insertBefore((Unit)nopStmt, b.getUnits().getFirst());
        HashSet ifStmts = Sets.newHashSet();
        for (Unit u : b.getUnits()) {
            if (!(u instanceof IfStmt)) continue;
            ifStmts.add((IfStmt)u);
        }
        for (IfStmt ifStmt : ifStmts) {
            nopStmt = new JNopStmt();
            nopStmt.addAllTagsOf((Host)ifStmt);
            b.getUnits().insertAfter((Unit)nopStmt, (Unit)ifStmt);
            Stmt target = ifStmt.getTarget();
            nopStmt = new JNopStmt();
            nopStmt.addAllTagsOf((Host)target);
            b.getUnits().insertBefore((Unit)nopStmt, (Unit)target);
            ifStmt.setTarget((Unit)nopStmt);
        }
    }

    private Set<Unit> getStmtsWithConstants(Body methodBody) {
        HashSet retMap = Sets.newHashSet();
        for (Unit u : methodBody.getUnits()) {
            AssignStmt assignStmt;
            if (u instanceof AssignStmt && this.isFieldRef((assignStmt = (AssignStmt)u).getLeftOp()) && assignStmt.getRightOp() instanceof Constant) {
                retMap.add(u);
            }
            if (u instanceof Stmt && ((Stmt)u).containsInvokeExpr()) {
                Stmt stmt = (Stmt)u;
                for (Value v : stmt.getInvokeExpr().getArgs()) {
                    if (!(v instanceof Constant)) continue;
                    retMap.add(u);
                }
            }
            if (!(u instanceof ReturnStmt) || !((assignStmt = (ReturnStmt)u).getOp() instanceof Constant)) continue;
            retMap.add(u);
        }
        return retMap;
    }

    private boolean isFieldRef(Value op) {
        return op instanceof InstanceFieldRef || op instanceof StaticFieldRef || op instanceof ArrayRef;
    }

    public void apply() {
        if (this.applied) {
            return;
        }
        ReachableMethods reachableMethods = Scene.v().getReachableMethods();
        QueueReader listener = reachableMethods.listener();
        while (listener.hasNext()) {
            SootMethod method = ((MethodOrMethodContext)listener.next()).method();
            if (!method.hasActiveBody()) continue;
            if (method.isConstructor()) {
                BoomerangPretransformer.addNulliefiedFields(method);
            }
            this.internalTransform(method.getActiveBody(), "", new HashMap<String, String>());
        }
        this.applied = true;
    }

    private static void addNulliefiedFields(SootMethod cons) {
        Chain fields = cons.getDeclaringClass().getFields();
        UnitPatchingChain units = cons.getActiveBody().getUnits();
        Set<SootField> fieldsDefinedInMethod = BoomerangPretransformer.getFieldsDefinedInMethod(cons, Sets.newHashSet());
        for (SootField f : fields) {
            if (fieldsDefinedInMethod.contains(f) || f.isStatic() || f.isFinal() || !(f.getType() instanceof RefType)) continue;
            JAssignStmt jAssignStmt = new JAssignStmt((Value)new JInstanceFieldRef((Value)cons.getActiveBody().getThisLocal(), f.makeRef()), (Value)NullConstant.v());
            jAssignStmt.addTag((Tag)new LineNumberTag(2));
            jAssignStmt.addTag(UNITIALIZED_FIELD_TAG);
            Unit lastIdentityStmt = BoomerangPretransformer.findLastIdentityStmt(units);
            if (lastIdentityStmt != null) {
                units.insertAfter((Unit)jAssignStmt, lastIdentityStmt);
                continue;
            }
            units.addFirst((Unit)jAssignStmt);
        }
    }

    private static Unit findLastIdentityStmt(UnitPatchingChain units) {
        for (Unit u : units) {
            if (u instanceof IdentityStmt && u instanceof AssignStmt) continue;
            return u;
        }
        return null;
    }

    private static Set<SootField> getFieldsDefinedInMethod(SootMethod cons, Set<SootMethod> visited) {
        HashSet res = Sets.newHashSet();
        if (!visited.add(cons)) {
            return res;
        }
        if (!cons.hasActiveBody()) {
            return res;
        }
        for (Unit u : cons.getActiveBody().getUnits()) {
            Stmt stmt;
            AssignStmt as;
            Value left;
            if (u instanceof AssignStmt && (left = (as = (AssignStmt)u).getLeftOp()) instanceof InstanceFieldRef) {
                InstanceFieldRef ifr = (InstanceFieldRef)left;
                res.add(ifr.getField());
            }
            if (!(u instanceof Stmt) || !(stmt = (Stmt)u).containsInvokeExpr() || !stmt.getInvokeExpr().getMethod().isConstructor()) continue;
            res.addAll(BoomerangPretransformer.getFieldsDefinedInMethod(stmt.getInvokeExpr().getMethod(), visited));
        }
        return res;
    }

    public boolean isApplied() {
        return this.applied;
    }

    public static BoomerangPretransformer v() {
        if (instance == null) {
            instance = new BoomerangPretransformer();
        }
        return instance;
    }

    public void reset() {
        instance = null;
    }
}

