/*
 * Decompiled with CFR 0.152.
 */
package boomerang.scene.jimple;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.NullConstant;
import soot.jimple.internal.JAssignStmt;
import soot.jimple.internal.JInstanceFieldRef;
import soot.util.Chain;

public class ExplicitNullifyFields {
    public static void apply() {
        for (SootClass c : Scene.v().getClasses()) {
            for (SootMethod m : c.getMethods()) {
                if (!m.hasActiveBody() || !m.isConstructor()) continue;
                ExplicitNullifyFields.apply(m);
            }
        }
    }

    private static void apply(SootMethod cons) {
        Chain fields = cons.getDeclaringClass().getFields();
        UnitPatchingChain units = cons.getActiveBody().getUnits();
        Set<SootField> fieldsDefinedInMethod = ExplicitNullifyFields.getFieldsDefinedInMethod(cons);
        for (SootField f : fields) {
            if (fieldsDefinedInMethod.contains(f) || f.isStatic() || f.isFinal() || !(f.getType() instanceof RefType)) continue;
            units.addFirst((Unit)new JAssignStmt((Value)new JInstanceFieldRef((Value)cons.getActiveBody().getThisLocal(), f.makeRef()), (Value)NullConstant.v()));
        }
    }

    private static Set<SootField> getFieldsDefinedInMethod(SootMethod cons) {
        HashSet res = Sets.newHashSet();
        for (Unit u : cons.getActiveBody().getUnits()) {
            AssignStmt as;
            Value left;
            if (!(u instanceof AssignStmt) || !((left = (as = (AssignStmt)u).getLeftOp()) instanceof InstanceFieldRef)) continue;
            InstanceFieldRef ifr = (InstanceFieldRef)left;
            res.add(ifr.getField());
        }
        return res;
    }
}

