/*
 * Decompiled with CFR 0.152.
 */
package boomerang.scene.jimple;

import boomerang.scene.ControlFlowGraph;
import boomerang.scene.Statement;
import boomerang.scene.jimple.JimpleMethod;
import boomerang.scene.jimple.JimpleStatement;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.jimple.IdentityStmt;
import soot.jimple.Stmt;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.DirectedGraph;

public class JimpleControlFlowGraph
implements ControlFlowGraph {
    protected DirectedGraph<Unit> graph;
    protected boolean cacheBuild = false;
    protected List<Statement> startPointCache = Lists.newArrayList();
    protected List<Statement> endPointCache = Lists.newArrayList();
    protected Multimap<Statement, Statement> succsOfCache = HashMultimap.create();
    protected Multimap<Statement, Statement> predsOfCache = HashMultimap.create();
    protected List<Statement> statements = Lists.newArrayList();
    protected JimpleMethod method;

    public JimpleControlFlowGraph() {
    }

    public JimpleControlFlowGraph(JimpleMethod method) {
        this.method = method;
        this.graph = new BriefUnitGraph(method.getDelegate().getActiveBody());
    }

    @Override
    public Collection<Statement> getStartPoints() {
        this.buildCache();
        return this.startPointCache;
    }

    protected void buildCache() {
        if (this.cacheBuild) {
            return;
        }
        this.cacheBuild = true;
        List heads = this.graph.getHeads();
        for (Object u : heads) {
            if (u instanceof IdentityStmt) continue;
            Statement stmt = JimpleStatement.create((Stmt)u, this.method);
            this.startPointCache.add(stmt);
        }
        List tails = this.graph.getTails();
        for (Unit u : tails) {
            Statement stmt = JimpleStatement.create((Stmt)u, this.method);
            this.endPointCache.add(stmt);
        }
        UnitPatchingChain units = this.method.getDelegate().getActiveBody().getUnits();
        for (Unit u : units) {
            Statement first = JimpleStatement.create((Stmt)u, this.method);
            this.statements.add(first);
            for (Unit succ : this.graph.getSuccsOf((Object)u)) {
                Statement succStmt = JimpleStatement.create((Stmt)succ, this.method);
                this.succsOfCache.put((Object)first, (Object)succStmt);
            }
            for (Unit pred : this.graph.getPredsOf((Object)u)) {
                Statement predStmt = JimpleStatement.create((Stmt)pred, this.method);
                this.predsOfCache.put((Object)first, (Object)predStmt);
            }
        }
    }

    @Override
    public Collection<Statement> getEndPoints() {
        this.buildCache();
        return this.endPointCache;
    }

    @Override
    public Collection<Statement> getSuccsOf(Statement curr) {
        this.buildCache();
        return this.succsOfCache.get((Object)curr);
    }

    @Override
    public Collection<Statement> getPredsOf(Statement curr) {
        this.buildCache();
        return this.predsOfCache.get((Object)curr);
    }

    @Override
    public List<Statement> getStatements() {
        this.buildCache();
        return this.statements;
    }
}

