/*
 * Decompiled with CFR 0.152.
 */
package boomerang.scene.jimple;

import boomerang.scene.ControlFlowGraph;
import boomerang.scene.Method;
import boomerang.scene.Statement;
import boomerang.scene.Val;
import boomerang.scene.WrappedClass;
import boomerang.scene.jimple.JimpleControlFlowGraph;
import boomerang.scene.jimple.JimpleVal;
import boomerang.scene.jimple.JimpleWrappedClass;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import soot.Local;
import soot.SootMethod;
import soot.Value;
import soot.util.Chain;

public class JimpleMethod
extends Method {
    private SootMethod delegate;
    protected static Interner<JimpleMethod> INTERNAL_POOL = Interners.newWeakInterner();
    protected ControlFlowGraph cfg;
    private List<Val> parameterLocalCache;
    private Set<Val> localCache;

    protected JimpleMethod(SootMethod m) {
        this.delegate = m;
        if (!m.hasActiveBody()) {
            throw new RuntimeException("Building a Jimple method without active body present");
        }
    }

    public static JimpleMethod of(SootMethod m) {
        return (JimpleMethod)INTERNAL_POOL.intern((Object)new JimpleMethod(m));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JimpleMethod other = (JimpleMethod)obj;
        return !(this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate));
    }

    @Override
    public String toString() {
        return this.delegate != null ? this.delegate.toString() : "METHOD EPS";
    }

    @Override
    public boolean isStaticInitializer() {
        return this.delegate.isStaticInitializer();
    }

    @Override
    public boolean isParameterLocal(Val val) {
        if (val.isStatic()) {
            return false;
        }
        if (!this.delegate.hasActiveBody()) {
            throw new RuntimeException("Soot Method has no active body");
        }
        List<Val> parameterLocals = this.getParameterLocals();
        return parameterLocals.contains(val);
    }

    @Override
    public boolean isThisLocal(Val val) {
        if (val.isStatic()) {
            return false;
        }
        if (!this.delegate.hasActiveBody()) {
            throw new RuntimeException("Soot Method has no active body");
        }
        if (this.delegate.isStatic()) {
            return false;
        }
        Val parameterLocals = this.getThisLocal();
        return parameterLocals.equals(val);
    }

    @Override
    public Set<Val> getLocals() {
        if (this.localCache == null) {
            this.localCache = Sets.newHashSet();
            Chain locals = this.delegate.getActiveBody().getLocals();
            for (Local l : locals) {
                this.localCache.add(new JimpleVal((Value)l, this));
            }
        }
        return this.localCache;
    }

    @Override
    public Val getThisLocal() {
        return new JimpleVal((Value)this.delegate.getActiveBody().getThisLocal(), this);
    }

    @Override
    public List<Val> getParameterLocals() {
        if (this.parameterLocalCache == null) {
            this.parameterLocalCache = Lists.newArrayList();
            for (Local v : this.delegate.getActiveBody().getParameterLocals()) {
                this.parameterLocalCache.add(new JimpleVal((Value)v, this));
            }
        }
        return this.parameterLocalCache;
    }

    @Override
    public boolean isStatic() {
        return this.delegate.isStatic();
    }

    @Override
    public boolean isNative() {
        return this.delegate.isNative();
    }

    @Override
    public List<Statement> getStatements() {
        return this.getControlFlowGraph().getStatements();
    }

    @Override
    public WrappedClass getDeclaringClass() {
        return new JimpleWrappedClass(this.delegate.getDeclaringClass());
    }

    @Override
    public ControlFlowGraph getControlFlowGraph() {
        if (this.cfg == null) {
            this.cfg = new JimpleControlFlowGraph(this);
        }
        return this.cfg;
    }

    @Override
    public String getSubSignature() {
        return this.delegate.getSubSignature();
    }

    public SootMethod getDelegate() {
        return this.delegate;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public boolean isConstructor() {
        return this.delegate.isConstructor();
    }

    @Override
    public boolean isPublic() {
        return this.delegate.isPublic();
    }
}

