/*
 * Decompiled with CFR 0.152.
 */
package boomerang.scene.jimple;

import boomerang.scene.Field;
import boomerang.scene.IfStatement;
import boomerang.scene.InvokeExpr;
import boomerang.scene.Method;
import boomerang.scene.Pair;
import boomerang.scene.Statement;
import boomerang.scene.StaticFieldVal;
import boomerang.scene.Val;
import boomerang.scene.jimple.BoomerangPretransformer;
import boomerang.scene.jimple.JimpleField;
import boomerang.scene.jimple.JimpleIfStatement;
import boomerang.scene.jimple.JimpleInvokeExpr;
import boomerang.scene.jimple.JimpleStaticFieldVal;
import boomerang.scene.jimple.JimpleVal;
import com.google.common.base.Joiner;
import java.util.Collection;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.ThrowStmt;
import soot.tagkit.SourceLnPosTag;

public class JimpleStatement
extends Statement {
    private final Stmt delegate;
    private final Method method;

    private JimpleStatement(Stmt delegate, Method m) {
        super(m);
        if (delegate == null) {
            throw new RuntimeException("Invalid, parameter may not be null");
        }
        this.delegate = delegate;
        this.method = m;
    }

    public static Statement create(Stmt delegate, Method m) {
        JimpleStatement jimpleStatement = new JimpleStatement(delegate, m);
        return jimpleStatement;
    }

    @Override
    public String toString() {
        return this.shortName(this.delegate);
    }

    private String shortName(Stmt s) {
        if (s.containsInvokeExpr()) {
            String base = "";
            if (s.getInvokeExpr() instanceof InstanceInvokeExpr) {
                InstanceInvokeExpr iie = (InstanceInvokeExpr)s.getInvokeExpr();
                base = iie.getBase().toString() + ".";
            }
            String assign = "";
            if (s instanceof AssignStmt) {
                assign = ((AssignStmt)s).getLeftOp() + " = ";
            }
            return assign + base + s.getInvokeExpr().getMethod().getName() + "(" + Joiner.on((String)",").join((Iterable)s.getInvokeExpr().getArgs()) + ")";
        }
        if (s instanceof IdentityStmt) {
            return s.toString();
        }
        if (s instanceof AssignStmt) {
            AssignStmt assignStmt = (AssignStmt)s;
            if (assignStmt.getLeftOp() instanceof InstanceFieldRef) {
                InstanceFieldRef ifr = (InstanceFieldRef)assignStmt.getLeftOp();
                return ifr.getBase() + "." + ifr.getField().getName() + " = " + assignStmt.getRightOp();
            }
            if (assignStmt.getRightOp() instanceof InstanceFieldRef) {
                InstanceFieldRef ifr = (InstanceFieldRef)assignStmt.getRightOp();
                return assignStmt.getLeftOp() + " = " + ifr.getBase() + "." + ifr.getField().getName();
            }
            if (assignStmt.getRightOp() instanceof NewExpr) {
                NewExpr newExpr = (NewExpr)assignStmt.getRightOp();
                return assignStmt.getLeftOp() + " = new " + newExpr.getBaseType().getSootClass().getShortName();
            }
        }
        return s.toString();
    }

    @Override
    public boolean containsStaticFieldAccess() {
        if (this.delegate instanceof AssignStmt) {
            AssignStmt assignStmt = (AssignStmt)this.delegate;
            return assignStmt.getLeftOp() instanceof StaticFieldRef || assignStmt.getRightOp() instanceof StaticFieldRef;
        }
        return false;
    }

    @Override
    public boolean containsInvokeExpr() {
        return this.delegate.containsInvokeExpr();
    }

    @Override
    public Field getWrittenField() {
        AssignStmt as = (AssignStmt)this.delegate;
        if (as.getLeftOp() instanceof StaticFieldRef) {
            StaticFieldRef staticFieldRef = (StaticFieldRef)as.getLeftOp();
            return new JimpleField(staticFieldRef.getField());
        }
        if (as.getLeftOp() instanceof ArrayRef) {
            return Field.array(this.getArrayBase().getY());
        }
        InstanceFieldRef ifr = (InstanceFieldRef)as.getLeftOp();
        return new JimpleField(ifr.getField());
    }

    @Override
    public boolean isFieldWriteWithBase(Val base) {
        if (this.isAssign() && this.isFieldStore()) {
            Pair<Val, Field> instanceFieldRef = this.getFieldStore();
            return instanceFieldRef.getX().equals(base);
        }
        if (this.isAssign() && this.isArrayStore()) {
            Pair<Val, Integer> arrayBase = this.getArrayBase();
            return arrayBase.getX().equals(base);
        }
        return false;
    }

    @Override
    public Field getLoadedField() {
        AssignStmt as = (AssignStmt)this.delegate;
        InstanceFieldRef ifr = (InstanceFieldRef)as.getRightOp();
        return new JimpleField(ifr.getField());
    }

    @Override
    public boolean isFieldLoadWithBase(Val base) {
        if (this.isAssign() && this.isFieldLoad()) {
            return this.getFieldLoad().getX().equals(base);
        }
        return false;
    }

    @Override
    public boolean isAssign() {
        return this.delegate instanceof AssignStmt;
    }

    @Override
    public Val getLeftOp() {
        assert (this.isAssign());
        AssignStmt assignStmt = (AssignStmt)this.delegate;
        return new JimpleVal(assignStmt.getLeftOp(), this.method);
    }

    @Override
    public Val getRightOp() {
        assert (this.isAssign());
        AssignStmt assignStmt = (AssignStmt)this.delegate;
        return new JimpleVal(assignStmt.getRightOp(), this.method);
    }

    @Override
    public boolean isInstanceOfStatement(Val fact) {
        if (this.isAssign() && this.getRightOp().isInstanceOfExpr()) {
            Val instanceOfOp = this.getRightOp().getInstanceOfOp();
            return instanceOfOp.equals(fact);
        }
        return false;
    }

    @Override
    public boolean isCast() {
        return this.delegate instanceof AssignStmt && ((AssignStmt)this.delegate).getRightOp() instanceof CastExpr;
    }

    @Override
    public InvokeExpr getInvokeExpr() {
        return new JimpleInvokeExpr(this.delegate.getInvokeExpr(), this.method);
    }

    @Override
    public boolean isReturnStmt() {
        return this.delegate instanceof ReturnStmt;
    }

    @Override
    public boolean isThrowStmt() {
        return this.delegate instanceof ThrowStmt;
    }

    @Override
    public boolean isIfStmt() {
        return this.delegate instanceof IfStmt;
    }

    @Override
    public IfStatement getIfStmt() {
        return new JimpleIfStatement((IfStmt)this.delegate, this.method);
    }

    @Override
    public Val getReturnOp() {
        assert (this.isReturnStmt());
        ReturnStmt assignStmt = (ReturnStmt)this.delegate;
        return new JimpleVal(assignStmt.getOp(), this.method);
    }

    @Override
    public boolean isMultiArrayAllocation() {
        return this.delegate instanceof AssignStmt && ((AssignStmt)this.delegate).getRightOp() instanceof NewMultiArrayExpr;
    }

    @Override
    public boolean isStringAllocation() {
        return this.delegate instanceof AssignStmt && ((AssignStmt)this.delegate).getRightOp() instanceof StringConstant;
    }

    @Override
    public boolean isFieldStore() {
        return this.delegate instanceof AssignStmt && ((AssignStmt)this.delegate).getLeftOp() instanceof InstanceFieldRef;
    }

    @Override
    public boolean isArrayStore() {
        return this.delegate instanceof AssignStmt && ((AssignStmt)this.delegate).getLeftOp() instanceof ArrayRef;
    }

    @Override
    public boolean isArrayLoad() {
        return this.delegate instanceof AssignStmt && ((AssignStmt)this.delegate).getRightOp() instanceof ArrayRef;
    }

    @Override
    public boolean isFieldLoad() {
        return this.delegate instanceof AssignStmt && ((AssignStmt)this.delegate).getRightOp() instanceof InstanceFieldRef;
    }

    @Override
    public boolean isIdentityStmt() {
        return this.delegate instanceof IdentityStmt;
    }

    public Stmt getDelegate() {
        return this.delegate;
    }

    public String getShortLabel() {
        if (this.delegate instanceof AssignStmt) {
            AssignStmt assignStmt = (AssignStmt)this.delegate;
            if (assignStmt.getRightOp() instanceof InstanceFieldRef) {
                InstanceFieldRef fr = (InstanceFieldRef)assignStmt.getRightOp();
                return assignStmt.getLeftOp() + " = " + fr.getBase() + "." + fr.getField().getName();
            }
            if (assignStmt.getLeftOp() instanceof InstanceFieldRef) {
                InstanceFieldRef fr = (InstanceFieldRef)assignStmt.getLeftOp();
                return fr.getBase() + "." + fr.getField().getName() + " = " + assignStmt.getRightOp();
            }
        }
        if (this.containsInvokeExpr()) {
            InvokeExpr invokeExpr = this.getInvokeExpr();
            if (invokeExpr.isStaticInvokeExpr()) {
                return (this.isAssign() ? this.getLeftOp() + " = " : "") + invokeExpr.getMethod() + "(" + invokeExpr.getArgs().toString().replace("[", "").replace("]", "") + ")";
            }
            if (invokeExpr.isInstanceInvokeExpr()) {
                return (this.isAssign() ? this.getLeftOp() + " = " : "") + invokeExpr.getBase() + "." + invokeExpr.getMethod() + "(" + invokeExpr.getArgs().toString().replace("[", "").replace("]", "") + ")";
            }
        }
        return this.delegate.toString();
    }

    @Override
    @Deprecated
    public boolean killAtIfStmt(Val fact, Statement successor) {
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JimpleStatement other = (JimpleStatement)obj;
        if (this.delegate == null) {
            return other.delegate == null;
        }
        return this.delegate.equals(other.delegate);
    }

    @Override
    public Pair<Val, Field> getFieldStore() {
        AssignStmt ins = (AssignStmt)this.delegate;
        InstanceFieldRef val = (InstanceFieldRef)ins.getLeftOp();
        return new Pair<Val, Field>(new JimpleVal(val.getBase(), this.method), new JimpleField(val.getField()));
    }

    @Override
    public Pair<Val, Field> getFieldLoad() {
        AssignStmt ins = (AssignStmt)this.delegate;
        InstanceFieldRef val = (InstanceFieldRef)ins.getRightOp();
        return new Pair<Val, Field>(new JimpleVal(val.getBase(), this.method), new JimpleField(val.getField()));
    }

    @Override
    public boolean isStaticFieldLoad() {
        return this.delegate instanceof AssignStmt && ((AssignStmt)this.delegate).getRightOp() instanceof StaticFieldRef;
    }

    @Override
    public boolean isStaticFieldStore() {
        return this.delegate instanceof AssignStmt && ((AssignStmt)this.delegate).getLeftOp() instanceof StaticFieldRef;
    }

    @Override
    public StaticFieldVal getStaticField() {
        StaticFieldRef v;
        if (this.isStaticFieldLoad()) {
            v = (StaticFieldRef)((AssignStmt)this.delegate).getRightOp();
        } else if (this.isStaticFieldStore()) {
            v = (StaticFieldRef)((AssignStmt)this.delegate).getLeftOp();
        } else {
            throw new RuntimeException("Error");
        }
        return new JimpleStaticFieldVal(new JimpleField(v.getField()), this.method);
    }

    @Override
    public boolean isPhiStatement() {
        return false;
    }

    @Override
    public Collection<Val> getPhiVals() {
        throw new RuntimeException("Not supported!");
    }

    @Override
    public Pair<Val, Integer> getArrayBase() {
        if (this.isArrayLoad()) {
            Val rightOp = this.getRightOp();
            return rightOp.getArrayBase();
        }
        if (this.isArrayStore()) {
            Val rightOp = this.getLeftOp();
            return rightOp.getArrayBase();
        }
        throw new RuntimeException("Dead code");
    }

    @Override
    public int getStartLineNumber() {
        return this.delegate.getJavaSourceStartLineNumber();
    }

    @Override
    public int getStartColumnNumber() {
        return this.delegate.getJavaSourceStartColumnNumber();
    }

    @Override
    public int getEndColumnNumber() {
        SourceLnPosTag tag = (SourceLnPosTag)this.delegate.getTag("SourceLnPosTag");
        if (tag != null) {
            return tag.endPos();
        }
        return -1;
    }

    @Override
    public int getEndLineNumber() {
        SourceLnPosTag tag = (SourceLnPosTag)this.delegate.getTag("SourceLnPosTag");
        if (tag != null) {
            return tag.endLn();
        }
        return -1;
    }

    @Override
    public boolean isCatchStmt() {
        return this.delegate instanceof IdentityStmt && ((IdentityStmt)this.delegate).getRightOp() instanceof CaughtExceptionRef;
    }

    public boolean isUnitializedFieldStatement() {
        return this.delegate.hasTag(BoomerangPretransformer.UNITIALIZED_FIELD_TAG_NAME);
    }
}

