/*
 * Decompiled with CFR 0.152.
 */
package boomerang.scene.jimple;

import boomerang.scene.Method;
import boomerang.scene.Type;
import boomerang.scene.WrappedClass;
import boomerang.scene.jimple.JimpleMethod;
import boomerang.scene.jimple.JimpleType;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import soot.SootClass;
import soot.SootMethod;

public class JimpleWrappedClass
implements WrappedClass {
    private SootClass delegate;
    private Set<Method> methods;

    public JimpleWrappedClass(SootClass delegate) {
        this.delegate = delegate;
    }

    @Override
    public Set<Method> getMethods() {
        List ms = this.delegate.getMethods();
        if (this.methods == null) {
            this.methods = Sets.newHashSet();
            for (SootMethod m : ms) {
                if (!m.hasActiveBody()) continue;
                this.methods.add(JimpleMethod.of(m));
            }
        }
        return this.methods;
    }

    @Override
    public boolean hasSuperclass() {
        return this.delegate.hasSuperclass();
    }

    @Override
    public WrappedClass getSuperclass() {
        return new JimpleWrappedClass(this.delegate.getSuperclass());
    }

    @Override
    public Type getType() {
        return new JimpleType((soot.Type)this.delegate.getType());
    }

    @Override
    public boolean isApplicationClass() {
        return this.delegate.isApplicationClass();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JimpleWrappedClass other = (JimpleWrappedClass)obj;
        return !(this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate));
    }

    @Override
    public String getFullyQualifiedName() {
        return this.delegate.getName();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }
}

