/*
 * Decompiled with CFR 0.152.
 */
package boomerang.scene.jimple;

import boomerang.scene.CallGraph;
import boomerang.scene.Statement;
import boomerang.scene.jimple.JimpleMethod;
import boomerang.scene.jimple.JimpleStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Scene;
import soot.SootMethod;
import soot.jimple.toolkits.callgraph.Edge;

public class SootCallGraph
extends CallGraph {
    Logger LOGGER = LoggerFactory.getLogger(SootCallGraph.class);

    public SootCallGraph() {
        soot.jimple.toolkits.callgraph.CallGraph callGraph = Scene.v().getCallGraph();
        for (Edge e : callGraph) {
            Statement callSite;
            if (!e.src().hasActiveBody() || !e.tgt().hasActiveBody() || e.srcStmt() == null || !(callSite = JimpleStatement.create(e.srcStmt(), JimpleMethod.of(e.src()))).containsInvokeExpr()) continue;
            this.LOGGER.trace("Call edge from {} to target method {}", (Object)callSite, (Object)e.tgt());
            this.addEdge(new CallGraph.Edge(callSite, JimpleMethod.of(e.tgt())));
        }
        for (SootMethod m : Scene.v().getEntryPoints()) {
            if (!m.hasActiveBody()) continue;
            this.addEntryPoint(JimpleMethod.of(m));
        }
    }
}

