/*
 * Decompiled with CFR 0.152.
 */
package boomerang.scene.sparse;

import boomerang.scene.Val;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Unit;
import soot.Value;

public class SparseAliasingCFG {
    private static Logger log = LoggerFactory.getLogger(SparseAliasingCFG.class);
    private MutableGraph<Unit> graph;
    private Val d;
    private Unit queryStmt;
    private Set<Value> fallbackAliases;
    private Map<Unit, Integer> unitToNumber;

    public SparseAliasingCFG(Val d, MutableGraph<Unit> graph, Unit queryStmt, Set<Value> fallbackAliases, Map<Unit, Integer> unitToNumber) {
        this.d = d;
        this.queryStmt = queryStmt;
        this.graph = graph;
        this.fallbackAliases = fallbackAliases;
        this.unitToNumber = unitToNumber;
    }

    public Set<Value> getFallBackAliases() {
        return this.fallbackAliases;
    }

    public synchronized boolean addEdge(Unit node, Unit succ) {
        return this.graph.putEdge((Object)node, (Object)succ);
    }

    public Set<Unit> getSuccessors(Unit node) {
        return this.graph.successors((Object)node);
    }

    public List<Unit> getNextUses(Unit node) {
        Set<Unit> successors = this.getSuccessors(node);
        return new ArrayList<Unit>(successors);
    }

    public MutableGraph<Unit> getGraph() {
        return this.graph;
    }
}

