/*
 * Decompiled with CFR 0.152.
 */
package boomerang.scene.sparse;

import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.Traverser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import soot.Unit;
import soot.jimple.IdentityStmt;
import soot.jimple.internal.JGotoStmt;
import soot.jimple.internal.JIdentityStmt;
import soot.jimple.internal.JIfStmt;
import soot.jimple.internal.JNopStmt;
import soot.jimple.internal.JReturnStmt;
import soot.jimple.internal.JReturnVoidStmt;
import soot.toolkits.graph.DirectedGraph;

public class SparseCFGBuilder {
    private static final Logger LOGGER = Logger.getLogger(SparseCFGBuilder.class.getName());
    protected Map<Unit, Integer> unitToNumber = new HashMap<Unit, Integer>();

    protected MutableGraph<Unit> numberStmtsAndConvertToMutableGraph(DirectedGraph<Unit> rawGraph) {
        MutableGraph mGraph = GraphBuilder.directed().build();
        List heads = rawGraph.getHeads();
        for (Unit head : heads) {
            this.convertToMutableGraph(rawGraph, head, (MutableGraph<Unit>)mGraph, 0);
        }
        return mGraph;
    }

    protected void convertToMutableGraph(DirectedGraph<Unit> graph, Unit curr, MutableGraph<Unit> mutableGraph, int depth) {
        Integer num = this.unitToNumber.get(curr);
        if (num == null || num < depth) {
            this.unitToNumber.put(curr, depth);
        }
        ++depth;
        List succsOf = graph.getSuccsOf((Object)curr);
        for (Unit succ : succsOf) {
            if (mutableGraph.hasEdgeConnecting((Object)curr, (Object)succ) || curr.equals(succ)) continue;
            mutableGraph.putEdge((Object)curr, (Object)succ);
            this.convertToMutableGraph(graph, succ, mutableGraph, depth);
        }
    }

    protected Unit getHead(DirectedGraph<Unit> graph) {
        List heads = graph.getHeads();
        ArrayList<Unit> res = new ArrayList<Unit>();
        for (Unit head : heads) {
            if (head instanceof IdentityStmt || graph.getSuccsOf((Object)head).isEmpty()) continue;
            res.add(head);
        }
        if (res.size() > 1) {
            LOGGER.warning("Multiple heads!");
        }
        return (Unit)res.get(0);
    }

    protected Iterator<Unit> getBFSIterator(MutableGraph<Unit> graph, Unit head) {
        Traverser traverser = Traverser.forGraph(graph);
        return traverser.breadthFirst((Object)head).iterator();
    }

    protected void logCFG(Logger logger, MutableGraph<Unit> graph) {
        logger.info(graph.nodes().stream().map(Objects::toString).collect(Collectors.joining(System.lineSeparator())));
    }

    protected boolean isControlStmt(Unit stmt) {
        if (stmt instanceof JIfStmt || stmt instanceof JNopStmt || stmt instanceof JGotoStmt || stmt instanceof JReturnStmt || stmt instanceof JReturnVoidStmt) {
            return true;
        }
        return stmt instanceof JIdentityStmt;
    }
}

