/*
 * Decompiled with CFR 0.152.
 */
package boomerang.scene.sparse.aliasaware;

import boomerang.scene.Pair;
import boomerang.scene.Val;
import boomerang.scene.sparse.SootAdapter;
import boomerang.scene.sparse.SparseAliasingCFG;
import boomerang.scene.sparse.SparseCFGBuilder;
import boomerang.scene.sparse.aliasaware.DefinedOutside;
import boomerang.scene.sparse.eval.SparseCFGQueryLog;
import com.google.common.graph.MutableGraph;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.InvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.internal.AbstractInstanceInvokeExpr;
import soot.jimple.internal.AbstractInvokeExpr;
import soot.jimple.internal.JArrayRef;
import soot.jimple.internal.JAssignStmt;
import soot.jimple.internal.JCastExpr;
import soot.jimple.internal.JDynamicInvokeExpr;
import soot.jimple.internal.JIdentityStmt;
import soot.jimple.internal.JInstanceFieldRef;
import soot.jimple.internal.JInterfaceInvokeExpr;
import soot.jimple.internal.JNewExpr;
import soot.jimple.internal.JSpecialInvokeExpr;
import soot.jimple.internal.JStaticInvokeExpr;
import soot.jimple.internal.JVirtualInvokeExpr;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.DirectedGraph;

public class AliasAwareSparseCFGBuilder
extends SparseCFGBuilder {
    private Deque<Value> backwardWorklist;
    private Deque<Value> forwardWorklist;
    private Map<Value, Unit> definitions;
    private Map<Value, LinkedHashSet<Unit>> valueToUnits;
    private Map<Value, Pair<Value, Unit>> valueKillebyValuedAt;
    private Type queryVarType;
    private SootMethod currentMethod;
    private Unit queryStmt;
    private String activePass;
    private int lastNodeIndex = -1;
    private static final Logger LOGGER = Logger.getLogger(AliasAwareSparseCFGBuilder.class.getName());
    private boolean enableExceptions;
    private boolean ignoreAfterQuery;

    public AliasAwareSparseCFGBuilder(boolean enableExceptions, boolean ignoreAfterQuery) {
        this.enableExceptions = enableExceptions;
        this.ignoreAfterQuery = ignoreAfterQuery;
        this.init();
    }

    private void init() {
        this.backwardWorklist = new ArrayDeque<Value>();
        this.forwardWorklist = new ArrayDeque<Value>();
        this.definitions = new HashMap<Value, Unit>();
        this.valueToUnits = new HashMap<Value, LinkedHashSet<Unit>>();
        this.valueKillebyValuedAt = new HashMap<Value, Pair<Value, Unit>>();
    }

    public SparseAliasingCFG buildSparseCFG(Val initialQueryVar, SootMethod m, Val queryVar, Unit queryStmt, SparseCFGQueryLog queryLog) {
        this.currentMethod = m;
        this.queryStmt = queryStmt;
        this.queryVarType = SootAdapter.getTypeOfVal(initialQueryVar);
        BriefUnitGraph unitGraph = new BriefUnitGraph(m.getActiveBody());
        Unit head = this.getHead((DirectedGraph<Unit>)unitGraph);
        MutableGraph<Unit> mCFG = this.numberStmtsAndConvertToMutableGraph((DirectedGraph<Unit>)unitGraph);
        int initialStmtCount = mCFG.nodes().size();
        this.findStmtsToKeep(mCFG, SootAdapter.asValue(queryVar), queryStmt);
        List tails = unitGraph.getTails();
        for (Unit tail : tails) {
            this.sparsify(mCFG, head, tail, queryStmt);
        }
        int finalStmtCount = mCFG.nodes().size();
        queryLog.setInitialStmtCount(initialStmtCount);
        queryLog.setFinalStmtCount(finalStmtCount);
        return new SparseAliasingCFG(queryVar, mCFG, queryStmt, this.valueToUnits.keySet(), this.unitToNumber);
    }

    private void sparsify(MutableGraph<Unit> mCFG, Unit head, Unit tail, Unit queryStmt) {
        Iterator<Unit> iter = this.getBFSIterator(mCFG, head);
        HashSet<Unit> stmsToRemove = new HashSet<Unit>();
        while (iter.hasNext()) {
            Unit unit = iter.next();
            if (this.isControlStmt(unit) || this.existInValueToUnits(unit) || unit.equals(queryStmt) || unit.equals(head) || unit.equals(tail) || this.isTargetCallSite(unit)) continue;
            stmsToRemove.add(unit);
        }
        for (Unit unit : stmsToRemove) {
            Set preds = mCFG.predecessors((Object)unit);
            Set succs = mCFG.successors((Object)unit);
            if (preds.size() != 1 || succs.size() != 1) continue;
            mCFG.removeNode((Object)unit);
            mCFG.putEdge(preds.iterator().next(), succs.iterator().next());
        }
    }

    private boolean isTargetCallSite(Unit unit) {
        Stmt stmt;
        if (unit instanceof Stmt && (stmt = (Stmt)unit).containsInvokeExpr()) {
            InvokeExpr invokeExpr = stmt.getInvokeExpr();
            List args = invokeExpr.getArgs();
            for (Value d : this.valueToUnits.keySet()) {
                for (Value arg : args) {
                    if (!d.equals(arg)) continue;
                    return true;
                }
                if (!this.isInvokeBase(d, invokeExpr)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean existInValueToUnits(Unit stmt) {
        for (Set set : this.valueToUnits.values()) {
            for (Unit unit : set) {
                if (!stmt.equals(unit)) continue;
                return true;
            }
        }
        return false;
    }

    private void findStmtsToKeep(MutableGraph<Unit> mCFG, Value queryVar, Unit queryStmt) {
        this.activePass = "findBackwardDef";
        Unit def = this.findBackwardDefForValue(mCFG, queryStmt, queryVar, new HashSet<Unit>(), false);
        this.putToValueToUnits(queryVar, def);
        this.activePass = "backwardPass";
        this.backwardPass(mCFG, def);
        this.activePass = "forwardPass";
        this.forwardPass(mCFG, queryStmt);
        this.activePass = "findStmtsForFieldBase";
        this.findStmtsForFieldBase(mCFG, queryStmt);
        this.activePass = "findStmtsAfterKill";
        this.findStmtsAfterKill(mCFG, queryStmt);
    }

    private void findStmtsForFieldBase(MutableGraph<Unit> mCFG, Unit queryStmt) {
        while (!this.backwardWorklist.isEmpty()) {
            this.backwardPass(mCFG, queryStmt);
            while (!this.forwardWorklist.isEmpty()) {
                this.forwardPass(mCFG, queryStmt);
            }
        }
    }

    private void findStmtsAfterKill(MutableGraph<Unit> mCFG, Unit queryStmt) {
        while (!this.backwardWorklist.isEmpty()) {
            Value val = this.popBackwardStack();
            Unit killedAt = null;
            Collection<Pair<Value, Unit>> killers = this.valueKillebyValuedAt.values();
            for (Pair<Value, Unit> killer : killers) {
                if (!killer.getX().equals(val)) continue;
                killedAt = killer.getY();
                break;
            }
            if (killedAt != null) {
                Unit def = this.findBackwardDefForValue(mCFG, killedAt, val, new HashSet<Unit>(), false);
                this.putToValueToUnits(val, def);
                continue;
            }
            throw new RuntimeException("if a val is killed there must be a killer");
        }
        this.forwardPass(mCFG, queryStmt);
    }

    private void backwardPass(MutableGraph<Unit> mCFG, Unit def) {
        while (!this.backwardWorklist.isEmpty()) {
            Value val = this.popBackwardStack();
            Unit existingDef = this.definitions.get(val);
            Unit newDef = existingDef != null ? this.findBackwardDefForValue(mCFG, existingDef, val, new HashSet<Unit>(), true) : this.findBackwardDefForValue(mCFG, def, val, new HashSet<Unit>(), false);
            def = newDef != null && !(newDef instanceof DefinedOutside) ? newDef : def;
            if (def == null) continue;
            this.putToValueToUnits(val, def);
        }
    }

    private void forwardPass(MutableGraph<Unit> mCFG, Unit queryStmt) {
        while (!this.forwardWorklist.isEmpty()) {
            Value val = this.popForwardStack();
            Unit defStmt = this.definitions.get(val);
            this.putToValueToUnits(val, defStmt);
            Set<Unit> unitsForVal = this.findForwardDefUseForValue(mCFG, defStmt, val, queryStmt, new HashSet<Unit>());
            for (Unit unit : unitsForVal) {
                this.putToValueToUnits(val, unit);
            }
        }
    }

    private boolean isDebugTarget() {
        return false;
    }

    private void logStackOp(Value val, String op) {
        if (this.isDebugTarget()) {
            System.out.println(this.activePass + ": " + op + ": " + val);
        }
    }

    private void pushToForwardStack(Value val) {
        this.logStackOp(val, "Forw push");
        this.forwardWorklist.push(val);
    }

    private void pushToBackwardStack(Value val) {
        this.logStackOp(val, "Back push");
        this.backwardWorklist.push(val);
    }

    private Value popBackwardStack() {
        Value val = this.backwardWorklist.pop();
        this.logStackOp(val, "Back pop");
        return val;
    }

    private Value popForwardStack() {
        Value val = this.forwardWorklist.pop();
        this.logStackOp(val, "Forw pop");
        return val;
    }

    private void putToValueToUnits(Value val, Unit stmt) {
        Set<Unit> units;
        if (this.valueToUnits.containsKey(val)) {
            units = this.valueToUnits.get(val);
            units.add(stmt);
        } else {
            units = new LinkedHashSet<Unit>();
            ((HashSet)units).add(stmt);
            this.valueToUnits.put(val, (LinkedHashSet<Unit>)units);
        }
        if (this.isDebugTarget()) {
            System.out.println("putToValueToUnits:");
            for (Value k : this.valueToUnits.keySet()) {
                System.out.print(k + ": ");
                System.out.println(this.valueToUnits.get(k).stream().map(Objects::toString).collect(Collectors.joining("---")));
            }
        }
    }

    private Unit findBackwardDefForValue(MutableGraph<Unit> mCFG, Unit tail, Value queryVar, Set<Unit> visited, boolean existingDef) {
        if (tail == null) {
            return null;
        }
        visited.add(tail);
        if (!existingDef && this.isDefOfValue(tail, queryVar)) {
            return tail;
        }
        Set preds = mCFG.predecessors((Object)tail);
        for (Unit pred : preds) {
            Unit u;
            if (visited.contains(pred) || (u = this.findBackwardDefForValue(mCFG, pred, queryVar, visited, false)) == null) continue;
            return u;
        }
        if (queryVar instanceof JInstanceFieldRef) {
            return new DefinedOutside(queryVar);
        }
        return null;
    }

    private boolean isDefOfValue(Unit unit, Value queryVar) {
        JIdentityStmt stmt;
        Value leftOp;
        if (unit instanceof JAssignStmt) {
            JAssignStmt stmt2 = (JAssignStmt)unit;
            Value leftOp2 = stmt2.getLeftOp();
            Value rightOp = stmt2.getRightOp();
            if (rightOp instanceof JCastExpr) {
                JCastExpr cast = (JCastExpr)rightOp;
                rightOp = cast.getOp();
            }
            if (queryVar.equals(leftOp2) || this.equalsFieldRef(leftOp2, queryVar) || this.equalsQueryBase(leftOp2, queryVar) || this.equalsArrayItem(leftOp2, queryVar) || this.equalsFieldType(leftOp2, queryVar)) {
                if (this.isAllocOrMethodAssignment(stmt2, queryVar)) {
                    this.pushToForwardStack(queryVar);
                    Set<Value> params = this.getInvokeBaseAndParams(rightOp, queryVar);
                    params.forEach(this.backwardWorklist::add);
                } else {
                    Value base;
                    if (this.equalsFieldRef(rightOp, queryVar) && rightOp instanceof JInstanceFieldRef && (base = ((JInstanceFieldRef)rightOp).getBase()).equals(leftOp2)) {
                        this.pushToBackwardStack(leftOp2);
                        this.definitions.put(leftOp2, unit);
                        this.pushToForwardStack(rightOp);
                        this.definitions.put(rightOp, unit);
                        return false;
                    }
                    if (rightOp instanceof JInstanceFieldRef) {
                        base = ((JInstanceFieldRef)rightOp).getBase();
                        this.pushToBackwardStack(base);
                    }
                    this.pushToBackwardStack(rightOp);
                }
                this.definitions.put(queryVar, unit);
                return true;
            }
        } else if (unit instanceof JIdentityStmt && (queryVar.equals(leftOp = (stmt = (JIdentityStmt)unit).getLeftOp()) || this.equalsFieldRef(leftOp, queryVar) || this.equalsArrayItem(leftOp, queryVar))) {
            this.pushToForwardStack(queryVar);
            this.definitions.put(queryVar, unit);
            return true;
        }
        return false;
    }

    private boolean equalsFieldRef(Value op, Value queryVar) {
        if (op instanceof JInstanceFieldRef && queryVar instanceof JInstanceFieldRef) {
            return ((JInstanceFieldRef)queryVar).getBase().equals(((JInstanceFieldRef)op).getBase()) && ((JInstanceFieldRef)queryVar).getField().equals(((JInstanceFieldRef)op).getField());
        }
        if (op instanceof StaticFieldRef && queryVar instanceof StaticFieldRef) {
            return ((StaticFieldRef)op).getFieldRef().equals(((StaticFieldRef)queryVar).getFieldRef());
        }
        return false;
    }

    private boolean equalsArrayItem(Value op, Value queryVar) {
        if (op instanceof JArrayRef && queryVar instanceof JArrayRef) {
            return ((JArrayRef)queryVar).getBase().equals(((JArrayRef)op).getBase()) && ((JArrayRef)queryVar).getIndex().equals(((JArrayRef)op).getIndex());
        }
        return false;
    }

    private int getLastNodeIndex() {
        if (this.lastNodeIndex == -1) {
            this.lastNodeIndex = (Integer)Collections.max(this.unitToNumber.entrySet(), Comparator.comparingInt(Map.Entry::getValue)).getValue();
        }
        return this.lastNodeIndex;
    }

    private boolean shouldStopSearch(Unit currentStmt, Unit queryStmt) {
        if (this.ignoreAfterQuery) {
            return (Integer)this.unitToNumber.get(currentStmt) >= (Integer)this.unitToNumber.get(queryStmt);
        }
        return (Integer)this.unitToNumber.get(currentStmt) >= this.getLastNodeIndex();
    }

    private Set<Unit> findForwardDefUseForValue(MutableGraph<Unit> mCFG, Unit head, Value queryVar, Unit queryStmt, Set<Unit> visited) {
        visited.add(head);
        HashSet<Unit> stmtsToKeep = new HashSet<Unit>();
        Set succs = mCFG.successors((Object)head);
        for (Unit succ : succs) {
            if (this.shouldStopSearch(succ, queryStmt)) {
                return stmtsToKeep;
            }
            if (!this.valueKillebyValuedAt.containsKey(queryVar) && this.keepContainingStmtsForward(succ, queryVar)) {
                stmtsToKeep.add(succ);
            }
            if (visited.contains(succ)) continue;
            Set<Unit> ret = this.findForwardDefUseForValue(mCFG, succ, queryVar, queryStmt, visited);
            stmtsToKeep.addAll(ret);
        }
        return stmtsToKeep;
    }

    private boolean keepContainingStmtsForward(Unit unit, Value queryVar) {
        if (unit instanceof JAssignStmt) {
            JAssignStmt stmt = (JAssignStmt)unit;
            Value leftOp = stmt.getLeftOp();
            Value rightOp = stmt.getRightOp();
            if (rightOp instanceof JCastExpr) {
                JCastExpr cast = (JCastExpr)rightOp;
                rightOp = cast.getOp();
            }
            if (queryVar.equals(rightOp) || this.equalsFieldRef(rightOp, queryVar) || this.equalsQueryBase(rightOp, queryVar) || this.equalsFieldType(rightOp, queryVar) || this.equalsArrayItem(rightOp, queryVar) || this.equalsInitialFieldType(rightOp, queryVar)) {
                if (!leftOp.equals(queryVar)) {
                    this.pushToForwardStack(leftOp);
                    this.definitions.put(leftOp, unit);
                }
                if (leftOp instanceof JInstanceFieldRef) {
                    Value base = ((JInstanceFieldRef)leftOp).getBase();
                    this.pushToBackwardStack(base);
                }
                return true;
            }
            if (queryVar.equals(leftOp) || this.equalsFieldRef(leftOp, queryVar) || this.equalsQueryBase(leftOp, queryVar) || this.equalsArrayItem(leftOp, queryVar)) {
                this.valueKillebyValuedAt.put(queryVar, new Pair<Value, Unit>(rightOp, unit));
                this.pushToBackwardStack(rightOp);
                return true;
            }
            if (this.equalsInitialFieldType(leftOp, queryVar)) {
                this.pushToBackwardStack(rightOp);
                return true;
            }
        }
        return this.keepInvokeForValue(unit, queryVar);
    }

    private boolean equalsQueryBase(Value rightOp, Value queryVar) {
        Value queryBase;
        return queryVar instanceof JInstanceFieldRef && (queryBase = ((JInstanceFieldRef)queryVar).getBase()).equals(rightOp);
    }

    private boolean equalsInitialFieldType(Value op, Value queryVar) {
        if (op instanceof JInstanceFieldRef) {
            Value base = ((JInstanceFieldRef)op).getBase();
            Type fieldType = ((JInstanceFieldRef)op).getField().getType();
            if (base.equals(queryVar) && fieldType.equals(this.queryVarType)) {
                return true;
            }
        }
        return false;
    }

    private boolean equalsFieldType(Value op, Value queryVar) {
        if (op instanceof JInstanceFieldRef) {
            Value base = ((JInstanceFieldRef)op).getBase();
            Type fieldType = ((JInstanceFieldRef)op).getField().getType();
            if (base.equals(queryVar) && fieldType.equals(queryVar.getType())) {
                return true;
            }
        }
        return false;
    }

    private Set<Value> getInvokeBaseAndParams(Value invoke, Value d) {
        HashSet<Value> otherArgs = new HashSet<Value>();
        if (invoke instanceof AbstractInvokeExpr) {
            List args = ((AbstractInvokeExpr)invoke).getArgs();
            for (Value arg : args) {
                if ((arg.equals(d) || !arg.getType().equals(d.getType())) && !arg.getType().equals(this.queryVarType)) continue;
                otherArgs.add(arg);
            }
        }
        if (invoke instanceof AbstractInstanceInvokeExpr) {
            Value base = ((AbstractInstanceInvokeExpr)invoke).getBase();
            otherArgs.add(base);
        }
        return otherArgs;
    }

    private boolean keepInvokeForValue(Unit unit, Value d) {
        Stmt stmt;
        if (unit instanceof Stmt && (stmt = (Stmt)unit).containsInvokeExpr()) {
            InvokeExpr invokeExpr = stmt.getInvokeExpr();
            List args = invokeExpr.getArgs();
            for (Value arg : args) {
                if (!d.equals(arg)) continue;
                for (Value otherArg : args) {
                    if (otherArg.equals(d) || !otherArg.getType().equals(d.getType()) || this.definitions.containsKey(otherArg)) continue;
                    this.pushToBackwardStack(otherArg);
                }
                return true;
            }
            if (this.isInvokeBase(d, invokeExpr)) {
                Set<Value> params = this.getInvokeBaseAndParams((Value)invokeExpr, d);
                params.forEach(this.backwardWorklist::push);
                return true;
            }
        }
        return false;
    }

    private boolean isInvokeBase(Value d, InvokeExpr invokeExpr) {
        Value base;
        return invokeExpr instanceof JVirtualInvokeExpr ? d.equals(base = ((JVirtualInvokeExpr)invokeExpr).getBase()) : invokeExpr instanceof JSpecialInvokeExpr && d.equals(base = ((JSpecialInvokeExpr)invokeExpr).getBase());
    }

    private boolean isAllocOrMethodAssignment(JAssignStmt stmt, Value d) {
        JNewExpr newExpr;
        Type type;
        Value rightOp = stmt.getRightOp();
        return rightOp instanceof JNewExpr ? (type = (newExpr = (JNewExpr)rightOp).getType()).equals(d.getType()) : rightOp instanceof JSpecialInvokeExpr || rightOp instanceof JStaticInvokeExpr || rightOp instanceof JVirtualInvokeExpr || rightOp instanceof JInterfaceInvokeExpr || rightOp instanceof JDynamicInvokeExpr;
    }

    private void buildCompleteCFG(Unit curr, DirectedGraph<Unit> graph, SparseAliasingCFG cfg) {
        List succs = graph.getSuccsOf((Object)curr);
        if (succs == null || succs.isEmpty()) {
            return;
        }
        for (Unit succ : succs) {
            if (!cfg.addEdge(curr, succ)) continue;
            this.buildCompleteCFG(succ, graph, cfg);
        }
    }
}

