/*
 * Decompiled with CFR 0.152.
 */
package boomerang.scene.sparse.eval;

import boomerang.scene.sparse.SparseCFGCache;
import boomerang.scene.sparse.eval.PropagationCounter;
import boomerang.scene.sparse.eval.SparseCFGQueryLog;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class EvalPrinter {
    private String evalName;

    public EvalPrinter(String evalName) {
        this.evalName = evalName;
    }

    public void printCachePerformance(SparseCFGCache cache) {
        List<SparseCFGQueryLog> queryLogs = cache.getQueryLogs();
        try (FileWriter writer = new FileWriter(this.evalName + "-sparseCFGCache.csv");){
            long count = 0L;
            for (SparseCFGQueryLog queryLog : queryLogs) {
                StringBuilder str = new StringBuilder(Long.toString(++count));
                str.append(",");
                str.append(queryLog.isRetrievedFromCache());
                str.append(",");
                str.append((Object)queryLog.getDirection());
                str.append(",");
                str.append(queryLog.getDuration().toMillis());
                str.append(System.lineSeparator());
                writer.write(str.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void printPropagationCount() {
        ArrayList<PropagationCounter> counters = new ArrayList<PropagationCounter>();
        counters.add(PropagationCounter.getInstance(SparseCFGCache.SparsificationStrategy.NONE));
        counters.add(PropagationCounter.getInstance(SparseCFGCache.SparsificationStrategy.TYPE_BASED));
        counters.add(PropagationCounter.getInstance(SparseCFGCache.SparsificationStrategy.ALIAS_AWARE));
        try (FileWriter writer = new FileWriter(this.evalName + "-propCount.csv");){
            StringBuilder str = new StringBuilder();
            for (PropagationCounter counter : counters) {
                str.append(counter.getStrategy().toString());
                str.append(",");
                str.append(counter.getForwardPropagation());
                str.append(",");
                str.append(counter.getBackwardPropagation());
                str.append(System.lineSeparator());
            }
            writer.write(str.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

