/*
 * Decompiled with CFR 0.152.
 */
package boomerang.scene.sparse.eval;

import boomerang.scene.sparse.SparseCFGCache;

public class PropagationCounter {
    private SparseCFGCache.SparsificationStrategy strategy;
    private long forwardPropagation = 0L;
    private long backwardPropagation = 0L;
    private static PropagationCounter NONE_INSTANCE;
    private static PropagationCounter TYPE_BASED_INSTANCE;
    private static PropagationCounter ALIAS_AWARE_INSTANCE;

    public static PropagationCounter getInstance(SparseCFGCache.SparsificationStrategy strategy) {
        switch (strategy) {
            case NONE: {
                if (NONE_INSTANCE == null) {
                    NONE_INSTANCE = new PropagationCounter(strategy);
                }
                return NONE_INSTANCE;
            }
            case TYPE_BASED: {
                if (TYPE_BASED_INSTANCE == null) {
                    TYPE_BASED_INSTANCE = new PropagationCounter(strategy);
                }
                return TYPE_BASED_INSTANCE;
            }
            case ALIAS_AWARE: {
                if (ALIAS_AWARE_INSTANCE == null) {
                    ALIAS_AWARE_INSTANCE = new PropagationCounter(strategy);
                }
                return ALIAS_AWARE_INSTANCE;
            }
        }
        throw new RuntimeException("No such strategy");
    }

    private PropagationCounter(SparseCFGCache.SparsificationStrategy strategy) {
        this.strategy = strategy;
    }

    public void countForward() {
        ++this.forwardPropagation;
    }

    public void countBackward() {
        ++this.backwardPropagation;
    }

    public long getForwardPropagation() {
        return this.forwardPropagation;
    }

    public long getBackwardPropagation() {
        return this.backwardPropagation;
    }

    public SparseCFGCache.SparsificationStrategy getStrategy() {
        return this.strategy;
    }
}

