/*
 * Decompiled with CFR 0.152.
 */
package boomerang.scene.sparse.eval;

import com.google.common.base.Stopwatch;
import java.time.Duration;

public class SparseCFGQueryLog {
    private boolean retrievedFromCache;
    private QueryDirection direction;
    private final Stopwatch watch;
    private final Stopwatch cfgNumberWatch;
    private final Stopwatch findStmtsWatch;
    private final Stopwatch sparsifysWatch;
    private int containerTypeCount = 0;
    private int initialStmtCount = 0;
    private int finalStmtCount = 0;

    public SparseCFGQueryLog(boolean retrievedFromCache, QueryDirection direction) {
        this.retrievedFromCache = retrievedFromCache;
        this.direction = direction;
        if (!retrievedFromCache) {
            this.watch = Stopwatch.createUnstarted();
            this.cfgNumberWatch = Stopwatch.createUnstarted();
            this.findStmtsWatch = Stopwatch.createUnstarted();
            this.sparsifysWatch = Stopwatch.createUnstarted();
        } else {
            this.watch = null;
            this.cfgNumberWatch = null;
            this.findStmtsWatch = null;
            this.sparsifysWatch = null;
        }
    }

    public void logStart() {
        if (!this.retrievedFromCache) {
            this.watch.start();
        }
    }

    public void logEnd() {
        if (!this.retrievedFromCache) {
            this.watch.stop();
        }
    }

    public Duration getDuration() {
        if (!this.retrievedFromCache) {
            return this.watch.elapsed();
        }
        return Duration.ZERO;
    }

    public boolean isRetrievedFromCache() {
        return this.retrievedFromCache;
    }

    public QueryDirection getDirection() {
        return this.direction;
    }

    public int getInitialStmtCount() {
        return this.initialStmtCount;
    }

    public void setInitialStmtCount(int initialStmtCount) {
        this.initialStmtCount = initialStmtCount;
    }

    public int getFinalStmtCount() {
        return this.finalStmtCount;
    }

    public void setFinalStmtCount(int finalStmtCount) {
        this.finalStmtCount = finalStmtCount;
    }

    public static enum QueryDirection {
        FWD,
        BWD;

    }
}

