/*
 * Decompiled with CFR 0.152.
 */
package boomerang.scene.sparse.typebased;

import boomerang.scene.Val;
import boomerang.scene.sparse.SootAdapter;
import boomerang.scene.sparse.SparseAliasingCFG;
import boomerang.scene.sparse.SparseCFGBuilder;
import boomerang.scene.sparse.aliasaware.AliasAwareSparseCFGBuilder;
import boomerang.scene.sparse.eval.SparseCFGQueryLog;
import com.google.common.graph.MutableGraph;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import soot.Scene;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.internal.AbstractInstanceInvokeExpr;
import soot.jimple.internal.JAssignStmt;
import soot.jimple.internal.JCastExpr;
import soot.jimple.internal.JInstanceFieldRef;
import soot.jimple.internal.JSpecialInvokeExpr;
import soot.jimple.internal.JVirtualInvokeExpr;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.DirectedGraph;

public class TypeBasedSparseCFGBuilder
extends SparseCFGBuilder {
    private static final Logger LOGGER = Logger.getLogger(AliasAwareSparseCFGBuilder.class.getName());
    private boolean enableExceptions;
    private Deque<Type> typeWorklist;
    private Set<Type> containerTypes;

    public TypeBasedSparseCFGBuilder(boolean enableExceptions) {
        this.enableExceptions = enableExceptions;
    }

    public SparseAliasingCFG buildSparseCFG(Val queryVar, SootMethod m, Unit queryStmt, SparseCFGQueryLog queryLog) {
        this.typeWorklist = new ArrayDeque<Type>();
        this.containerTypes = new HashSet<Type>();
        BriefUnitGraph unitGraph = new BriefUnitGraph(m.getActiveBody());
        Unit head = this.getHead((DirectedGraph<Unit>)unitGraph);
        MutableGraph<Unit> mCFG = this.numberStmtsAndConvertToMutableGraph((DirectedGraph<Unit>)unitGraph);
        int initialStmtCount = mCFG.nodes().size();
        Type typeOfQueryVar = SootAdapter.getTypeOfVal(queryVar);
        Set<Unit> stmtsToKeep = this.findStmtsToKeep(mCFG, head, typeOfQueryVar);
        this.containerTypes.add(typeOfQueryVar);
        while (!this.typeWorklist.isEmpty()) {
            Type containerType = this.typeWorklist.pop();
            stmtsToKeep.addAll(this.findStmtsToKeep(mCFG, head, containerType));
        }
        stmtsToKeep.add(queryStmt);
        List tails = unitGraph.getTails();
        for (Unit tail : tails) {
            this.sparsify(mCFG, stmtsToKeep, head, tail);
        }
        int finalStmtCount = mCFG.nodes().size();
        queryLog.setInitialStmtCount(initialStmtCount);
        queryLog.setFinalStmtCount(finalStmtCount);
        return new SparseAliasingCFG(queryVar, mCFG, queryStmt, null, this.unitToNumber);
    }

    private void sparsify(MutableGraph<Unit> mCFG, Set<Unit> stmtsToKeep, Unit head, Unit tail) {
        Iterator<Unit> iter = this.getBFSIterator(mCFG, head);
        HashSet<Unit> stmsToRemove = new HashSet<Unit>();
        while (iter.hasNext()) {
            Unit unit = iter.next();
            if (this.isControlStmt(unit) || stmtsToKeep.contains(unit) || unit.equals(head) || unit.equals(tail)) continue;
            stmsToRemove.add(unit);
        }
        for (Unit unit : stmsToRemove) {
            Set preds = mCFG.predecessors((Object)unit);
            Set succs = mCFG.successors((Object)unit);
            if (preds.size() != 1 || succs.size() != 1) continue;
            mCFG.removeNode((Object)unit);
            mCFG.putEdge(preds.iterator().next(), succs.iterator().next());
        }
    }

    private Set<Unit> findStmtsToKeep(MutableGraph<Unit> mCFG, Unit head, Type queryVarType) {
        HashSet<Unit> stmtsToKeep = new HashSet<Unit>();
        Iterator<Unit> iter = this.getBFSIterator(mCFG, head);
        while (iter.hasNext()) {
            Unit unit = iter.next();
            if (!this.keepStmt(unit, queryVarType)) continue;
            stmtsToKeep.add(unit);
        }
        return stmtsToKeep;
    }

    private boolean isAssignableType(Type targetType, Type sourceType) {
        return Scene.v().getOrMakeFastHierarchy().canStoreType(targetType, sourceType) || Scene.v().getOrMakeFastHierarchy().canStoreType(sourceType, targetType);
    }

    private boolean keepStmt(Unit unit, Type queryVarType) {
        Stmt stmt;
        boolean keep = false;
        if (unit instanceof Stmt && (stmt = (Stmt)unit).containsInvokeExpr()) {
            InvokeExpr invokeExpr = stmt.getInvokeExpr();
            List args = invokeExpr.getArgs();
            for (Value arg : args) {
                if (this.isFieldTypeRelevant(queryVarType, arg)) {
                    this.handleInvokeBase(invokeExpr, queryVarType);
                    keep = true;
                }
                if (!this.isAssignableType(arg.getType(), queryVarType)) continue;
                this.handleInvokeBase(invokeExpr, queryVarType);
                keep = true;
            }
            if (this.isInvokeBase(queryVarType, invokeExpr)) {
                keep = true;
            }
        }
        if (unit instanceof JAssignStmt) {
            stmt = (JAssignStmt)unit;
            Value leftOp = stmt.getLeftOp();
            Value rightOp = stmt.getRightOp();
            if (rightOp instanceof JCastExpr) {
                JCastExpr cast = (JCastExpr)rightOp;
                rightOp = cast.getOp();
            }
            if (rightOp.toString().startsWith("this$")) {
                keep = true;
            }
            if (this.isFieldTypeRelevant(queryVarType, leftOp) || this.isFieldTypeRelevant(queryVarType, rightOp)) {
                keep = true;
            }
            if (this.isAssignableType(leftOp.getType(), queryVarType) || this.isAssignableType(rightOp.getType(), queryVarType)) {
                InvokeExpr invokeExpr;
                if (stmt.containsInvokeExpr() && (invokeExpr = stmt.getInvokeExpr()) instanceof AbstractInstanceInvokeExpr) {
                    this.handleInvokeBase(invokeExpr, queryVarType);
                }
                keep = true;
            }
        }
        return keep;
    }

    private void handleInvokeBase(InvokeExpr invokeExpr, Type queryVarType) {
        if (invokeExpr instanceof JVirtualInvokeExpr) {
            Value base = ((JVirtualInvokeExpr)invokeExpr).getBase();
            this.handleContainerType(base, queryVarType);
        } else if (invokeExpr instanceof JSpecialInvokeExpr) {
            Value base = ((JSpecialInvokeExpr)invokeExpr).getBase();
            this.handleContainerType(base, queryVarType);
        }
    }

    private void handleContainerType(Value base, Type queryVarType) {
        if (!base.getType().equals(queryVarType) && !this.containerTypes.contains(base.getType())) {
            this.typeWorklist.push(base.getType());
            this.containerTypes.add(base.getType());
        }
    }

    private boolean isFieldTypeRelevant(Type queryVarType, Value value) {
        JInstanceFieldRef fieldRef;
        SootField field;
        if (value instanceof JInstanceFieldRef && this.isAssignableType((field = (fieldRef = (JInstanceFieldRef)value).getField()).getType(), queryVarType)) {
            Value base = fieldRef.getBase();
            this.handleContainerType(base, queryVarType);
            return true;
        }
        return false;
    }

    private boolean isInvokeBase(Type queryVarType, InvokeExpr invokeExpr) {
        Value base;
        return invokeExpr instanceof JVirtualInvokeExpr ? this.isAssignableType((base = ((JVirtualInvokeExpr)invokeExpr).getBase()).getType(), queryVarType) : invokeExpr instanceof JSpecialInvokeExpr && this.isAssignableType((base = ((JSpecialInvokeExpr)invokeExpr).getBase()).getType(), queryVarType);
    }
}

