/*
 * Decompiled with CFR 0.152.
 */
package boomerang.scene.sparse.typebased;

import boomerang.scene.Method;
import boomerang.scene.Statement;
import boomerang.scene.Val;
import boomerang.scene.sparse.SootAdapter;
import boomerang.scene.sparse.SparseAliasingCFG;
import boomerang.scene.sparse.SparseCFGCache;
import boomerang.scene.sparse.eval.SparseCFGQueryLog;
import boomerang.scene.sparse.typebased.TypeBasedSparseCFGBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.Stmt;

public class TypeBasedSparseCFGCache
implements SparseCFGCache {
    List<SparseCFGQueryLog> logList = new ArrayList<SparseCFGQueryLog>();
    Map<String, SparseAliasingCFG> cache;
    TypeBasedSparseCFGBuilder sparseCFGBuilder;
    private static TypeBasedSparseCFGCache INSTANCE;

    private TypeBasedSparseCFGCache() {
    }

    public static TypeBasedSparseCFGCache getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TypeBasedSparseCFGCache(new TypeBasedSparseCFGBuilder(true));
        }
        return INSTANCE;
    }

    private TypeBasedSparseCFGCache(TypeBasedSparseCFGBuilder sparseCFGBuilder) {
        this.cache = new HashMap<String, SparseAliasingCFG>();
        this.sparseCFGBuilder = sparseCFGBuilder;
    }

    @Override
    public SparseAliasingCFG getSparseCFGForForwardPropagation(SootMethod m, Stmt stmt, Val val) {
        for (String s : this.cache.keySet()) {
            SparseAliasingCFG sparseAliasingCFG;
            if (!s.startsWith(m.getSignature()) || !(sparseAliasingCFG = this.cache.get(s)).getGraph().nodes().contains(stmt)) continue;
            SparseCFGQueryLog queryLog = new SparseCFGQueryLog(true, SparseCFGQueryLog.QueryDirection.FWD);
            this.logList.add(queryLog);
            return sparseAliasingCFG;
        }
        SparseCFGQueryLog queryLog = new SparseCFGQueryLog(false, SparseCFGQueryLog.QueryDirection.FWD);
        this.logList.add(queryLog);
        return null;
    }

    @Override
    public synchronized SparseAliasingCFG getSparseCFGForBackwardPropagation(Val initialQueryVal, Statement initialQueryStmt, Method currentMethod, Val currentVal, Statement currentStmt) {
        SootMethod sootSurrentMethod = SootAdapter.asSootMethod(currentMethod);
        Stmt sootInitialQueryStmt = SootAdapter.asStmt(initialQueryStmt);
        Stmt sootCurrentStmt = SootAdapter.asStmt(currentStmt);
        String key = sootSurrentMethod.getSignature() + "-" + initialQueryVal + "-" + sootInitialQueryStmt;
        if (this.cache.containsKey(key)) {
            if (this.cache.get(key).getGraph().nodes().contains(sootCurrentStmt)) {
                SparseCFGQueryLog queryLog = new SparseCFGQueryLog(true, SparseCFGQueryLog.QueryDirection.BWD);
                this.logList.add(queryLog);
                return this.cache.get(key);
            }
            SparseCFGQueryLog queryLog = new SparseCFGQueryLog(false, SparseCFGQueryLog.QueryDirection.BWD);
            queryLog.logStart();
            SparseAliasingCFG cfg = this.sparseCFGBuilder.buildSparseCFG(initialQueryVal, sootSurrentMethod, (Unit)sootCurrentStmt, queryLog);
            queryLog.logEnd();
            this.cache.put(key + currentStmt, cfg);
            this.logList.add(queryLog);
            return cfg;
        }
        if (this.cache.containsKey(key + currentStmt)) {
            SparseCFGQueryLog queryLog = new SparseCFGQueryLog(true, SparseCFGQueryLog.QueryDirection.BWD);
            this.logList.add(queryLog);
            return this.cache.get(key + currentStmt);
        }
        SparseCFGQueryLog queryLog = new SparseCFGQueryLog(false, SparseCFGQueryLog.QueryDirection.BWD);
        queryLog.logStart();
        SparseAliasingCFG cfg = this.sparseCFGBuilder.buildSparseCFG(initialQueryVal, sootSurrentMethod, (Unit)sootCurrentStmt, queryLog);
        queryLog.logEnd();
        this.cache.put(key, cfg);
        this.logList.add(queryLog);
        return cfg;
    }

    @Override
    public List<SparseCFGQueryLog> getQueryLogs() {
        return this.logList;
    }
}

