/*
 * Decompiled with CFR 0.152.
 */
package ideal;

import boomerang.ForwardQuery;
import boomerang.Query;
import boomerang.WeightedForwardQuery;
import boomerang.results.ForwardBoomerangResults;
import boomerang.scene.AnalysisScope;
import boomerang.scene.ControlFlowGraph;
import com.google.common.base.Stopwatch;
import ideal.IDEALAnalysisDefinition;
import ideal.IDEALSeedSolver;
import ideal.IDEALSeedTimeout;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import typestate.TransitionFunction;
import wpds.impl.Weight;

public class IDEALAnalysis<W extends Weight> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IDEALAnalysis.class);
    public static boolean PRINT_OPTIONS = false;
    protected final IDEALAnalysisDefinition<W> analysisDefinition;
    private final AnalysisScope seedFactory;
    private int seedCount;
    private Map<WeightedForwardQuery<W>, Stopwatch> analysisTime = new HashMap<WeightedForwardQuery<W>, Stopwatch>();
    private Set<WeightedForwardQuery<W>> timedoutSeeds = new HashSet<WeightedForwardQuery<W>>();

    public IDEALAnalysis(final IDEALAnalysisDefinition<W> analysisDefinition) {
        this.analysisDefinition = analysisDefinition;
        this.seedFactory = new AnalysisScope(analysisDefinition.callGraph()){

            protected Collection<WeightedForwardQuery<W>> generate(ControlFlowGraph.Edge stmt) {
                return analysisDefinition.generate(stmt);
            }
        };
    }

    public void run() {
        this.printOptions();
        Collection initialSeeds = this.seedFactory.computeSeeds();
        if (initialSeeds.isEmpty()) {
            LOGGER.info("No seeds found!");
        } else {
            LOGGER.info("Analysing {} seeds!", (Object)initialSeeds.size());
        }
        for (Query s : initialSeeds) {
            if (!(s instanceof WeightedForwardQuery)) continue;
            WeightedForwardQuery seed = (WeightedForwardQuery)s;
            ++this.seedCount;
            LOGGER.info("Analyzing {}", (Object)seed);
            Stopwatch watch = Stopwatch.createStarted();
            this.analysisTime.put(seed, watch);
            this.run((ForwardQuery)seed);
            watch.stop();
            LOGGER.debug("Analyzed (finished,timedout): \t ({},{}) of {} seeds", new Object[]{this.seedCount - this.timedoutSeeds.size(), this.timedoutSeeds.size(), initialSeeds.size()});
        }
    }

    public ForwardBoomerangResults<W> run(ForwardQuery seed) {
        Object res;
        IDEALSeedSolver<W> idealAnalysis = new IDEALSeedSolver<W>(this.analysisDefinition, seed);
        try {
            res = idealAnalysis.run();
        }
        catch (IDEALSeedTimeout e) {
            res = e.getLastResults();
            this.timedoutSeeds.add((WeightedForwardQuery)seed);
        }
        this.analysisDefinition.getResultHandler().report((WeightedForwardQuery)seed, res);
        return res;
    }

    private void printOptions() {
        if (PRINT_OPTIONS) {
            System.out.println(this.analysisDefinition);
        }
    }

    public Collection<Query> computeSeeds() {
        return this.seedFactory.computeSeeds();
    }

    public Stopwatch getAnalysisTime(WeightedForwardQuery<TransitionFunction> key) {
        return this.analysisTime.get(key);
    }

    public boolean isTimedout(WeightedForwardQuery<TransitionFunction> key) {
        return this.timedoutSeeds.contains(key);
    }
}

