/*
 * Decompiled with CFR 0.152.
 */
package ideal;

import boomerang.scene.ControlFlowGraph;
import boomerang.scene.Val;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import ideal.IDEALSeedSolver;
import ideal.NonOneFlowListener;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sync.pds.solver.WeightFunctions;
import sync.pds.solver.nodes.Node;
import sync.pds.solver.nodes.PushNode;
import wpds.impl.Weight;

public class IDEALWeightFunctions<W extends Weight>
implements WeightFunctions<ControlFlowGraph.Edge, Val, ControlFlowGraph.Edge, W> {
    private static final Logger logger = LoggerFactory.getLogger(IDEALWeightFunctions.class);
    private WeightFunctions<ControlFlowGraph.Edge, Val, ControlFlowGraph.Edge, W> delegate;
    private Set<NonOneFlowListener> listeners = Sets.newHashSet();
    private Set<ControlFlowGraph.Edge> potentialStrongUpdates = Sets.newHashSet();
    private Set<ControlFlowGraph.Edge> weakUpdates = Sets.newHashSet();
    private Set<Node<ControlFlowGraph.Edge, Val>> nonOneFlowNodes = Sets.newHashSet();
    private IDEALSeedSolver.Phases phase;
    private boolean strongUpdates;
    private Multimap<Node<ControlFlowGraph.Edge, Val>, Node<ControlFlowGraph.Edge, Val>> indirectAlias = HashMultimap.create();
    private Set<Node<ControlFlowGraph.Edge, Val>> nodesWithStrongUpdate = Sets.newHashSet();

    public IDEALWeightFunctions(WeightFunctions<ControlFlowGraph.Edge, Val, ControlFlowGraph.Edge, W> delegate, boolean strongUpdates) {
        this.delegate = delegate;
        this.strongUpdates = strongUpdates;
    }

    public W push(Node<ControlFlowGraph.Edge, Val> curr, Node<ControlFlowGraph.Edge, Val> succ, ControlFlowGraph.Edge calleeSp) {
        Weight weight = this.delegate.push(curr, succ, (Object)calleeSp);
        if (this.isObjectFlowPhase() && !weight.equals(this.getOne()) && succ instanceof PushNode) {
            PushNode pushNode = (PushNode)succ;
            this.addOtherThanOneWeight((Node<ControlFlowGraph.Edge, Val>)new Node(pushNode.location(), curr.fact()));
        }
        return (W)weight;
    }

    void addOtherThanOneWeight(Node<ControlFlowGraph.Edge, Val> curr) {
        if (this.nonOneFlowNodes.add(curr)) {
            for (NonOneFlowListener l : Lists.newArrayList(this.listeners)) {
                l.nonOneFlow(curr);
            }
        }
    }

    public W normal(Node<ControlFlowGraph.Edge, Val> curr, Node<ControlFlowGraph.Edge, Val> succ) {
        Weight weight = this.delegate.normal(curr, succ);
        if (this.isObjectFlowPhase() && ((ControlFlowGraph.Edge)succ.stmt()).getTarget().containsInvokeExpr() && !weight.equals(this.getOne())) {
            this.addOtherThanOneWeight(succ);
        }
        return (W)weight;
    }

    private boolean isObjectFlowPhase() {
        return this.phase.equals((Object)IDEALSeedSolver.Phases.ObjectFlow);
    }

    private boolean isValueFlowPhase() {
        return this.phase.equals((Object)IDEALSeedSolver.Phases.ValueFlow);
    }

    public W pop(Node<ControlFlowGraph.Edge, Val> curr) {
        return (W)this.delegate.pop(curr);
    }

    public void registerListener(NonOneFlowListener listener) {
        if (this.listeners.add(listener)) {
            for (Node existing : Lists.newArrayList(this.nonOneFlowNodes)) {
                listener.nonOneFlow((Node<ControlFlowGraph.Edge, Val>)existing);
            }
        }
    }

    public W getOne() {
        return (W)this.delegate.getOne();
    }

    public String toString() {
        return "[IDEAL-Wrapped Weights] " + this.delegate.toString();
    }

    public void potentialStrongUpdate(ControlFlowGraph.Edge stmt) {
        this.potentialStrongUpdates.add(stmt);
    }

    public void weakUpdate(ControlFlowGraph.Edge stmt) {
        this.weakUpdates.add(stmt);
    }

    public void setPhase(IDEALSeedSolver.Phases phase) {
        this.phase = phase;
    }

    public void addIndirectFlow(Node<ControlFlowGraph.Edge, Val> source, Node<ControlFlowGraph.Edge, Val> target) {
        if (source.equals(target)) {
            return;
        }
        logger.trace("Alias flow detected " + source + " " + target);
        this.indirectAlias.put(source, target);
    }

    public Collection<Node<ControlFlowGraph.Edge, Val>> getAliasesFor(Node<ControlFlowGraph.Edge, Val> node) {
        return this.indirectAlias.get(node);
    }

    public boolean isStrongUpdateStatement(ControlFlowGraph.Edge stmt) {
        return this.potentialStrongUpdates.contains(stmt) && !this.weakUpdates.contains(stmt) && this.strongUpdates;
    }

    public boolean isKillFlow(Node<ControlFlowGraph.Edge, Val> node) {
        return !this.nodesWithStrongUpdate.contains(node);
    }

    public void addNonKillFlow(Node<ControlFlowGraph.Edge, Val> curr) {
        this.nodesWithStrongUpdate.add(curr);
    }
}

