/*
 * Decompiled with CFR 0.152.
 */
package typestate;

import boomerang.scene.ControlFlowGraph;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import typestate.finiteautomata.ITransition;
import typestate.finiteautomata.Transition;
import wpds.impl.Weight;

public class TransitionFunction
extends Weight {
    private final Set<ITransition> value;
    private final String rep;
    private static TransitionFunction one;
    private static TransitionFunction zero;
    private Set<ControlFlowGraph.Edge> stateChangeStatements;

    public TransitionFunction(Set<? extends ITransition> trans, Set<ControlFlowGraph.Edge> stateChangeStatements) {
        this.stateChangeStatements = stateChangeStatements;
        this.value = new HashSet<ITransition>(trans);
        this.rep = null;
    }

    public TransitionFunction(ITransition trans, Set<ControlFlowGraph.Edge> stateChangeStatements) {
        this(new HashSet<ITransition>(Collections.singleton(trans)), stateChangeStatements);
    }

    private TransitionFunction(String rep) {
        this.value = Sets.newHashSet();
        this.rep = rep;
        this.stateChangeStatements = Sets.newHashSet();
    }

    public Collection<ITransition> values() {
        return Lists.newArrayList(this.value);
    }

    public Set<ControlFlowGraph.Edge> getLastStateChangeStatements() {
        return this.stateChangeStatements;
    }

    public Weight extendWith(Weight other) {
        if (other.equals((Object)TransitionFunction.one())) {
            return this;
        }
        if (this.equals((Object)TransitionFunction.one())) {
            return other;
        }
        if (other.equals((Object)TransitionFunction.zero()) || this.equals((Object)TransitionFunction.zero())) {
            return TransitionFunction.zero();
        }
        TransitionFunction func = (TransitionFunction)other;
        Set<ITransition> otherTransitions = func.value;
        HashSet<ITransition> ress = new HashSet<ITransition>();
        HashSet<ControlFlowGraph.Edge> newStateChangeStatements = new HashSet<ControlFlowGraph.Edge>();
        for (ITransition first : this.value) {
            for (ITransition second : otherTransitions) {
                if (second.equals(Transition.identity())) {
                    ress.add(first);
                    newStateChangeStatements.addAll(this.stateChangeStatements);
                    continue;
                }
                if (first.equals(Transition.identity())) {
                    ress.add(second);
                    newStateChangeStatements.addAll(func.stateChangeStatements);
                    continue;
                }
                if (!first.to().equals(second.from())) continue;
                ress.add(new Transition(first.from(), second.to()));
                newStateChangeStatements.addAll(func.stateChangeStatements);
            }
        }
        return new TransitionFunction(ress, newStateChangeStatements);
    }

    public Weight combineWith(Weight other) {
        if (!(other instanceof TransitionFunction)) {
            throw new RuntimeException();
        }
        if (this.equals((Object)TransitionFunction.zero())) {
            return other;
        }
        if (other.equals((Object)TransitionFunction.zero())) {
            return this;
        }
        if (other.equals((Object)TransitionFunction.one()) && this.equals((Object)TransitionFunction.one())) {
            return TransitionFunction.one();
        }
        TransitionFunction func = (TransitionFunction)other;
        if (other.equals((Object)TransitionFunction.one()) || this.equals((Object)TransitionFunction.one())) {
            HashSet<ITransition> transitions = new HashSet<ITransition>(other.equals((Object)TransitionFunction.one()) ? this.value : func.value);
            HashSet idTransitions = Sets.newHashSet();
            for (ITransition t : transitions) {
                idTransitions.add(new Transition(t.from(), t.from()));
            }
            transitions.addAll(idTransitions);
            return new TransitionFunction(transitions, (Set<ControlFlowGraph.Edge>)Sets.newHashSet(other.equals((Object)TransitionFunction.one()) ? this.stateChangeStatements : func.stateChangeStatements));
        }
        HashSet<ITransition> transitions = new HashSet<ITransition>(func.value);
        transitions.addAll(this.value);
        HashSet newStateChangeStmts = Sets.newHashSet(this.stateChangeStatements);
        newStateChangeStmts.addAll(func.stateChangeStatements);
        return new TransitionFunction(transitions, (Set<ControlFlowGraph.Edge>)newStateChangeStmts);
    }

    public static TransitionFunction one() {
        if (one == null) {
            one = new TransitionFunction("ONE");
        }
        return one;
    }

    public static TransitionFunction zero() {
        if (zero == null) {
            zero = new TransitionFunction("ZERO");
        }
        return zero;
    }

    public String toString() {
        if (this.rep != null) {
            return this.rep;
        }
        return "Weight: " + this.value.toString() + "";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rep == null ? 0 : this.rep.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        TransitionFunction other = (TransitionFunction)((Object)obj);
        if (this.rep == null ? other.rep != null : !this.rep.equals(other.rep)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

