/*
 * Decompiled with CFR 0.152.
 */
package typestate.finiteautomata;

import boomerang.scene.DeclaredMethod;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import typestate.finiteautomata.State;
import typestate.finiteautomata.Transition;

public class MatcherTransition
extends Transition {
    private static final Logger LOGGER = LoggerFactory.getLogger(MatcherTransition.class);
    private Type type;
    private Parameter param;
    private String methodMatcher;
    private boolean negate = false;

    public MatcherTransition(State from, String methodMatcher, Parameter param, State to, Type type) {
        super(from, to);
        this.methodMatcher = methodMatcher;
        this.type = type;
        this.param = param;
    }

    public MatcherTransition(State from, String methodMatcher, boolean negate, Parameter param, State to, Type type) {
        super(from, to);
        this.methodMatcher = methodMatcher;
        this.negate = negate;
        this.type = type;
        this.param = param;
    }

    public boolean matches(DeclaredMethod declaredMethod) {
        boolean matches = Pattern.matches(this.methodMatcher, declaredMethod.getSubSignature());
        if (matches) {
            LOGGER.debug("Found matching transition at call site {} for {}", (Object)declaredMethod.getInvokeExpr(), (Object)this);
        }
        return this.negate ? !matches : matches;
    }

    public Type getType() {
        return this.type;
    }

    public Parameter getParam() {
        return this.param;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.methodMatcher == null ? 0 : this.methodMatcher.hashCode());
        result = 31 * result + (this.negate ? 1231 : 1237);
        result = 31 * result + (this.param == null ? 0 : this.param.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MatcherTransition other = (MatcherTransition)obj;
        if (this.methodMatcher == null ? other.methodMatcher != null : !this.methodMatcher.equals(other.methodMatcher)) {
            return false;
        }
        if (this.negate != other.negate) {
            return false;
        }
        if (this.param != other.param) {
            return false;
        }
        return this.type == other.type;
    }

    public static enum Parameter {
        This,
        Param1,
        Param2;

    }

    public static enum Type {
        OnCall,
        None,
        OnCallToReturn,
        OnCallOrOnCallToReturn;

    }
}

