/*
 * Decompiled with CFR 0.152.
 */
package typestate.finiteautomata;

import boomerang.WeightedForwardQuery;
import boomerang.scene.AllocVal;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.InvokeExpr;
import boomerang.scene.Statement;
import boomerang.scene.Type;
import boomerang.scene.Val;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Scene;
import soot.SootClass;
import sync.pds.solver.WeightFunctions;
import sync.pds.solver.nodes.Node;
import typestate.TransitionFunction;
import typestate.finiteautomata.MatcherTransition;
import typestate.finiteautomata.State;
import typestate.finiteautomata.Transition;
import wpds.impl.Weight;

public abstract class TypeStateMachineWeightFunctions
implements WeightFunctions<ControlFlowGraph.Edge, Val, ControlFlowGraph.Edge, TransitionFunction> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeStateMachineWeightFunctions.class);
    public Set<MatcherTransition> transition = new HashSet<MatcherTransition>();

    public void addTransition(MatcherTransition trans) {
        this.transition.add(trans);
    }

    public TransitionFunction getOne() {
        return TransitionFunction.one();
    }

    public TransitionFunction pop(Node<ControlFlowGraph.Edge, Val> curr) {
        LOGGER.trace("Getting pop weights for {} which returns to {}", curr);
        return this.getOne();
    }

    public TransitionFunction push(Node<ControlFlowGraph.Edge, Val> curr, Node<ControlFlowGraph.Edge, Val> succ, ControlFlowGraph.Edge push) {
        return this.getMatchingTransitions((ControlFlowGraph.Edge)succ.stmt(), (Val)succ.fact(), push, Collections2.filter(this.transition, input -> input.getType().equals((Object)MatcherTransition.Type.OnCall) || input.getType().equals((Object)MatcherTransition.Type.OnCallOrOnCallToReturn)), MatcherTransition.Type.OnCall);
    }

    public TransitionFunction normal(Node<ControlFlowGraph.Edge, Val> curr, Node<ControlFlowGraph.Edge, Val> succ) {
        if (((ControlFlowGraph.Edge)succ.stmt()).getTarget().containsInvokeExpr()) {
            return this.callToReturn(curr, succ, ((ControlFlowGraph.Edge)succ.stmt()).getTarget().getInvokeExpr());
        }
        return this.getOne();
    }

    public TransitionFunction callToReturn(Node<ControlFlowGraph.Edge, Val> curr, Node<ControlFlowGraph.Edge, Val> succ, InvokeExpr invokeExpr) {
        HashSet res = Sets.newHashSet();
        if (invokeExpr.isInstanceInvokeExpr() && invokeExpr.getBase().equals(succ.fact())) {
            for (MatcherTransition trans : this.transition) {
                if (!trans.matches(invokeExpr.getMethod()) || !trans.getType().equals((Object)MatcherTransition.Type.OnCallToReturn) && !trans.getType().equals((Object)MatcherTransition.Type.OnCallOrOnCallToReturn)) continue;
                res.add(trans);
            }
        }
        if (!res.isEmpty()) {
            LOGGER.trace("Typestate transition at {} to {}, [{}]", new Object[]{succ.stmt(), res, MatcherTransition.Type.OnCallToReturn});
        }
        return res.isEmpty() ? this.getOne() : new TransitionFunction(res, Collections.singleton(succ.stmt()));
    }

    private TransitionFunction getMatchingTransitions(ControlFlowGraph.Edge edge, Val node, ControlFlowGraph.Edge transitionEdge, Collection<MatcherTransition> filteredTrans, MatcherTransition.Type type) {
        Statement transitionStmt = transitionEdge.getStart();
        HashSet<Transition> res = new HashSet<Transition>();
        if (filteredTrans.isEmpty() || !transitionStmt.containsInvokeExpr()) {
            return this.getOne();
        }
        for (MatcherTransition trans : filteredTrans) {
            if (!trans.matches(transitionStmt.getInvokeExpr().getMethod())) continue;
            LOGGER.trace("Found potential transition at {}, now checking if parameter match", (Object)transitionStmt);
            MatcherTransition.Parameter param = trans.getParam();
            if (param.equals((Object)MatcherTransition.Parameter.This) && edge.getMethod().isThisLocal(node)) {
                res.add(new Transition(trans.from(), trans.to()));
            }
            if (param.equals((Object)MatcherTransition.Parameter.Param1) && edge.getMethod().getParameterLocal(0).equals((Object)node)) {
                res.add(new Transition(trans.from(), trans.to()));
            }
            if (!param.equals((Object)MatcherTransition.Parameter.Param2) || !edge.getMethod().getParameterLocal(1).equals((Object)node)) continue;
            res.add(new Transition(trans.from(), trans.to()));
        }
        if (res.isEmpty()) {
            return this.getOne();
        }
        LOGGER.debug("Typestate transition at {} to {}, [{}]", new Object[]{transitionStmt, res, type});
        return new TransitionFunction(res, Collections.singleton(transitionEdge));
    }

    protected List<SootClass> getSubclassesOf(String className) {
        SootClass sootClass = Scene.v().getSootClass(className);
        List list = Scene.v().getActiveHierarchy().getSubclassesOfIncluding(sootClass);
        LinkedList<SootClass> res = new LinkedList<SootClass>();
        for (SootClass c : list) {
            res.add(c);
        }
        return res;
    }

    protected Collection<WeightedForwardQuery<TransitionFunction>> getLeftSideOf(ControlFlowGraph.Edge edge) {
        Statement s = edge.getStart();
        if (s.isAssign()) {
            return Collections.singleton(new WeightedForwardQuery(edge, (Val)new AllocVal(s.getLeftOp(), s, s.getRightOp()), (Weight)this.initialTransition()));
        }
        return Collections.emptySet();
    }

    protected Collection<WeightedForwardQuery<TransitionFunction>> generateAtAllocationSiteOf(ControlFlowGraph.Edge edge, Class allocationSuperType) {
        Type newExprType;
        Statement s = edge.getStart();
        if (s.isAssign() && s.getRightOp().isNewExpr() && (newExprType = s.getRightOp().getNewExprType()).isSubtypeOf(allocationSuperType.getName())) {
            return Collections.singleton(new WeightedForwardQuery(edge, (Val)new AllocVal(s.getLeftOp(), s, s.getRightOp()), (Weight)this.initialTransition()));
        }
        return Collections.emptySet();
    }

    public Collection<WeightedForwardQuery<TransitionFunction>> generateThisAtAnyCallSitesOf(ControlFlowGraph.Edge edge, String declaredType, String declaredMethod) {
        Statement unit = edge.getStart();
        if (unit.containsInvokeExpr() && unit.getInvokeExpr().isInstanceInvokeExpr()) {
            Val base = unit.getInvokeExpr().getBase();
            if (unit.getInvokeExpr().getMethod().getSignature().matches(declaredMethod) && base.getType().isSubtypeOf(declaredType)) {
                return Collections.singleton(new WeightedForwardQuery(edge, (Val)new AllocVal(base, unit, base), (Weight)this.initialTransition()));
            }
        }
        return Collections.emptySet();
    }

    public String toString() {
        return Joiner.on((String)"\n").join(this.transition);
    }

    public abstract Collection<WeightedForwardQuery<TransitionFunction>> generateSeed(ControlFlowGraph.Edge var1);

    public TransitionFunction initialTransition() {
        return new TransitionFunction(new Transition(this.initialState(), this.initialState()), Collections.emptySet());
    }

    protected abstract State initialState();
}

