/*
 * Decompiled with CFR 0.152.
 */
package typestate.impl.statemachines;

import boomerang.WeightedForwardQuery;
import boomerang.scene.ControlFlowGraph;
import java.util.Collection;
import typestate.TransitionFunction;
import typestate.finiteautomata.MatcherTransition;
import typestate.finiteautomata.State;
import typestate.finiteautomata.TypeStateMachineWeightFunctions;

public class InputStreamStateMachine
extends TypeStateMachineWeightFunctions {
    private static final String CLOSE_METHODS = ".* close.*";
    private static final String READ_METHODS = ".* read.*";
    private static final String TYPE = "java.io.InputStream";

    public InputStreamStateMachine() {
        this.addTransition(new MatcherTransition(States.CLOSED, CLOSE_METHODS, MatcherTransition.Parameter.This, States.CLOSED, MatcherTransition.Type.OnCall));
        this.addTransition(new MatcherTransition(States.CLOSED, READ_METHODS, MatcherTransition.Parameter.This, States.ERROR, MatcherTransition.Type.OnCall));
        this.addTransition(new MatcherTransition(States.ERROR, READ_METHODS, MatcherTransition.Parameter.This, States.ERROR, MatcherTransition.Type.OnCall));
        this.addTransition(new MatcherTransition(States.CLOSED, READ_METHODS, MatcherTransition.Parameter.This, States.ERROR, MatcherTransition.Type.OnCallToReturn));
        this.addTransition(new MatcherTransition(States.ERROR, READ_METHODS, MatcherTransition.Parameter.This, States.ERROR, MatcherTransition.Type.OnCallToReturn));
    }

    @Override
    public Collection<WeightedForwardQuery<TransitionFunction>> generateSeed(ControlFlowGraph.Edge edge) {
        return this.generateThisAtAnyCallSitesOf(edge, TYPE, CLOSE_METHODS);
    }

    @Override
    public State initialState() {
        return States.CLOSED;
    }

    public static enum States implements State
    {
        CLOSED,
        ERROR;


        @Override
        public boolean isErrorState() {
            return this == ERROR;
        }

        @Override
        public boolean isInitialState() {
            return false;
        }

        @Override
        public boolean isAccepting() {
            return false;
        }
    }
}

