/*
 * Decompiled with CFR 0.152.
 */
package typestate.impl.statemachines;

import boomerang.WeightedForwardQuery;
import boomerang.scene.ControlFlowGraph;
import java.util.Collection;
import typestate.TransitionFunction;
import typestate.finiteautomata.MatcherTransition;
import typestate.finiteautomata.State;
import typestate.finiteautomata.TypeStateMachineWeightFunctions;

public class OutputStreamStateMachine
extends TypeStateMachineWeightFunctions {
    private static final String CLOSE_METHODS = ".* close.*";
    private static final String WRITE_METHODS = ".* write.*";
    private static final String TYPE = "java.io.OutputStream";

    public OutputStreamStateMachine() {
        this.addTransition(new MatcherTransition(States.NONE, CLOSE_METHODS, MatcherTransition.Parameter.This, States.CLOSED, MatcherTransition.Type.OnCall));
        this.addTransition(new MatcherTransition(States.CLOSED, CLOSE_METHODS, MatcherTransition.Parameter.This, States.CLOSED, MatcherTransition.Type.OnCall));
        this.addTransition(new MatcherTransition(States.CLOSED, WRITE_METHODS, MatcherTransition.Parameter.This, States.ERROR, MatcherTransition.Type.OnCall));
        this.addTransition(new MatcherTransition(States.ERROR, WRITE_METHODS, MatcherTransition.Parameter.This, States.ERROR, MatcherTransition.Type.OnCall));
    }

    @Override
    public Collection<WeightedForwardQuery<TransitionFunction>> generateSeed(ControlFlowGraph.Edge edge) {
        return this.generateThisAtAnyCallSitesOf(edge, TYPE, CLOSE_METHODS);
    }

    @Override
    protected State initialState() {
        return States.NONE;
    }

    public static enum States implements State
    {
        NONE,
        CLOSED,
        ERROR;


        @Override
        public boolean isErrorState() {
            return this == ERROR;
        }

        @Override
        public boolean isInitialState() {
            return false;
        }

        @Override
        public boolean isAccepting() {
            return false;
        }
    }
}

