/*
 * Decompiled with CFR 0.152.
 */
package ideal;

import boomerang.BackwardQuery;
import boomerang.ForwardQuery;
import boomerang.Query;
import boomerang.WeightedBoomerang;
import boomerang.results.BackwardBoomerangResults;
import boomerang.results.ForwardBoomerangResults;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.Field;
import boomerang.scene.Statement;
import boomerang.scene.Val;
import boomerang.solver.AbstractBoomerangSolver;
import boomerang.solver.ForwardBoomerangSolver;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import ideal.IDEALAnalysisDefinition;
import ideal.IDEALSeedTimeout;
import ideal.IDEALWeightFunctions;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sync.pds.solver.OneWeightFunctions;
import sync.pds.solver.WeightFunctions;
import sync.pds.solver.nodes.GeneratedState;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import sync.pds.solver.nodes.SingleNode;
import wpds.impl.NormalRule;
import wpds.impl.PushRule;
import wpds.impl.Rule;
import wpds.impl.StackListener;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.interfaces.Location;
import wpds.interfaces.State;
import wpds.interfaces.WPAStateListener;
import wpds.interfaces.WPAUpdateListener;

public class IDEALSeedSolver<W extends Weight> {
    private static Logger LOGGER = LoggerFactory.getLogger(IDEALSeedSolver.class);
    private final IDEALAnalysisDefinition<W> analysisDefinition;
    private final ForwardQuery seed;
    private final IDEALWeightFunctions<W> idealWeightFunctions;
    private final W one;
    private final WeightedBoomerang<W> phase1Solver;
    private final WeightedBoomerang<W> phase2Solver;
    private final Stopwatch analysisStopwatch = Stopwatch.createUnstarted();
    private Multimap<Node<ControlFlowGraph.Edge, Val>, ControlFlowGraph.Edge> affectedStrongUpdateStmt = HashMultimap.create();
    private Set<Node<ControlFlowGraph.Edge, Val>> weakUpdates = Sets.newHashSet();
    private int killedRules;

    public IDEALSeedSolver(IDEALAnalysisDefinition<W> analysisDefinition, ForwardQuery seed) {
        this.analysisDefinition = analysisDefinition;
        this.seed = seed;
        this.idealWeightFunctions = new IDEALWeightFunctions<W>(analysisDefinition.weightFunctions(), analysisDefinition.enableStrongUpdates());
        this.one = analysisDefinition.weightFunctions().getOne();
        this.phase1Solver = this.createSolver(Phases.ObjectFlow);
        this.phase2Solver = this.createSolver(Phases.ValueFlow);
    }

    public ForwardBoomerangResults<W> run() {
        LOGGER.debug("Starting Phase 1 of IDEal");
        ForwardBoomerangResults<W> resultPhase1 = this.runPhase(this.phase1Solver, Phases.ObjectFlow);
        if (resultPhase1.isTimedout()) {
            if (this.analysisStopwatch.isRunning()) {
                this.analysisStopwatch.stop();
            }
            throw new IDEALSeedTimeout(this, this.phase1Solver, resultPhase1);
        }
        LOGGER.debug("Starting Phase 2 of IDEal");
        ForwardBoomerangResults<W> resultPhase2 = this.runPhase(this.phase2Solver, Phases.ValueFlow);
        if (resultPhase2.isTimedout()) {
            if (this.analysisStopwatch.isRunning()) {
                this.analysisStopwatch.stop();
            }
            throw new IDEALSeedTimeout(this, this.phase2Solver, resultPhase2);
        }
        LOGGER.debug("Killed Strong Update Rules {}", (Object)this.killedRules);
        return resultPhase2;
    }

    private WeightedBoomerang<W> createSolver(final Phases phase) {
        return new WeightedBoomerang<W>(this.analysisDefinition.callGraph(), this.analysisDefinition.getDataFlowScope(), this.analysisDefinition.boomerangOptions()){

            protected WeightFunctions<ControlFlowGraph.Edge, Val, ControlFlowGraph.Edge, W> getForwardCallWeights(ForwardQuery sourceQuery) {
                if (sourceQuery.equals((Object)IDEALSeedSolver.this.seed)) {
                    return IDEALSeedSolver.this.idealWeightFunctions;
                }
                return new OneWeightFunctions(IDEALSeedSolver.this.one);
            }

            protected WeightFunctions<ControlFlowGraph.Edge, Val, Field, W> getForwardFieldWeights() {
                return new OneWeightFunctions(IDEALSeedSolver.this.one);
            }

            protected WeightFunctions<ControlFlowGraph.Edge, Val, Field, W> getBackwardFieldWeights() {
                return new OneWeightFunctions(IDEALSeedSolver.this.one);
            }

            protected WeightFunctions<ControlFlowGraph.Edge, Val, ControlFlowGraph.Edge, W> getBackwardCallWeights() {
                return new OneWeightFunctions(IDEALSeedSolver.this.one);
            }

            public boolean preventCallRuleAdd(ForwardQuery sourceQuery, Rule<ControlFlowGraph.Edge, INode<Val>, W> rule) {
                return phase.equals((Object)Phases.ValueFlow) && sourceQuery.equals((Object)IDEALSeedSolver.this.seed) && IDEALSeedSolver.this.preventStrongUpdateFlows(rule);
            }
        };
    }

    protected boolean preventStrongUpdateFlows(Rule<ControlFlowGraph.Edge, INode<Val>, W> rule) {
        PushRule pushRule;
        ControlFlowGraph.Edge callSite;
        if (((INode)rule.getS1()).equals(rule.getS2()) && this.idealWeightFunctions.isStrongUpdateStatement((ControlFlowGraph.Edge)rule.getL2()) && this.idealWeightFunctions.isKillFlow((Node<ControlFlowGraph.Edge, Val>)new Node((Object)((ControlFlowGraph.Edge)rule.getL2()), (Object)((Val)((INode)rule.getS2()).fact())))) {
            ++this.killedRules;
            return true;
        }
        if (rule instanceof PushRule && this.idealWeightFunctions.isStrongUpdateStatement(callSite = (ControlFlowGraph.Edge)(pushRule = (PushRule)rule).getCallSite()) && this.idealWeightFunctions.isKillFlow((Node<ControlFlowGraph.Edge, Val>)new Node((Object)callSite, (Object)((Val)((INode)rule.getS1()).fact())))) {
            ++this.killedRules;
            return true;
        }
        return false;
    }

    private ForwardBoomerangResults<W> runPhase(WeightedBoomerang<W> boomerang, Phases phase) {
        this.analysisStopwatch.start();
        this.idealWeightFunctions.setPhase(phase);
        if (phase.equals((Object)Phases.ValueFlow)) {
            this.registerIndirectFlowListener((AbstractBoomerangSolver)boomerang.getSolvers().getOrCreate((Object)this.seed));
        }
        this.idealWeightFunctions.registerListener(curr -> {
            if (phase.equals((Object)Phases.ValueFlow)) {
                return;
            }
            AbstractBoomerangSolver seedSolver = (AbstractBoomerangSolver)boomerang.getSolvers().getOrCreate((Object)this.seed);
            seedSolver.getFieldAutomaton().registerListener((WPAStateListener)new TriggerBackwardQuery(seedSolver, boomerang, (Node<ControlFlowGraph.Edge, Val>)curr));
        });
        ForwardBoomerangResults res = boomerang.solve(this.seed);
        this.analysisStopwatch.stop();
        if (LOGGER.isDebugEnabled()) {
            boomerang.printAllForwardCallAutomatonFlow();
        }
        boomerang.unregisterAllListeners();
        return res;
    }

    protected void addAffectedPotentialStrongUpdate(Node<ControlFlowGraph.Edge, Val> strongUpdateNode, ControlFlowGraph.Edge stmt) {
        if (this.affectedStrongUpdateStmt.put(strongUpdateNode, (Object)stmt)) {
            this.idealWeightFunctions.potentialStrongUpdate(stmt);
            if (this.weakUpdates.contains(strongUpdateNode)) {
                this.idealWeightFunctions.weakUpdate(stmt);
            }
        }
    }

    private void setWeakUpdate(Node<ControlFlowGraph.Edge, Val> curr) {
        LOGGER.debug("Weak update @ {}", curr);
        if (this.weakUpdates.add(curr)) {
            for (ControlFlowGraph.Edge s : Lists.newArrayList((Iterable)this.affectedStrongUpdateStmt.get(curr))) {
                this.idealWeightFunctions.weakUpdate(s);
            }
        }
    }

    private void registerIndirectFlowListener(AbstractBoomerangSolver<W> solver) {
        WeightedPAutomaton callAutomaton = solver.getCallAutomaton();
        callAutomaton.registerListener((t, w, aut) -> {
            if (t.getStart() instanceof GeneratedState) {
                return;
            }
            Node source = new Node((Object)((ControlFlowGraph.Edge)t.getLabel()), (Object)((Val)((INode)t.getStart()).fact()));
            Collection<Node<ControlFlowGraph.Edge, Val>> indirectFlows = this.idealWeightFunctions.getAliasesFor((Node<ControlFlowGraph.Edge, Val>)source);
            for (Node<ControlFlowGraph.Edge, Val> indirectFlow : indirectFlows) {
                solver.addCallRule((Rule)new NormalRule((State)new SingleNode((Object)((Val)source.fact())), (Location)((ControlFlowGraph.Edge)source.stmt()), (State)new SingleNode((Object)((Val)indirectFlow.fact())), (Location)((ControlFlowGraph.Edge)indirectFlow.stmt()), this.one));
                solver.addFieldRule((Rule)new NormalRule((State)solver.asFieldFact(source), (Location)solver.fieldWildCard(), (State)solver.asFieldFact(indirectFlow), (Location)solver.fieldWildCard(), this.one));
            }
        });
    }

    public WeightedBoomerang<W> getPhase1Solver() {
        return this.phase1Solver;
    }

    public WeightedBoomerang<W> getPhase2Solver() {
        return this.phase2Solver;
    }

    public Stopwatch getAnalysisStopwatch() {
        return this.analysisStopwatch;
    }

    public Query getSeed() {
        return this.seed;
    }

    public static enum Phases {
        ObjectFlow,
        ValueFlow;

    }

    private final class TriggerBackwardQuery
    extends WPAStateListener<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> {
        private final AbstractBoomerangSolver<W> seedSolver;
        private final WeightedBoomerang<W> boomerang;
        private final Node<ControlFlowGraph.Edge, Val> strongUpdateNode;

        private TriggerBackwardQuery(AbstractBoomerangSolver<W> seedSolver, WeightedBoomerang<W> boomerang, Node<ControlFlowGraph.Edge, Val> curr) {
            super((State)new SingleNode(curr));
            this.seedSolver = seedSolver;
            this.boomerang = boomerang;
            this.strongUpdateNode = curr;
        }

        public void onOutTransitionAdded(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> weightedPAutomaton) {
            if (!((Field)t.getLabel()).equals((Object)Field.empty())) {
                return;
            }
            IDEALSeedSolver.this.addAffectedPotentialStrongUpdate(this.strongUpdateNode, (ControlFlowGraph.Edge)this.strongUpdateNode.stmt());
            for (Statement u : ((ControlFlowGraph.Edge)this.strongUpdateNode.stmt()).getMethod().getControlFlowGraph().getPredsOf(((ControlFlowGraph.Edge)this.strongUpdateNode.stmt()).getStart())) {
                BackwardQuery query = BackwardQuery.make((ControlFlowGraph.Edge)new ControlFlowGraph.Edge(u, ((ControlFlowGraph.Edge)this.strongUpdateNode.stmt()).getStart()), (Val)((Val)this.strongUpdateNode.fact()));
                BackwardBoomerangResults queryResults = this.boomerang.solve(query);
                Set<ForwardQuery> queryAllocationSites = queryResults.getAllocationSites().keySet();
                this.setWeakUpdateIfNecessary();
                this.injectAliasesAtStrongUpdates(queryAllocationSites);
                this.injectAliasesAtStrongUpdatesAtCallStack(queryAllocationSites);
            }
        }

        private void injectAliasesAtStrongUpdatesAtCallStack(final Set<ForwardQuery> queryAllocationSites) {
            this.seedSolver.getCallAutomaton().registerListener((WPAStateListener)new StackListener<ControlFlowGraph.Edge, INode<Val>, W>(this.seedSolver.getCallAutomaton(), (INode)new SingleNode((Object)((Val)this.strongUpdateNode.fact())), (ControlFlowGraph.Edge)this.strongUpdateNode.stmt()){

                public void anyContext(ControlFlowGraph.Edge end) {
                }

                public void stackElement(ControlFlowGraph.Edge callSiteEdge) {
                    Statement callSite = callSiteEdge.getStart();
                    TriggerBackwardQuery.this.boomerang.checkTimeout();
                    IDEALSeedSolver.this.addAffectedPotentialStrongUpdate(TriggerBackwardQuery.this.strongUpdateNode, callSiteEdge);
                    for (ForwardQuery e : queryAllocationSites) {
                        AbstractBoomerangSolver solver = (AbstractBoomerangSolver)TriggerBackwardQuery.this.boomerang.getSolvers().get((Object)e);
                        solver.addApplySummaryListener((summaryCallSite, factInCallee, spInCallee, exitStmt, returnedFact) -> {
                            if (callSiteEdge.equals(summaryCallSite) && callSite.containsInvokeExpr()) {
                                if (returnedFact.isThisLocal() && callSite.getInvokeExpr().isInstanceInvokeExpr()) {
                                    solver.getCallAutomaton().registerListener((WPAUpdateListener)new AddIndirectFlowAtCallSite(callSiteEdge, callSite.getInvokeExpr().getBase()));
                                }
                                if (returnedFact.isReturnLocal() && callSite.isAssign()) {
                                    solver.getCallAutomaton().registerListener((WPAUpdateListener)new AddIndirectFlowAtCallSite(callSiteEdge, callSite.getLeftOp()));
                                }
                                for (int i = 0; i < callSite.getInvokeExpr().getArgs().size(); ++i) {
                                    if (!returnedFact.isParameterLocal(i)) continue;
                                    solver.getCallAutomaton().registerListener((WPAUpdateListener)new AddIndirectFlowAtCallSite(callSiteEdge, callSite.getInvokeExpr().getArg(i)));
                                }
                            }
                        });
                    }
                }
            });
        }

        private void injectAliasesAtStrongUpdates(Set<ForwardQuery> queryAllocationSites) {
            for (ForwardQuery e : queryAllocationSites) {
                AbstractBoomerangSolver solver = (AbstractBoomerangSolver)this.boomerang.getSolvers().get((Object)e);
                solver.getCallAutomaton().registerListener((t, w, aut) -> {
                    if (((ControlFlowGraph.Edge)t.getLabel()).equals(this.strongUpdateNode.stmt())) {
                        IDEALSeedSolver.this.idealWeightFunctions.addNonKillFlow(this.strongUpdateNode);
                        IDEALSeedSolver.this.idealWeightFunctions.addIndirectFlow(this.strongUpdateNode, (Node<ControlFlowGraph.Edge, Val>)new Node((Object)((ControlFlowGraph.Edge)this.strongUpdateNode.stmt()), (Object)((Val)((INode)t.getStart()).fact())));
                    }
                });
            }
        }

        private void setWeakUpdateIfNecessary() {
            for (Map.Entry e : this.boomerang.getSolvers().entrySet()) {
                ((ForwardBoomerangSolver)e.getValue()).synchedEmptyStackReachable(this.strongUpdateNode, targetFact -> {
                    if (!((ForwardQuery)e.getKey()).asNode().equals((Object)IDEALSeedSolver.this.seed.asNode()) && !((Val)((ForwardQuery)e.getKey()).asNode().fact()).isNull()) {
                        IDEALSeedSolver.this.setWeakUpdate(this.strongUpdateNode);
                    }
                });
            }
        }

        public void onInTransitionAdded(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> weightedPAutomaton) {
        }
    }

    private final class AddIndirectFlowAtCallSite
    implements WPAUpdateListener<ControlFlowGraph.Edge, INode<Val>, W> {
        private final ControlFlowGraph.Edge callSite;
        private final Val returnedFact;

        private AddIndirectFlowAtCallSite(ControlFlowGraph.Edge callSite, Val returnedFact) {
            this.callSite = callSite;
            this.returnedFact = returnedFact;
        }

        public void onWeightAdded(Transition<ControlFlowGraph.Edge, INode<Val>> t, W w, WeightedPAutomaton<ControlFlowGraph.Edge, INode<Val>, W> aut) {
            if (((ControlFlowGraph.Edge)t.getLabel()).equals((Object)this.callSite)) {
                IDEALSeedSolver.this.idealWeightFunctions.addNonKillFlow((Node<ControlFlowGraph.Edge, Val>)new Node((Object)this.callSite, (Object)this.returnedFact));
                IDEALSeedSolver.this.idealWeightFunctions.addIndirectFlow((Node<ControlFlowGraph.Edge, Val>)new Node((Object)this.callSite, (Object)this.returnedFact), (Node<ControlFlowGraph.Edge, Val>)new Node((Object)this.callSite, (Object)((Val)((INode)t.getStart()).fact())));
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.callSite == null ? 0 : this.callSite.hashCode());
            result = 31 * result + (this.returnedFact == null ? 0 : this.returnedFact.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddIndirectFlowAtCallSite other = (AddIndirectFlowAtCallSite)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.callSite == null ? other.callSite != null : !this.callSite.equals((Object)other.callSite)) {
                return false;
            }
            return !(this.returnedFact == null ? other.returnedFact != null : !this.returnedFact.equals((Object)other.returnedFact));
        }

        private IDEALSeedSolver getOuterType() {
            return IDEALSeedSolver.this;
        }
    }
}

