/*
 * Decompiled with CFR 0.152.
 */
package inference;

import boomerang.scene.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import wpds.impl.Weight;

public class InferenceWeight
extends Weight {
    private final Set<Method> invokedMethods;
    private final String rep;
    private static InferenceWeight one;
    private static InferenceWeight zero;

    private InferenceWeight(String rep) {
        this.rep = rep;
        this.invokedMethods = null;
    }

    private InferenceWeight(Set<Method> res) {
        this.invokedMethods = res;
        this.rep = null;
    }

    public InferenceWeight(Method m) {
        this.invokedMethods = Collections.singleton(m);
        this.rep = null;
    }

    public Weight extendWith(Weight other) {
        if (other.equals((Object)InferenceWeight.one())) {
            return this;
        }
        if (this.equals((Object)InferenceWeight.one())) {
            return other;
        }
        if (other.equals((Object)InferenceWeight.zero()) || this.equals((Object)InferenceWeight.zero())) {
            return InferenceWeight.zero();
        }
        InferenceWeight func = (InferenceWeight)other;
        Set<Method> otherInvokedMethods = func.invokedMethods;
        HashSet<Method> res = new HashSet<Method>(this.invokedMethods);
        res.addAll(otherInvokedMethods);
        return new InferenceWeight(res);
    }

    public Weight combineWith(Weight other) {
        return this.extendWith(other);
    }

    public static InferenceWeight one() {
        if (one == null) {
            one = new InferenceWeight("ONE");
        }
        return one;
    }

    public static InferenceWeight zero() {
        if (zero == null) {
            zero = new InferenceWeight("ZERO");
        }
        return zero;
    }

    public String toString() {
        if (this.rep != null) {
            return this.rep;
        }
        return "{Func:" + this.invokedMethods.toString() + "}";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rep == null ? 0 : this.rep.hashCode());
        result = 31 * result + (this.invokedMethods == null ? 0 : this.invokedMethods.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        InferenceWeight other = (InferenceWeight)((Object)obj);
        if (this.rep == null ? other.rep != null : !this.rep.equals(other.rep)) {
            return false;
        }
        return !(this.invokedMethods == null ? other.invokedMethods != null : !this.invokedMethods.equals(other.invokedMethods));
    }
}

