/*
 * Decompiled with CFR 0.152.
 */
package inference.example;

import boomerang.WeightedForwardQuery;
import boomerang.debugger.Debugger;
import boomerang.scene.CallGraph;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.DataFlowScope;
import boomerang.scene.SootDataFlowScope;
import boomerang.scene.Statement;
import boomerang.scene.Val;
import boomerang.scene.jimple.BoomerangPretransformer;
import boomerang.scene.jimple.SootCallGraph;
import com.google.common.base.Joiner;
import com.google.common.collect.Table;
import ideal.IDEALAnalysis;
import ideal.IDEALAnalysisDefinition;
import ideal.IDEALResultHandler;
import ideal.IDEALSeedSolver;
import ideal.StoreIDEALResultHandler;
import inference.InferenceWeight;
import inference.InferenceWeightFunctions;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.G;
import soot.PackManager;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootMethod;
import soot.Transform;
import soot.Transformer;
import soot.options.Options;
import sync.pds.solver.WeightFunctions;
import wpds.impl.Weight;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String ... args) {
        String sootClassPath = System.getProperty("user.dir") + File.separator + "target" + File.separator + "classes";
        String mainClass = "inference.example.InferenceExample";
        Main.setupSoot(sootClassPath, mainClass);
        Main.analyze();
    }

    private static void setupSoot(String sootClassPath, String mainClass) {
        G.v();
        G.reset();
        Options.v().set_whole_program(true);
        Options.v().setPhaseOption("cg.spark", "on");
        Options.v().set_output_format(12);
        Options.v().set_no_bodies_for_excluded(true);
        Options.v().set_allow_phantom_refs(true);
        LinkedList<String> includeList = new LinkedList<String>();
        includeList.add("java.lang.*");
        includeList.add("java.util.*");
        includeList.add("java.io.*");
        includeList.add("sun.misc.*");
        includeList.add("java.net.*");
        includeList.add("javax.servlet.*");
        includeList.add("javax.crypto.*");
        Options.v().set_include(includeList);
        Options.v().setPhaseOption("jb", "use-original-names:true");
        Options.v().set_soot_classpath(sootClassPath);
        Options.v().set_prepend_classpath(true);
        Scene.v().loadNecessaryClasses();
        SootClass c = Scene.v().forceResolve(mainClass, 3);
        if (c != null) {
            c.setApplicationClass();
            for (SootMethod m : c.getMethods()) {
                logger.debug(m.toString());
            }
        }
    }

    private static void analyze() {
        Transform transform = new Transform("wjtp.ifds", Main.createAnalysisTransformer());
        PackManager.v().getPack("wjtp").add(transform);
        PackManager.v().getPack("cg").apply();
        BoomerangPretransformer.v().apply();
        PackManager.v().getPack("wjtp").apply();
    }

    private static Transformer createAnalysisTransformer() {
        return new SceneTransformer(){

            protected void internalTransform(String phaseName, Map options) {
                final StoreIDEALResultHandler resultHandler = new StoreIDEALResultHandler();
                SootCallGraph callGraph = new SootCallGraph();
                IDEALAnalysis<InferenceWeight> solver = new IDEALAnalysis<InferenceWeight>(new IDEALAnalysisDefinition<InferenceWeight>((CallGraph)callGraph){
                    final /* synthetic */ CallGraph val$callGraph;
                    {
                        this.val$callGraph = callGraph;
                    }

                    @Override
                    public Collection<WeightedForwardQuery<InferenceWeight>> generate(ControlFlowGraph.Edge edge) {
                        Statement stmt = edge.getStart();
                        if (stmt.isAssign() && stmt.getRightOp().isNewExpr() && stmt.getRightOp().getType().toString().contains("inference.example.InferenceExample$File")) {
                            return Collections.singleton(new WeightedForwardQuery(edge, stmt.getLeftOp(), (Weight)InferenceWeight.one()));
                        }
                        return Collections.emptySet();
                    }

                    @Override
                    public WeightFunctions<ControlFlowGraph.Edge, Val, ControlFlowGraph.Edge, InferenceWeight> weightFunctions() {
                        return new InferenceWeightFunctions();
                    }

                    @Override
                    public Debugger<InferenceWeight> debugger(IDEALSeedSolver<InferenceWeight> solver) {
                        return new Debugger();
                    }

                    @Override
                    public IDEALResultHandler<InferenceWeight> getResultHandler() {
                        return resultHandler;
                    }

                    @Override
                    public CallGraph callGraph() {
                        return this.val$callGraph;
                    }

                    @Override
                    protected DataFlowScope getDataFlowScope() {
                        return SootDataFlowScope.make((Scene)Scene.v());
                    }
                });
                solver.run();
                Map res = resultHandler.getResults();
                for (Map.Entry e : res.entrySet()) {
                    Table results = e.getValue().asStatementValWeightTable();
                    logger.info(Joiner.on((String)"\n").join((Iterable)results.cellSet()));
                }
            }
        };
    }
}

