/*
 * Decompiled with CFR 0.152.
 */
package typestate.impl.statemachines;

import boomerang.WeightedForwardQuery;
import boomerang.scene.AllocVal;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.DeclaredMethod;
import boomerang.scene.Statement;
import boomerang.scene.Val;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import soot.SootClass;
import soot.SootMethod;
import typestate.TransitionFunction;
import typestate.finiteautomata.MatcherTransition;
import typestate.finiteautomata.State;
import typestate.finiteautomata.TypeStateMachineWeightFunctions;
import wpds.impl.Weight;

public class KeyStoreStateMachine
extends TypeStateMachineWeightFunctions {
    private static String LOAD_METHOD = ".* load.*";

    public KeyStoreStateMachine() {
        this.addTransition(new MatcherTransition(States.INIT, LOAD_METHOD, MatcherTransition.Parameter.This, States.LOADED, MatcherTransition.Type.OnCallToReturn));
        this.addTransition(new MatcherTransition(States.LOADED, LOAD_METHOD, true, MatcherTransition.Parameter.This, States.LOADED, MatcherTransition.Type.OnCallToReturn));
        this.addTransition(new MatcherTransition(States.INIT, LOAD_METHOD, true, MatcherTransition.Parameter.This, States.ERROR, MatcherTransition.Type.OnCallToReturn));
        this.addTransition(new MatcherTransition(States.ERROR, LOAD_METHOD, true, MatcherTransition.Parameter.This, States.ERROR, MatcherTransition.Type.OnCallToReturn));
    }

    private Set<SootMethod> keyStoreConstructor() {
        List<SootClass> subclasses = this.getSubclassesOf("java.security.KeyStore");
        HashSet<SootMethod> out = new HashSet<SootMethod>();
        for (SootClass c : subclasses) {
            for (SootMethod m : c.getMethods()) {
                if (!m.getName().equals("getInstance") || !m.isStatic()) continue;
                out.add(m);
            }
        }
        return out;
    }

    public Set<WeightedForwardQuery<TransitionFunction>> generateSeed(ControlFlowGraph.Edge edge) {
        Statement unit = edge.getStart();
        if (unit.isAssign() && unit.containsInvokeExpr() && this.isKeyStoreConstructor(unit.getInvokeExpr().getMethod())) {
            return Collections.singleton(new WeightedForwardQuery(edge, (Val)new AllocVal(unit.getLeftOp(), unit, unit.getRightOp()), (Weight)this.initialTransition()));
        }
        return Collections.emptySet();
    }

    private boolean isKeyStoreConstructor(DeclaredMethod method) {
        return method.getName().equals("getInstance") && method.getSubSignature().contains("KeyStore");
    }

    @Override
    protected State initialState() {
        return States.INIT;
    }

    public static enum States implements State
    {
        NONE,
        INIT,
        LOADED,
        ERROR;


        @Override
        public boolean isErrorState() {
            return this == ERROR;
        }

        @Override
        public boolean isInitialState() {
            return false;
        }

        @Override
        public boolean isAccepting() {
            return false;
        }
    }
}

