/*
 * Decompiled with CFR 0.152.
 */
package typestate.impl.statemachines;

import boomerang.WeightedForwardQuery;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.DeclaredMethod;
import java.net.Socket;
import java.util.Collection;
import typestate.TransitionFunction;
import typestate.finiteautomata.MatcherTransition;
import typestate.finiteautomata.State;
import typestate.finiteautomata.TypeStateMachineWeightFunctions;

public class SocketStateMachine
extends TypeStateMachineWeightFunctions {
    private static String CONNECT_METHOD = ".* connect.*";

    public SocketStateMachine() {
        this.addTransition(new MatcherTransition(States.INIT, CONNECT_METHOD, MatcherTransition.Parameter.This, States.CONNECTED, MatcherTransition.Type.OnCallOrOnCallToReturn));
        this.addTransition(new MatcherTransition(States.ERROR, CONNECT_METHOD, MatcherTransition.Parameter.This, States.ERROR, MatcherTransition.Type.OnCallOrOnCallToReturn));
        this.addTransition(new UseMethodMatcher(States.CONNECTED, MatcherTransition.Parameter.This, States.CONNECTED, MatcherTransition.Type.OnCallOrOnCallToReturn));
        this.addTransition(new UseMethodMatcher(States.INIT, MatcherTransition.Parameter.This, States.ERROR, MatcherTransition.Type.OnCallOrOnCallToReturn));
        this.addTransition(new MatcherTransition(States.CONNECTED, CONNECT_METHOD, MatcherTransition.Parameter.This, States.CONNECTED, MatcherTransition.Type.OnCallOrOnCallToReturn));
        this.addTransition(new UseMethodMatcher(States.ERROR, MatcherTransition.Parameter.This, States.ERROR, MatcherTransition.Type.OnCallOrOnCallToReturn));
    }

    @Override
    public Collection<WeightedForwardQuery<TransitionFunction>> generateSeed(ControlFlowGraph.Edge unit) {
        return this.generateAtAllocationSiteOf(unit, Socket.class);
    }

    @Override
    protected State initialState() {
        return States.INIT;
    }

    private static class UseMethodMatcher
    extends MatcherTransition {
        public UseMethodMatcher(State from, MatcherTransition.Parameter param, State to, MatcherTransition.Type type) {
            super(from, CONNECT_METHOD, param, to, type);
        }

        @Override
        public boolean matches(DeclaredMethod declaredMethod) {
            if (super.matches(declaredMethod)) {
                return false;
            }
            boolean isSocketMethod = declaredMethod.getDeclaringClass().getFullyQualifiedName().equals("java.net.Socket");
            if (!isSocketMethod) {
                return false;
            }
            String methodName = declaredMethod.getName();
            boolean isConstructor = methodName.contains("<init>");
            boolean isSetImpl = methodName.startsWith("setImpl");
            return !isConstructor && !isSetImpl;
        }
    }

    public static enum States implements State
    {
        INIT,
        CONNECTED,
        ERROR;


        @Override
        public boolean isErrorState() {
            return this == ERROR;
        }

        @Override
        public boolean isInitialState() {
            return false;
        }

        @Override
        public boolean isAccepting() {
            return false;
        }
    }
}

