/*
 * Decompiled with CFR 0.152.
 */
package typestate.impl.statemachines;

import boomerang.WeightedForwardQuery;
import boomerang.scene.ControlFlowGraph;
import java.util.Collection;
import typestate.TransitionFunction;
import typestate.finiteautomata.MatcherTransition;
import typestate.finiteautomata.State;
import typestate.finiteautomata.TypeStateMachineWeightFunctions;

public class URLConnStateMachine
extends TypeStateMachineWeightFunctions {
    private static final String CONNECT_METHOD = ".* connect.*";
    private static final String TYPE = "java.net.URLConnection";
    private static final String ILLEGAL_OPERTIONS = ".* (setDoInput|setDoOutput|setAllowUserInteraction|setUseCaches|setIfModifiedSince|setRequestProperty|addRequestProperty|getRequestProperty|getRequestProperties).*";

    public URLConnStateMachine() {
        this.addTransition(new MatcherTransition(States.CONNECTED, ILLEGAL_OPERTIONS, MatcherTransition.Parameter.This, States.ERROR, MatcherTransition.Type.OnCall));
        this.addTransition(new MatcherTransition(States.ERROR, ILLEGAL_OPERTIONS, MatcherTransition.Parameter.This, States.ERROR, MatcherTransition.Type.OnCall));
    }

    @Override
    public Collection<WeightedForwardQuery<TransitionFunction>> generateSeed(ControlFlowGraph.Edge unit) {
        return this.generateThisAtAnyCallSitesOf(unit, TYPE, CONNECT_METHOD);
    }

    @Override
    protected State initialState() {
        return States.CONNECTED;
    }

    public static enum States implements State
    {
        NONE,
        INIT,
        CONNECTED,
        ERROR;


        @Override
        public boolean isErrorState() {
            return this == ERROR;
        }

        @Override
        public boolean isInitialState() {
            return false;
        }

        @Override
        public boolean isAccepting() {
            return false;
        }
    }
}

