/*
 * Decompiled with CFR 0.152.
 */
package typestate.impl.statemachines;

import boomerang.WeightedForwardQuery;
import boomerang.scene.ControlFlowGraph;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import typestate.TransitionFunction;
import typestate.finiteautomata.MatcherTransition;
import typestate.finiteautomata.State;
import typestate.finiteautomata.TypeStateMachineWeightFunctions;

public class VectorStateMachine
extends TypeStateMachineWeightFunctions {
    private static String ADD_ELEMENT_METHODS = "(.* (add|addAll|addElement|insertElementAt|set|setElementAt).*)|<java.util.Vector: void <init>(java.util.Collection)>";
    private static String ACCESS_ELEMENT_METHODS = ".* (elementAt|firstElement|lastElement|get).*";
    private static String REMOVE_ALL_METHODS = ".* removeAllElements.*";

    public VectorStateMachine() {
        this.addTransition(new MatcherTransition(States.INIT, ADD_ELEMENT_METHODS, MatcherTransition.Parameter.This, States.NOT_EMPTY, MatcherTransition.Type.OnCall));
        this.addTransition(new MatcherTransition(States.INIT, ACCESS_ELEMENT_METHODS, MatcherTransition.Parameter.This, States.ACCESSED_EMPTY, MatcherTransition.Type.OnCall));
        this.addTransition(new MatcherTransition(States.NOT_EMPTY, ACCESS_ELEMENT_METHODS, MatcherTransition.Parameter.This, States.NOT_EMPTY, MatcherTransition.Type.OnCall));
        this.addTransition(new MatcherTransition(States.NOT_EMPTY, ADD_ELEMENT_METHODS, MatcherTransition.Parameter.This, States.NOT_EMPTY, MatcherTransition.Type.OnCall));
        this.addTransition(new MatcherTransition(States.NOT_EMPTY, REMOVE_ALL_METHODS, MatcherTransition.Parameter.This, States.INIT, MatcherTransition.Type.OnCall));
        this.addTransition(new MatcherTransition(States.INIT, REMOVE_ALL_METHODS, MatcherTransition.Parameter.This, States.INIT, MatcherTransition.Type.OnCall));
        this.addTransition(new MatcherTransition(States.ACCESSED_EMPTY, ACCESS_ELEMENT_METHODS, MatcherTransition.Parameter.This, States.ACCESSED_EMPTY, MatcherTransition.Type.OnCall));
    }

    @Override
    public Collection<WeightedForwardQuery<TransitionFunction>> generateSeed(ControlFlowGraph.Edge unit) {
        if (unit.getMethod().toString().contains("<clinit>")) {
            return Collections.emptySet();
        }
        return this.generateAtAllocationSiteOf(unit, Vector.class);
    }

    @Override
    protected State initialState() {
        return States.INIT;
    }

    public static enum States implements State
    {
        INIT,
        NOT_EMPTY,
        ACCESSED_EMPTY;


        @Override
        public boolean isErrorState() {
            return this == ACCESSED_EMPTY;
        }

        @Override
        public boolean isInitialState() {
            return false;
        }

        @Override
        public boolean isAccepting() {
            return false;
        }
    }
}

