/*
 * Decompiled with CFR 0.152.
 */
package pathexpression;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pathexpression.Edge;
import pathexpression.Epsilon;
import pathexpression.IRegEx;
import pathexpression.LabeledGraph;
import pathexpression.PathExpression;
import pathexpression.RegEx;

public class PathExpressionComputer<N, V> {
    static final Logger logger = LogManager.getLogger(PathExpressionComputer.class);
    private LabeledGraph<N, V> graph;
    private BiMap<N, Integer> nodeToIntMap = HashBiMap.create();
    private Table<Integer, Integer, IRegEx<V>> table = HashBasedTable.create();
    private IRegEx<V> emptyRegEx = new RegEx.EmptySet();
    private Map<N, List<IRegEx<V>>> allPathFromNode = new HashMap<N, List<IRegEx<V>>>();
    private boolean eliminated;

    public PathExpressionComputer(LabeledGraph<N, V> graph) {
        this.graph = graph;
        this.initNodesToIntMap();
    }

    private void initNodesToIntMap() {
        int size = this.nodeToIntMap.size();
        for (N node : this.graph.getNodes()) {
            this.nodeToIntMap.put(node, (Object)(++size));
        }
    }

    private Integer getIntegerFor(N node) {
        assert (this.nodeToIntMap.get(node) != null);
        return (Integer)this.nodeToIntMap.get(node);
    }

    public IRegEx<V> getExpressionBetween(N a, N b) {
        if (!this.graph.getNodes().contains(a)) {
            return this.emptyRegEx;
        }
        List<IRegEx<V>> allExpr = this.computeAllPathFrom(a);
        return allExpr.get(this.getIntegerFor(b) - 1);
    }

    private List<IRegEx<V>> computeAllPathFrom(N a) {
        int i;
        assert (this.graph.getNodes().contains(a));
        if (this.allPathFromNode.get(a) != null) {
            return this.allPathFromNode.get(a);
        }
        this.eliminate();
        logger.debug("Compute all path from {}", a);
        List<PathExpression<V>> extractPathSequence = this.extractPathSequence();
        ArrayList<IRegEx<V>> regEx = new ArrayList<IRegEx<V>>();
        for (i = 0; i < this.graph.getNodes().size(); ++i) {
            regEx.add(this.emptyRegEx);
        }
        regEx.set(this.getIntegerFor(a) - 1, new Epsilon());
        for (i = 0; i < extractPathSequence.size(); ++i) {
            int vi;
            IRegEx<V> expression;
            PathExpression<V> tri = extractPathSequence.get(i);
            if (tri.getSource() == tri.getTarget()) {
                expression = tri.getExpression();
                vi = tri.getSource();
                IRegEx regExVi = (IRegEx)regEx.get(vi - 1);
                regEx.set(vi - 1, RegEx.concatenate(regExVi, expression));
                continue;
            }
            expression = tri.getExpression();
            vi = tri.getSource();
            int wi = tri.getTarget();
            IRegEx regExVi = (IRegEx)regEx.get(vi - 1);
            IRegEx<V> inter = RegEx.concatenate(regExVi, expression);
            IRegEx regExWi = (IRegEx)regEx.get(wi - 1);
            regEx.set(wi - 1, RegEx.union(regExWi, inter));
        }
        this.allPathFromNode.put(a, regEx);
        logger.debug("End extraction all path");
        return regEx;
    }

    private List<PathExpression<V>> extractPathSequence() {
        IRegEx reg;
        int w;
        int u;
        int n = this.graph.getNodes().size();
        ArrayList<PathExpression<V>> list = new ArrayList<PathExpression<V>>();
        for (u = 1; u <= n; ++u) {
            for (w = u; w <= n; ++w) {
                reg = (IRegEx)this.table.get((Object)u, (Object)w);
                if (reg instanceof RegEx.EmptySet || reg instanceof Epsilon) continue;
                list.add(new PathExpression(reg, u, w));
            }
        }
        for (u = n; u > 0; --u) {
            for (w = 1; w < u; ++w) {
                reg = (IRegEx)this.table.get((Object)u, (Object)w);
                if (reg instanceof RegEx.EmptySet) continue;
                list.add(new PathExpression(reg, u, w));
            }
        }
        return list;
    }

    private void eliminate() {
        if (this.eliminated) {
            return;
        }
        logger.debug("Start eliminating");
        int numberOfNodes = this.graph.getNodes().size();
        for (int v = 1; v <= numberOfNodes; ++v) {
            for (int w = 1; w <= numberOfNodes; ++w) {
                if (v == w) {
                    this.updateTable(v, w, new Epsilon());
                    continue;
                }
                this.updateTable(v, w, this.emptyRegEx);
            }
        }
        for (Edge<N, V> e : this.graph.getEdges()) {
            Integer head = this.getIntegerFor(e.getStart());
            Integer tail = this.getIntegerFor(e.getTarget());
            IRegEx<V> pht = (IRegEx<V>)this.table.get((Object)head, (Object)tail);
            pht = RegEx.union(new RegEx.Plain<V>(e.getLabel()), pht);
            this.updateTable(head, tail, pht);
        }
        for (int v = 1; v <= numberOfNodes; ++v) {
            IRegEx pvv = (IRegEx)this.table.get((Object)v, (Object)v);
            pvv = RegEx.star(pvv);
            this.updateTable(v, v, pvv);
            for (int u = v + 1; u <= numberOfNodes; ++u) {
                IRegEx puv = (IRegEx)this.table.get((Object)u, (Object)v);
                if (puv instanceof RegEx.EmptySet) continue;
                puv = RegEx.concatenate(puv, pvv);
                this.updateTable(u, v, puv);
                for (int w = v + 1; w <= numberOfNodes; ++w) {
                    IRegEx pvw = (IRegEx)this.table.get((Object)v, (Object)w);
                    if (pvw instanceof RegEx.EmptySet) continue;
                    IRegEx old_puw = (IRegEx)this.table.get((Object)u, (Object)w);
                    IRegEx a = RegEx.concatenate(puv, pvw);
                    IRegEx puw = RegEx.union(old_puw, a);
                    this.updateTable(u, w, puw);
                }
            }
        }
        this.eliminated = true;
        logger.debug("End eliminating");
    }

    private void updateTable(Integer i, Integer j, IRegEx<V> reg) {
        this.table.put((Object)i, (Object)j, reg);
    }
}

