/*
 * Decompiled with CFR 0.152.
 */
package sync.pds.solver;

import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sync.pds.solver.SyncPDSUpdateListener;
import sync.pds.solver.SyncStatePDSUpdateListener;
import sync.pds.solver.WeightFunctions;
import sync.pds.solver.nodes.ExclusionNode;
import sync.pds.solver.nodes.GeneratedState;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import sync.pds.solver.nodes.NodeWithLocation;
import sync.pds.solver.nodes.PopNode;
import sync.pds.solver.nodes.PushNode;
import sync.pds.solver.nodes.SingleNode;
import wpds.impl.NestedAutomatonListener;
import wpds.impl.NestedWeightedPAutomatons;
import wpds.impl.NormalRule;
import wpds.impl.PopRule;
import wpds.impl.PushRule;
import wpds.impl.Rule;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.impl.WeightedPushdownSystem;
import wpds.interfaces.Location;
import wpds.interfaces.State;
import wpds.interfaces.WPAStateListener;
import wpds.interfaces.WPAUpdateListener;

public abstract class SyncPDSSolver<Stmt extends Location, Fact, Field extends Location, W extends Weight> {
    private static final Logger logger = LoggerFactory.getLogger(SyncPDSSolver.class);
    private static final boolean FieldSensitive = true;
    private static final boolean ContextSensitive = true;
    protected final WeightedPushdownSystem<Stmt, INode<Fact>, W> callingPDS = new WeightedPushdownSystem<Stmt, INode<Fact>, W>(){

        public String toString() {
            return "Call " + SyncPDSSolver.this.toString();
        }
    };
    protected final WeightedPushdownSystem<Field, INode<Node<Stmt, Fact>>, W> fieldPDS = new WeightedPushdownSystem<Field, INode<Node<Stmt, Fact>>, W>(){

        public String toString() {
            return "Field " + SyncPDSSolver.this.toString();
        }
    };
    private final Set<Node<Stmt, Fact>> reachedStates = Sets.newHashSet();
    private final Set<Node<Stmt, Fact>> callingContextReachable = Sets.newHashSet();
    private final Set<Node<Stmt, Fact>> fieldContextReachable = Sets.newHashSet();
    private final Set<SyncPDSUpdateListener<Stmt, Fact>> updateListeners = Sets.newHashSet();
    private final Multimap<Node<Stmt, Fact>, SyncStatePDSUpdateListener<Stmt, Fact>> reachedStateUpdateListeners = HashMultimap.create();
    protected final WeightedPAutomaton<Field, INode<Node<Stmt, Fact>>, W> fieldAutomaton;
    protected final WeightedPAutomaton<Stmt, INode<Fact>, W> callAutomaton;
    Set<Summary> summaries = Sets.newHashSet();
    Set<OnAddedSummaryListener> summaryListeners = Sets.newHashSet();
    protected Map<Map.Entry<INode<Fact>, Stmt>, INode<Fact>> generatedCallState = Maps.newHashMap();
    Map<Map.Entry<INode<Node<Stmt, Fact>>, Field>, INode<Node<Stmt, Fact>>> generatedFieldState = Maps.newHashMap();

    protected boolean preventFieldTransitionAdd(Transition<Field, INode<Node<Stmt, Fact>>> trans, W weight) {
        return false;
    }

    protected boolean preventCallTransitionAdd(Transition<Stmt, INode<Fact>> trans, W weight) {
        return false;
    }

    public SyncPDSSolver(final boolean useCallSummaries, NestedWeightedPAutomatons<Stmt, INode<Fact>, W> callSummaries, final boolean useFieldSummaries, NestedWeightedPAutomatons<Field, INode<Node<Stmt, Fact>>, W> fieldSummaries, final int maxCallDepth, final int maxFieldDepth, final int maxUnbalancedCallDepth) {
        this.fieldAutomaton = new WeightedPAutomaton<Field, INode<Node<Stmt, Fact>>, W>(){

            public INode<Node<Stmt, Fact>> createState(INode<Node<Stmt, Fact>> d, Field loc) {
                if (loc.equals(SyncPDSSolver.this.emptyField())) {
                    return d;
                }
                return SyncPDSSolver.this.generateFieldState(d, loc);
            }

            public Field epsilon() {
                return SyncPDSSolver.this.epsilonField();
            }

            public boolean nested() {
                return useFieldSummaries;
            }

            public W getOne() {
                return SyncPDSSolver.this.getFieldWeights().getOne();
            }

            public int getMaxDepth() {
                return maxFieldDepth;
            }

            public boolean addWeightForTransition(Transition<Field, INode<Node<Stmt, Fact>>> trans, W weight) {
                if (SyncPDSSolver.this.preventFieldTransitionAdd(trans, weight)) {
                    return false;
                }
                logger.trace("Adding field transition {} with weight {}", trans, weight);
                return super.addWeightForTransition(trans, weight);
            }

            public boolean isGeneratedState(INode<Node<Stmt, Fact>> d) {
                return d instanceof GeneratedState;
            }
        };
        this.callAutomaton = new WeightedPAutomaton<Stmt, INode<Fact>, W>(){

            public INode<Fact> createState(INode<Fact> d, Stmt loc) {
                return SyncPDSSolver.this.generateCallState(d, loc);
            }

            public Stmt epsilon() {
                return SyncPDSSolver.this.epsilonStmt();
            }

            public boolean nested() {
                return useCallSummaries;
            }

            public W getOne() {
                return SyncPDSSolver.this.getCallWeights().getOne();
            }

            public boolean addWeightForTransition(Transition<Stmt, INode<Fact>> trans, W weight) {
                if (SyncPDSSolver.this.preventCallTransitionAdd(trans, weight)) {
                    return false;
                }
                logger.trace("Adding call transition {} with weight {}", trans, weight);
                return super.addWeightForTransition(trans, weight);
            }

            public boolean isGeneratedState(INode<Fact> d) {
                return d instanceof GeneratedState;
            }

            public int getMaxDepth() {
                return maxCallDepth;
            }

            public int getMaxUnbalancedDepth() {
                return maxUnbalancedCallDepth;
            }
        };
        this.callAutomaton.registerListener((WPAUpdateListener)new CallAutomatonListener());
        this.fieldAutomaton.registerListener((WPAUpdateListener)new FieldUpdateListener());
        if (this.callAutomaton.nested()) {
            this.callAutomaton.registerNestedAutomatonListener((NestedAutomatonListener)new CallSummaryListener());
        }
        this.callingPDS.poststar(this.callAutomaton, callSummaries);
        this.fieldPDS.poststar(this.fieldAutomaton, fieldSummaries);
    }

    public void solve(Node<Stmt, Fact> curr, Field field, INode<Node<Stmt, Fact>> fieldTarget, Stmt stmt, INode<Fact> callTarget, W weight) {
        this.fieldAutomaton.addInitialState(fieldTarget);
        this.callAutomaton.addInitialState(callTarget);
        INode<Node<Stmt, Fact>> start = this.asFieldFact(curr);
        if (!field.equals(this.emptyField())) {
            INode<Node<Stmt, Fact>> generateFieldState = this.generateFieldState(start, field);
            Transition fieldTrans = new Transition(start, field, generateFieldState);
            this.fieldAutomaton.addTransition(fieldTrans);
            Transition fieldTransToInitial = new Transition(generateFieldState, this.emptyField(), fieldTarget);
            this.fieldAutomaton.addTransition(fieldTransToInitial);
        } else {
            Transition fieldTrans = new Transition(start, this.emptyField(), fieldTarget);
            this.fieldAutomaton.addTransition(fieldTrans);
        }
        Transition callTrans = new Transition(this.wrap(curr.fact()), (Location)curr.stmt(), callTarget);
        this.callAutomaton.addWeightForTransition(callTrans, weight);
        this.processNode(curr);
    }

    public void solve(Node<Stmt, Fact> curr, Field field, INode<Node<Stmt, Fact>> fieldTarget, Stmt stmt, INode<Fact> callTarget) {
        this.solve(curr, field, fieldTarget, stmt, callTarget, this.getCallWeights().getOne());
    }

    public void processNode(Node<Stmt, Fact> curr) {
        if (!this.addReachableState(curr)) {
            return;
        }
        this.computeSuccessor(curr);
    }

    public void propagate(Node<Stmt, Fact> curr, State s) {
        if (s instanceof Node) {
            Node succ = (Node)s;
            if (succ instanceof PushNode) {
                PushNode pushNode = (PushNode)succ;
                PDSSystem system = pushNode.system();
                Location location = (Location)pushNode.location();
                this.processPush(curr, location, pushNode, system);
            } else {
                this.processNormal(curr, succ);
            }
        } else if (s instanceof PopNode) {
            PopNode popNode = (PopNode)s;
            this.processPop(curr, popNode);
        }
    }

    private boolean addReachableState(Node<Stmt, Fact> curr) {
        if (this.reachedStates.contains(curr)) {
            return false;
        }
        this.reachedStates.add(curr);
        for (Object l : Lists.newLinkedList(this.updateListeners)) {
            l.onReachableNodeAdded(curr);
        }
        for (Object l : Lists.newLinkedList((Iterable)this.reachedStateUpdateListeners.get(curr))) {
            ((SyncStatePDSUpdateListener)l).reachable();
        }
        return true;
    }

    public void processNormal(Node<Stmt, Fact> curr, Node<Stmt, Fact> succ) {
        this.addNormalFieldFlow(curr, succ);
        this.addNormalCallFlow(curr, succ);
    }

    public void addNormalCallFlow(Node<Stmt, Fact> curr, Node<Stmt, Fact> succ) {
        this.addCallRule((Rule<Stmt, INode<Fact>, W>)new NormalRule(this.wrap(curr.fact()), (Location)curr.stmt(), this.wrap(succ.fact()), (Location)succ.stmt(), this.getCallWeights().normal(curr, succ)));
    }

    public void addNormalFieldFlow(Node<Stmt, Fact> curr, Node<Stmt, Fact> succ) {
        if (succ instanceof ExclusionNode) {
            ExclusionNode exNode = (ExclusionNode)succ;
            this.addFieldRule((Rule<Field, INode<Node<Stmt, Fact>>, W>)new NormalRule(this.asFieldFact(curr), this.fieldWildCard(), this.asFieldFact(succ), this.exclusionFieldWildCard((Location)exNode.exclusion()), this.getFieldWeights().normal(curr, succ)));
            return;
        }
        this.addFieldRule((Rule<Field, INode<Node<Stmt, Fact>>, W>)new NormalRule(this.asFieldFact(curr), this.fieldWildCard(), this.asFieldFact(succ), this.fieldWildCard(), this.getFieldWeights().normal(curr, succ)));
    }

    public INode<Node<Stmt, Fact>> asFieldFact(Node<Stmt, Fact> node) {
        return new SingleNode<Node<Stmt, Fact>>(new Node<Stmt, Fact>(node.stmt(), node.fact()));
    }

    public void processPop(Node<Stmt, Fact> curr, PopNode popNode) {
        PDSSystem system = popNode.system();
        Object location = popNode.location();
        if (system.equals((Object)PDSSystem.FIELDS)) {
            NodeWithLocation node = (NodeWithLocation)location;
            this.addFieldRule((Rule<Field, INode<Node<Stmt, Fact>>, W>)new PopRule(this.asFieldFact(curr), (Location)node.location(), this.asFieldFact((Node<Stmt, Fact>)node.fact()), this.getFieldWeights().pop(curr)));
            this.addNormalCallFlow(curr, (Node<Stmt, Fact>)node.fact());
        } else if (system.equals((Object)PDSSystem.CALLS)) {
            this.addCallRule((Rule<Stmt, INode<Fact>, W>)new PopRule(this.wrap(curr.fact()), (Location)curr.stmt(), this.wrap(location), this.getCallWeights().pop(curr)));
        }
    }

    private void applyCallSummary(Stmt callSite, Fact factInCallee, Stmt spInCallee) {
        this.callAutomaton.addSummaryListener(t -> {
            GeneratedState genSt = (GeneratedState)t.getTarget();
            Location sp = (Location)genSt.location();
            Object v = genSt.node().fact();
            Location exitStmt = t.getLabel();
            Object returnedFact = ((INode)t.getStart()).fact();
            if (spInCallee.equals(sp) && factInCallee.equals(v)) {
                if (this.summaries.add(new Summary(this, (Location)callSite, factInCallee, (Location)spInCallee, exitStmt, returnedFact))) {
                    for (OnAddedSummaryListener s : Lists.newArrayList(this.summaryListeners)) {
                        s.apply(callSite, factInCallee, spInCallee, exitStmt, returnedFact);
                    }
                }
                this.applyCallSummary(callSite, factInCallee, spInCallee, exitStmt, returnedFact);
            }
        });
    }

    public void addApplySummaryListener(OnAddedSummaryListener l) {
        if (this.summaryListeners.add(l)) {
            for (Summary s : Lists.newArrayList(this.summaries)) {
                l.apply(s.callSite, s.factInCallee, s.spInCallee, s.exitStmt, s.returnedFact);
            }
        }
    }

    public abstract void applyCallSummary(Stmt var1, Fact var2, Stmt var3, Stmt var4, Fact var5);

    public void processPush(Node<Stmt, Fact> curr, Location location, PushNode<Stmt, Fact, ?> succ, PDSSystem system) {
        if (system.equals((Object)PDSSystem.FIELDS)) {
            this.addFieldRule((Rule<Field, INode<Node<Stmt, Fact>>, W>)new PushRule(this.asFieldFact(curr), this.fieldWildCard(), this.asFieldFact(succ), location, this.fieldWildCard(), this.getFieldWeights().push(curr, succ, location)));
            this.addNormalCallFlow(curr, succ);
        } else if (system.equals((Object)PDSSystem.CALLS)) {
            this.addNormalFieldFlow(curr, succ);
            this.addCallRule((Rule<Stmt, INode<Fact>, W>)new PushRule(this.wrap(curr.fact()), (Location)curr.stmt(), this.wrap(succ.fact()), (Location)succ.stmt(), location, this.getCallWeights().push(curr, succ, location)));
            this.applyCallSummary(location, succ.fact(), (Location)succ.stmt());
        }
    }

    public void addCallRule(Rule<Stmt, INode<Fact>, W> rule) {
        this.callingPDS.addRule(rule);
    }

    public void addFieldRule(Rule<Field, INode<Node<Stmt, Fact>>, W> rule) {
        this.fieldPDS.addRule(rule);
    }

    public abstract WeightFunctions<Stmt, Fact, Field, W> getFieldWeights();

    public abstract WeightFunctions<Stmt, Fact, Stmt, W> getCallWeights();

    private void setCallingContextReachable(Node<Stmt, Fact> node) {
        if (!this.callingContextReachable.add(node)) {
            return;
        }
        if (this.fieldContextReachable.contains(node)) {
            this.processNode(node);
        }
    }

    private void setFieldContextReachable(Node<Stmt, Fact> node) {
        if (!this.fieldContextReachable.add(node)) {
            return;
        }
        if (this.callingContextReachable.contains(node)) {
            this.processNode(node);
        }
    }

    public void registerListener(SyncPDSUpdateListener<Stmt, Fact> listener) {
        if (!this.updateListeners.add(listener)) {
            return;
        }
        for (Node reachableNode : Lists.newArrayList(this.reachedStates)) {
            listener.onReachableNodeAdded(reachableNode);
        }
    }

    public void registerListener(SyncStatePDSUpdateListener<Stmt, Fact> listener) {
        if (!this.reachedStateUpdateListeners.put(listener.getNode(), listener)) {
            return;
        }
        if (this.reachedStates.contains(listener.getNode())) {
            listener.reachable();
        }
    }

    protected INode<Fact> wrap(Fact variable) {
        return new SingleNode<Fact>(variable);
    }

    public INode<Fact> generateCallState(INode<Fact> d, Stmt loc) {
        AbstractMap.SimpleEntry<INode<Fact>, Stmt> e = new AbstractMap.SimpleEntry<INode<Fact>, Stmt>(d, loc);
        if (!this.generatedCallState.containsKey(e)) {
            this.generatedCallState.put(e, new GeneratedState<Fact, Stmt>(d, loc));
        }
        return this.generatedCallState.get(e);
    }

    public INode<Node<Stmt, Fact>> generateFieldState(INode<Node<Stmt, Fact>> d, Field loc) {
        AbstractMap.SimpleEntry<INode<Node<Stmt, Fact>>, Field> e = new AbstractMap.SimpleEntry<INode<Node<Stmt, Fact>>, Field>(d, loc);
        if (!this.generatedFieldState.containsKey(e)) {
            this.generatedFieldState.put(e, new GeneratedState<Node<Stmt, Fact>, Field>(d, loc));
        }
        return this.generatedFieldState.get(e);
    }

    public void addGeneratedFieldState(GeneratedState<Node<Stmt, Fact>, Field> state) {
        AbstractMap.SimpleEntry<INode<Node<Stmt, Fact>>, Field> e = new AbstractMap.SimpleEntry<INode<Node<Stmt, Fact>>, Field>(state.node(), state.location());
        this.generatedFieldState.put(e, state);
    }

    public abstract void computeSuccessor(Node<Stmt, Fact> var1);

    public abstract Field epsilonField();

    public abstract Field emptyField();

    public abstract Stmt epsilonStmt();

    public abstract Field exclusionFieldWildCard(Field var1);

    public abstract Field fieldWildCard();

    public Set<Node<Stmt, Fact>> getReachedStates() {
        return Sets.newHashSet(this.reachedStates);
    }

    public void debugOutput() {
        logger.debug(this.getClass().toString());
        logger.debug("All reachable states");
        this.prettyPrintSet(this.getReachedStates());
        HashSet notFieldReachable = Sets.newHashSet(this.callingContextReachable);
        notFieldReachable.removeAll(this.getReachedStates());
        HashSet notCallingContextReachable = Sets.newHashSet(this.fieldContextReachable);
        notCallingContextReachable.removeAll(this.getReachedStates());
        if (!notFieldReachable.isEmpty()) {
            logger.debug("Calling context reachable");
            this.prettyPrintSet(notFieldReachable);
        }
        if (!notCallingContextReachable.isEmpty()) {
            logger.debug("Field matching reachable");
            this.prettyPrintSet(notCallingContextReachable);
        }
        logger.debug(this.fieldPDS.toString());
        logger.debug(this.fieldAutomaton.toDotString());
        logger.debug(this.callingPDS.toString());
        logger.debug(this.callAutomaton.toDotString());
        logger.debug("===== end === " + this.getClass());
    }

    private void prettyPrintSet(Collection<? extends Object> set) {
        int j = 0;
        String s = "";
        for (Object object : set) {
            s = s + object;
            s = s + "\t";
            if (j++ <= 5) continue;
            s = s + "\n";
            j = 0;
        }
        logger.debug(s);
    }

    private class FieldUpdateListener
    implements WPAUpdateListener<Field, INode<Node<Stmt, Fact>>, W> {
        private FieldUpdateListener() {
        }

        public void onWeightAdded(Transition<Field, INode<Node<Stmt, Fact>>> t, W w, WeightedPAutomaton<Field, INode<Node<Stmt, Fact>>, W> aut) {
            INode n = (INode)t.getStart();
            if (!(n instanceof GeneratedState) && !t.getLabel().equals(SyncPDSSolver.this.fieldAutomaton.epsilon())) {
                Node fact = (Node)n.fact();
                Node node = new Node(fact.stmt(), fact.fact());
                SyncPDSSolver.this.setFieldContextReachable(node);
            }
        }
    }

    private static class Summary {
        private final Stmt callSite;
        private final Fact factInCallee;
        private final Stmt spInCallee;
        private final Stmt exitStmt;
        private final Fact returnedFact;
        final /* synthetic */ SyncPDSSolver this$0;

        private Summary(Stmt callSite, Fact factInCallee, Stmt spInCallee, Stmt exitStmt, Fact returnedFact) {
            this.this$0 = var1_1;
            this.callSite = callSite;
            this.factInCallee = factInCallee;
            this.spInCallee = spInCallee;
            this.exitStmt = exitStmt;
            this.returnedFact = returnedFact;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Summary summary = (Summary)o;
            return Objects.equal(this.callSite, summary.callSite) && Objects.equal(this.factInCallee, summary.factInCallee) && Objects.equal(this.spInCallee, summary.spInCallee) && Objects.equal(this.exitStmt, summary.exitStmt) && Objects.equal(this.returnedFact, summary.returnedFact);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.callSite, this.factInCallee, this.spInCallee, this.exitStmt, this.returnedFact});
        }
    }

    public static interface OnAddedSummaryListener<Stmt, Fact> {
        public void apply(Stmt var1, Fact var2, Stmt var3, Stmt var4, Fact var5);
    }

    private class CallAutomatonListener
    implements WPAUpdateListener<Stmt, INode<Fact>, W> {
        private CallAutomatonListener() {
        }

        public void onWeightAdded(Transition<Stmt, INode<Fact>> t, W w, WeightedPAutomaton<Stmt, INode<Fact>, W> aut) {
            if (!(t.getStart() instanceof GeneratedState) && !t.getLabel().equals(SyncPDSSolver.this.callAutomaton.epsilon())) {
                Node node = new Node(t.getLabel(), ((INode)t.getStart()).fact());
                SyncPDSSolver.this.setCallingContextReachable(node);
            }
        }
    }

    private class OnOutTransitionAddToStateListener
    extends WPAStateListener<Stmt, INode<Fact>, W> {
        private Transition<Stmt, INode<Fact>> nestedT;

        public OnOutTransitionAddToStateListener(INode<Fact> state, Transition<Stmt, INode<Fact>> nestedT) {
            super(state);
            this.nestedT = nestedT;
        }

        public void onOutTransitionAdded(Transition<Stmt, INode<Fact>> t, W w, WeightedPAutomaton<Stmt, INode<Fact>, W> weightedPAutomaton) {
            Node returningNode = new Node(t.getLabel(), ((INode)this.nestedT.getStart()).fact());
            SyncPDSSolver.this.setCallingContextReachable(returningNode);
        }

        public void onInTransitionAdded(Transition<Stmt, INode<Fact>> t, W w, WeightedPAutomaton<Stmt, INode<Fact>, W> weightedPAutomaton) {
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.nestedT == null ? 0 : this.nestedT.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            OnOutTransitionAddToStateListener other = (OnOutTransitionAddToStateListener)((Object)obj);
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.nestedT == null ? other.nestedT != null : !this.nestedT.equals(other.nestedT));
        }

        private SyncPDSSolver getOuterType() {
            return SyncPDSSolver.this;
        }
    }

    private class AddEpsilonToInitialStateListener
    extends WPAStateListener<Stmt, INode<Fact>, W> {
        private WeightedPAutomaton<Stmt, INode<Fact>, W> parent;

        public AddEpsilonToInitialStateListener(INode<Fact> state, WeightedPAutomaton<Stmt, INode<Fact>, W> parent) {
            super(state);
            this.parent = parent;
        }

        public void onOutTransitionAdded(Transition<Stmt, INode<Fact>> t, W w, WeightedPAutomaton<Stmt, INode<Fact>, W> weightedPAutomaton) {
        }

        public void onInTransitionAdded(Transition<Stmt, INode<Fact>> nestedT, W w, WeightedPAutomaton<Stmt, INode<Fact>, W> weightedPAutomaton) {
            if (nestedT.getLabel().equals(SyncPDSSolver.this.callAutomaton.epsilon())) {
                this.parent.registerListener((WPAStateListener)new OnOutTransitionAddToStateListener((INode)this.getState(), nestedT));
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddEpsilonToInitialStateListener other = (AddEpsilonToInitialStateListener)((Object)obj);
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
        }

        private SyncPDSSolver getOuterType() {
            return SyncPDSSolver.this;
        }
    }

    private class CallSummaryListener
    implements NestedAutomatonListener<Stmt, INode<Fact>, W> {
        private CallSummaryListener() {
        }

        public void nestedAutomaton(WeightedPAutomaton<Stmt, INode<Fact>, W> parent, WeightedPAutomaton<Stmt, INode<Fact>, W> child) {
            for (INode s : child.getInitialStates()) {
                child.registerListener((WPAStateListener)new AddEpsilonToInitialStateListener(s, parent));
            }
        }
    }

    private class FieldOnOutTransitionAddToStateListener
    extends WPAStateListener<Field, INode<Node<Stmt, Fact>>, W> {
        private Transition<Field, INode<Node<Stmt, Fact>>> nestedT;

        public FieldOnOutTransitionAddToStateListener(INode<Node<Stmt, Fact>> state, Transition<Field, INode<Node<Stmt, Fact>>> nestedT) {
            super(state);
            this.nestedT = nestedT;
        }

        public void onOutTransitionAdded(Transition<Field, INode<Node<Stmt, Fact>>> t, W w, WeightedPAutomaton<Field, INode<Node<Stmt, Fact>>, W> weightedPAutomaton) {
            SyncPDSSolver.this.setFieldContextReachable((Node)((INode)this.nestedT.getStart()).fact());
        }

        public void onInTransitionAdded(Transition<Field, INode<Node<Stmt, Fact>>> t, W w, WeightedPAutomaton<Field, INode<Node<Stmt, Fact>>, W> weightedPAutomaton) {
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.nestedT == null ? 0 : this.nestedT.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            FieldOnOutTransitionAddToStateListener other = (FieldOnOutTransitionAddToStateListener)((Object)obj);
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.nestedT == null ? other.nestedT != null : !this.nestedT.equals(other.nestedT));
        }

        private SyncPDSSolver getOuterType() {
            return SyncPDSSolver.this;
        }
    }

    private class FieldAddEpsilonToInitialStateListener
    extends WPAStateListener<Field, INode<Node<Stmt, Fact>>, W> {
        private WeightedPAutomaton<Field, INode<Node<Stmt, Fact>>, W> parent;

        public FieldAddEpsilonToInitialStateListener(INode<Node<Stmt, Fact>> state, WeightedPAutomaton<Field, INode<Node<Stmt, Fact>>, W> parent) {
            super(state);
            this.parent = parent;
        }

        public void onOutTransitionAdded(Transition<Field, INode<Node<Stmt, Fact>>> t, W w, WeightedPAutomaton<Field, INode<Node<Stmt, Fact>>, W> weightedPAutomaton) {
        }

        public void onInTransitionAdded(Transition<Field, INode<Node<Stmt, Fact>>> nestedT, W w, WeightedPAutomaton<Field, INode<Node<Stmt, Fact>>, W> weightedPAutomaton) {
            if (nestedT.getLabel().equals(SyncPDSSolver.this.fieldAutomaton.epsilon())) {
                this.parent.registerListener((WPAStateListener)new FieldOnOutTransitionAddToStateListener((INode)this.getState(), nestedT));
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            FieldAddEpsilonToInitialStateListener other = (FieldAddEpsilonToInitialStateListener)((Object)obj);
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
        }

        private SyncPDSSolver getOuterType() {
            return SyncPDSSolver.this;
        }
    }

    private class FieldSummaryListener
    implements NestedAutomatonListener<Field, INode<Node<Stmt, Fact>>, W> {
        private FieldSummaryListener() {
        }

        public void nestedAutomaton(WeightedPAutomaton<Field, INode<Node<Stmt, Fact>>, W> parent, WeightedPAutomaton<Field, INode<Node<Stmt, Fact>>, W> child) {
            for (INode s : child.getInitialStates()) {
                child.registerListener((WPAStateListener)new FieldAddEpsilonToInitialStateListener(s, parent));
            }
        }
    }

    public static enum PDSSystem {
        FIELDS,
        CALLS;

    }
}

