/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.std.NullSerializer;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySerializer
extends JsonSerializer<Entity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntitySerializer.class);

    public void serialize(Entity entity, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
        gen.writeStartObject();
        SerializationConfig config = serializers.getConfig();
        BeanDescription beanDesc = config.introspect(serializers.constructType(entity.getClass()));
        List properties = beanDesc.findProperties();
        for (BeanPropertyDefinition property : properties) {
            AnnotatedMember accessor = property.getAccessor();
            if (accessor == null) continue;
            Object rawValue = accessor.getValue((Object)entity);
            if (rawValue instanceof Entity) {
                Entity subEntity = (Entity)rawValue;
                if (subEntity.getId() != null) {
                    gen.writeFieldName(rawValue.getClass().getSimpleName());
                    gen.writeStartObject();
                    gen.writeFieldName("@iot.id");
                    ((Entity)rawValue).getId().writeTo(gen);
                    gen.writeEndObject();
                    continue;
                }
                gen.writeFieldName(rawValue.getClass().getSimpleName());
                this.serialize(subEntity, gen, serializers);
                continue;
            }
            if (rawValue instanceof EntityList) {
                EntityList entityList = (EntityList)rawValue;
                if (entityList.isEmpty()) continue;
                gen.writeFieldName(entityList.getType().getName());
                gen.writeStartArray();
                for (Object sub : entityList) {
                    if (!(sub instanceof Entity)) continue;
                    Entity subEntity = (Entity)sub;
                    if (subEntity.getId() == null) {
                        this.serialize(subEntity, gen, serializers);
                        continue;
                    }
                    gen.writeStartObject();
                    gen.writeFieldName("@iot.id");
                    subEntity.getId().writeTo(gen);
                    gen.writeEndObject();
                }
                gen.writeEndArray();
                continue;
            }
            JsonSerialize annotation = (JsonSerialize)property.getAccessor().getAnnotation(JsonSerialize.class);
            JsonSerializer serializer = null;
            if (annotation != null) {
                try {
                    Class using = annotation.using();
                    serializer = (JsonSerializer)using.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                    LOGGER.warn("Could not instantiate serialiser specified in annotation.", (Throwable)ex);
                }
            }
            boolean suppressNulls = true;
            JsonInclude includeAnnotation = (JsonInclude)property.getAccessor().getAnnotation(JsonInclude.class);
            if (rawValue == null && includeAnnotation != null && includeAnnotation.value() == JsonInclude.Include.ALWAYS) {
                suppressNulls = false;
            }
            TypeSerializer typeSerializer = serializers.findTypeSerializer(serializers.constructType((Type)property.getAccessor().getRawType()));
            BeanPropertyWriter writer = new BeanPropertyWriter(property, property.getAccessor(), beanDesc.getClassAnnotations(), property.getAccessor().getType(), serializer, typeSerializer, property.getAccessor().getType(), suppressNulls, null, null);
            if (!suppressNulls && rawValue == null) {
                writer.assignNullSerializer((JsonSerializer)NullSerializer.instance);
            }
            try {
                writer.serializeAsField((Object)entity, gen, serializers);
            }
            catch (Exception e) {
                LOGGER.error("Failed to serialize entity.", (Throwable)e);
            }
        }
        gen.writeEndObject();
    }
}

