/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.sta.dao.ActuatorDao;
import de.fraunhofer.iosb.ilt.sta.dao.BaseDao;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.EntityType;
import de.fraunhofer.iosb.ilt.sta.model.TaskingCapability;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Actuator
extends Entity<Actuator> {
    private String name;
    private String description;
    private String encodingType;
    private Object metadata;
    private Map<String, Object> properties;
    private final EntityList<TaskingCapability> taskingCapabilities = new EntityList(EntityType.TASKING_CAPABILITIES);

    public Actuator() {
        super(EntityType.ACTUATOR);
    }

    public Actuator(String name, String description, String encodingType, Object metadata) {
        this();
        this.name = name;
        this.description = description;
        this.encodingType = encodingType;
        this.metadata = metadata;
    }

    @Override
    protected void ensureServiceOnChildren(SensorThingsService service) {
        this.taskingCapabilities.setService(service, TaskingCapability.class);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Actuator other = (Actuator)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (!Objects.equals(this.encodingType, other.encodingType)) {
            return false;
        }
        if (!Objects.equals(this.metadata, other.metadata)) {
            return false;
        }
        if (!Objects.equals(this.properties, other.properties)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 59 * hash + Objects.hashCode(this.name);
        hash = 59 * hash + Objects.hashCode(this.description);
        hash = 59 * hash + Objects.hashCode(this.encodingType);
        hash = 59 * hash + Objects.hashCode(this.metadata);
        hash = 59 * hash + Objects.hashCode(this.properties);
        return hash;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public BaseDao<TaskingCapability> taskingCapabilities() {
        return this.getService().taskingCapabilities().setParent(this);
    }

    @JsonProperty(value="TaskingCapabilities")
    public EntityList<TaskingCapability> getTaskingCapabilities() {
        return this.taskingCapabilities;
    }

    @JsonProperty(value="TaskingCapabilities")
    public void setTaskingCapabilities(List<TaskingCapability> taskingCapabilities) {
        this.taskingCapabilities.replaceAll(taskingCapabilities);
    }

    @Override
    public BaseDao<Actuator> getDao(SensorThingsService service) {
        return new ActuatorDao(service);
    }

    @Override
    public Actuator withOnlyId() {
        Actuator copy = new Actuator();
        copy.setId(this.id);
        return copy;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.getName();
    }
}

