/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.model;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.sta.MqttException;
import de.fraunhofer.iosb.ilt.sta.dao.BaseDao;
import de.fraunhofer.iosb.ilt.sta.model.EntityType;
import de.fraunhofer.iosb.ilt.sta.model.Id;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import de.fraunhofer.iosb.ilt.sta.service.MqttSubscription;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jodah.typetools.TypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class Entity<T extends Entity<T>> {
    public static final String IOT_COUNT = "iot.count";
    public static final String AT_IOT_COUNT = "@iot.count";
    public static final String IOT_NAVIGATION_LINK = "iot.navigationLink";
    public static final String AT_IOT_NAVIGATION_LINK = "@iot.navigationLink";
    public static final String IOT_NEXT_LINK = "iot.nextLink";
    public static final String AT_IOT_NEXT_LINK = "@iot.nextLink";
    public static final String IOT_SELF_LINK = "iot.selfLink";
    public static final String AT_IOT_SELF_LINK = "@iot.selfLink";
    private static final Logger LOGGER = LoggerFactory.getLogger(Entity.class);
    @JsonProperty(value="@iot.id")
    protected Id id;
    @JsonIgnore
    protected URI selfLink;
    @JsonIgnore
    private final EntityType type;
    @JsonIgnore
    private SensorThingsService service;

    public Entity(EntityType type) {
        this.type = type;
    }

    public Entity(EntityType type, Id id) {
        this.type = type;
        this.id = id;
    }

    @JsonAnySetter
    public void handleNamespacedProperties(String name, Object value) {
        String[] split = name.split("@", 2);
        if (split.length < 2) {
            LOGGER.info("Ignoring unknown property {}.", (Object)name);
            return;
        }
        if (IOT_SELF_LINK.equals(split[1])) {
            this.setSelfLink(value.toString());
            return;
        }
        EntityType entityType = EntityType.byName(split[0]);
        if (entityType == null) {
            LOGGER.info("Unknown entity type '{}' for property '{}'", (Object)entityType, (Object)name);
            return;
        }
        try {
            Method method = this.getClass().getMethod("get" + entityType.getName(), null);
            Object linkedEntity = method.invoke((Object)this, (Object[])null);
            if (linkedEntity instanceof EntityList) {
                EntityList entityList = (EntityList)linkedEntity;
                switch (split[1]) {
                    case "iot.count": {
                        if (value instanceof Number) {
                            entityList.setCount(((Number)value).longValue());
                            break;
                        }
                        LOGGER.error("{} should have numeric value, not {}", (Object)name, value);
                        break;
                    }
                    case "iot.nextLink": {
                        entityList.setNextLink(URI.create(value.toString()));
                        break;
                    }
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            LOGGER.info("Unknown entity type '{}' for property '{}'", (Object)entityType, (Object)name);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Entity other = (Entity)obj;
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        return this.type == other.type;
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + Objects.hashCode(this.id);
        hash = 13 * hash + Objects.hashCode((Object)this.type);
        return hash;
    }

    public EntityType getType() {
        return this.type;
    }

    public Id getId() {
        return this.id;
    }

    public void setId(Id id) {
        this.id = id;
    }

    @JsonIgnore
    public URI getSelfLink() {
        return this.selfLink;
    }

    @JsonProperty
    public void setSelfLink(String selfLink) {
        try {
            this.selfLink = URI.create(selfLink);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Invalid selflink: {}", (Object)selfLink);
        }
    }

    public void setSelfLink(URI selfLink) {
        this.selfLink = selfLink;
    }

    public void setService(SensorThingsService service) {
        if (this.service != service) {
            this.service = service;
            this.ensureServiceOnChildren(service);
        }
    }

    protected abstract void ensureServiceOnChildren(SensorThingsService var1);

    public SensorThingsService getService() {
        return this.service;
    }

    public abstract BaseDao<T> getDao(SensorThingsService var1);

    public abstract T withOnlyId();

    public String toString() {
        if (this.id == null) {
            return "no id";
        }
        return this.id.toString();
    }

    public MqttSubscription subscribe(Consumer<T> handler) throws MqttException {
        return this.getDao(this.getService()).subscribe(this, handler);
    }

    public <U> MqttSubscription subscribeRelative(Consumer<U> handler, EntityType ... path) throws MqttException {
        if (path != null && path.length > 0) {
            EntityType current = this.type;
            for (EntityType entityType : path) {
                if (!current.hasRelationTo(entityType)) {
                    throw new MqttException("invalid relative subscription path. EntityType " + current.getName() + " has no relation to " + entityType.getName());
                }
                current = entityType;
            }
        }
        EntityType resultType = this.getType();
        Class handlerType = TypeResolver.resolveRawArgument(Consumer.class, handler.getClass());
        String topic = this.getService().getVersion().getUrlPattern() + "/" + this.getType().getPlural().getName() + "(" + this.getId() + ")/";
        if (path != null && path.length > 0) {
            topic = topic + Stream.of(path).map(x -> x.getName()).collect(Collectors.joining("/"));
            resultType = path[path.length - 1];
        }
        if (!handlerType.isAssignableFrom(resultType.getType())) {
            throw new MqttException(String.format("Could not subscribe. Reason: type of provided message handler (%s) does not match expected result type (%s)", handlerType, resultType.getType()));
        }
        return this.getService().subscribe(topic, handler, resultType.getType(), null);
    }
}

