/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.model;

import com.fasterxml.jackson.core.type.TypeReference;
import de.fraunhofer.iosb.ilt.sta.model.Actuator;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.EntityProperty;
import de.fraunhofer.iosb.ilt.sta.model.FeatureOfInterest;
import de.fraunhofer.iosb.ilt.sta.model.HistoricalLocation;
import de.fraunhofer.iosb.ilt.sta.model.Location;
import de.fraunhofer.iosb.ilt.sta.model.MultiDatastream;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.ObservedProperty;
import de.fraunhofer.iosb.ilt.sta.model.Sensor;
import de.fraunhofer.iosb.ilt.sta.model.Task;
import de.fraunhofer.iosb.ilt.sta.model.TaskingCapability;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum EntityType {
    DATASTREAM(Datastream.class, (TypeReference)new TypeReference<Datastream>(){}, "Datastream", false),
    DATASTREAMS(Datastream.class, (TypeReference)new TypeReference<EntityList<Datastream>>(){}, "Datastreams", true),
    MULTIDATASTREAM(MultiDatastream.class, (TypeReference)new TypeReference<MultiDatastream>(){}, "MultiDatastream", false),
    MULTIDATASTREAMS(MultiDatastream.class, (TypeReference)new TypeReference<EntityList<MultiDatastream>>(){}, "MultiDatastreams", true),
    FEATURE_OF_INTEREST(FeatureOfInterest.class, (TypeReference)new TypeReference<FeatureOfInterest>(){}, "FeatureOfInterest", false),
    FEATURES_OF_INTEREST(FeatureOfInterest.class, (TypeReference)new TypeReference<EntityList<FeatureOfInterest>>(){}, "FeaturesOfInterest", true),
    HISTORICAL_LOCATION(HistoricalLocation.class, (TypeReference)new TypeReference<HistoricalLocation>(){}, "HistoricalLocation", false),
    HISTORICAL_LOCATIONS(HistoricalLocation.class, (TypeReference)new TypeReference<EntityList<HistoricalLocation>>(){}, "HistoricalLocations", true),
    LOCATION(Location.class, (TypeReference)new TypeReference<Location>(){}, "Location", false),
    LOCATIONS(Location.class, (TypeReference)new TypeReference<EntityList<Location>>(){}, "Locations", true),
    OBSERVATION(Observation.class, (TypeReference)new TypeReference<Observation>(){}, "Observation", false),
    OBSERVATIONS(Observation.class, (TypeReference)new TypeReference<EntityList<Observation>>(){}, "Observations", true),
    OBSERVED_PROPERTY(ObservedProperty.class, (TypeReference)new TypeReference<ObservedProperty>(){}, "ObservedProperty", false),
    OBSERVED_PROPERTIES(ObservedProperty.class, (TypeReference)new TypeReference<EntityList<ObservedProperty>>(){}, "ObservedProperties", true),
    SENSOR(Sensor.class, (TypeReference)new TypeReference<Sensor>(){}, "Sensor", false),
    SENSORS(Sensor.class, (TypeReference)new TypeReference<EntityList<Sensor>>(){}, "Sensors", true),
    THING(Thing.class, (TypeReference)new TypeReference<Thing>(){}, "Thing", false),
    THINGS(Thing.class, (TypeReference)new TypeReference<EntityList<Thing>>(){}, "Things", true),
    ACTUATOR(Actuator.class, (TypeReference)new TypeReference<Actuator>(){}, "Actuator", false),
    ACTUATORS(Actuator.class, (TypeReference)new TypeReference<EntityList<Actuator>>(){}, "Actuators", true),
    TASKING_CAPABILITY(TaskingCapability.class, (TypeReference)new TypeReference<TaskingCapability>(){}, "TaskingCapability", false),
    TASKING_CAPABILITIES(TaskingCapability.class, (TypeReference)new TypeReference<EntityList<TaskingCapability>>(){}, "TaskingCapabilities", true),
    TASK(Task.class, (TypeReference)new TypeReference<Task>(){}, "Task", false),
    TASKS(Task.class, (TypeReference)new TypeReference<EntityList<Task>>(){}, "Tasks", true);

    private final Class<? extends Entity> type;
    private final TypeReference<EntityList> typeReference;
    private final String name;
    private final Set<EntityType> relations;
    private final Set<EntityProperty> properties;
    private final boolean isList;
    private EntityType other;
    private static final Map<Class<? extends Entity>, EntityType> listForClass;
    private static final Map<Class<? extends Entity>, EntityType> singleForClass;

    public Set<EntityProperty> getProperties() {
        return this.properties;
    }

    private EntityType(Class<? extends Entity> type, TypeReference typeReference, String name, boolean isList) {
        this.type = type;
        this.typeReference = typeReference;
        this.name = name;
        this.isList = isList;
        this.relations = new HashSet<EntityType>();
        this.properties = new HashSet<EntityProperty>();
    }

    private void addRelations(EntityType ... relations) {
        this.relations.addAll(Arrays.asList(relations));
    }

    private void addProperties(EntityProperty ... properties) {
        this.getProperties().addAll(Arrays.asList(properties));
    }

    public Class<? extends Entity> getType() {
        return this.type;
    }

    public TypeReference<EntityList> getTypeReference() {
        return this.typeReference;
    }

    public String getName() {
        return this.name;
    }

    public boolean isList() {
        return this.isList;
    }

    private void setOther(EntityType other) {
        this.other = other;
    }

    public EntityType getPlural() {
        if (this.isList) {
            return this;
        }
        return this.other;
    }

    public EntityType getSingular() {
        if (!this.isList) {
            return this;
        }
        return this.other;
    }

    public boolean hasRelationTo(EntityType other) {
        return this.relations.contains((Object)other);
    }

    public boolean hasProperty(EntityProperty property) {
        return this.getProperties().contains((Object)property);
    }

    public static EntityType listForClass(Class<? extends Entity> clazz) {
        return listForClass.get(clazz);
    }

    public static EntityType singleForClass(Class<? extends Entity> clazz) {
        return singleForClass.get(clazz);
    }

    public static EntityType byName(String name) {
        switch (name) {
            case "Datastream": {
                return DATASTREAM;
            }
            case "Datastreams": {
                return DATASTREAMS;
            }
            case "FeatureOfInterest": {
                return FEATURE_OF_INTEREST;
            }
            case "FeaturesOfInterest": {
                return FEATURES_OF_INTEREST;
            }
            case "HistoricalLocation": {
                return HISTORICAL_LOCATION;
            }
            case "HistoricalLocations": {
                return HISTORICAL_LOCATIONS;
            }
            case "Location": {
                return LOCATION;
            }
            case "Locations": {
                return LOCATIONS;
            }
            case "MultiDatastream": {
                return MULTIDATASTREAM;
            }
            case "MultiDatastreams": {
                return MULTIDATASTREAMS;
            }
            case "Observation": {
                return OBSERVATION;
            }
            case "Observations": {
                return OBSERVATIONS;
            }
            case "ObservedProperty": {
                return OBSERVED_PROPERTY;
            }
            case "ObservedProperties": {
                return OBSERVED_PROPERTIES;
            }
            case "Sensor": {
                return SENSOR;
            }
            case "Sensors": {
                return SENSORS;
            }
            case "Thing": {
                return THING;
            }
            case "Things": {
                return THINGS;
            }
            case "Actuator": {
                return ACTUATOR;
            }
            case "Actuators": {
                return ACTUATORS;
            }
            case "Task": {
                return TASK;
            }
            case "Tasks": {
                return TASKS;
            }
            case "TaskingCapability": {
                return TASKING_CAPABILITY;
            }
            case "TaskingCapabilities": {
                return TASKING_CAPABILITIES;
            }
        }
        return null;
    }

    static {
        listForClass = new HashMap<Class<? extends Entity>, EntityType>();
        singleForClass = new HashMap<Class<? extends Entity>, EntityType>();
        DATASTREAM.setOther(DATASTREAMS);
        DATASTREAMS.setOther(DATASTREAM);
        MULTIDATASTREAM.setOther(MULTIDATASTREAMS);
        MULTIDATASTREAMS.setOther(MULTIDATASTREAM);
        FEATURE_OF_INTEREST.setOther(FEATURES_OF_INTEREST);
        FEATURES_OF_INTEREST.setOther(FEATURE_OF_INTEREST);
        HISTORICAL_LOCATION.setOther(HISTORICAL_LOCATIONS);
        HISTORICAL_LOCATIONS.setOther(HISTORICAL_LOCATION);
        LOCATION.setOther(LOCATIONS);
        LOCATIONS.setOther(LOCATION);
        OBSERVATION.setOther(OBSERVATIONS);
        OBSERVATIONS.setOther(OBSERVATION);
        OBSERVED_PROPERTY.setOther(OBSERVED_PROPERTIES);
        OBSERVED_PROPERTIES.setOther(OBSERVED_PROPERTY);
        SENSOR.setOther(SENSORS);
        SENSORS.setOther(SENSOR);
        THING.setOther(THINGS);
        THINGS.setOther(THING);
        ACTUATOR.setOther(ACTUATORS);
        ACTUATORS.setOther(ACTUATOR);
        TASKING_CAPABILITY.setOther(TASKING_CAPABILITIES);
        TASKING_CAPABILITIES.setOther(TASKING_CAPABILITY);
        TASK.setOther(TASKS);
        TASKS.setOther(TASK);
        DATASTREAM.addRelations(SENSOR, THING, OBSERVED_PROPERTY, OBSERVATIONS);
        DATASTREAMS.addRelations(SENSOR, THING, OBSERVED_PROPERTY, OBSERVATIONS);
        MULTIDATASTREAM.addRelations(SENSOR, THING, OBSERVED_PROPERTIES, OBSERVATIONS);
        MULTIDATASTREAMS.addRelations(SENSOR, THING, OBSERVED_PROPERTIES, OBSERVATIONS);
        FEATURE_OF_INTEREST.addRelations(OBSERVATIONS);
        FEATURES_OF_INTEREST.addRelations(OBSERVATIONS);
        HISTORICAL_LOCATION.addRelations(THING, LOCATIONS);
        HISTORICAL_LOCATIONS.addRelations(THING, LOCATIONS);
        LOCATION.addRelations(THINGS, HISTORICAL_LOCATIONS);
        LOCATIONS.addRelations(THINGS, HISTORICAL_LOCATIONS);
        OBSERVATION.addRelations(FEATURE_OF_INTEREST, DATASTREAM, MULTIDATASTREAM);
        OBSERVATIONS.addRelations(FEATURE_OF_INTEREST, DATASTREAM, MULTIDATASTREAM);
        OBSERVED_PROPERTY.addRelations(DATASTREAMS, MULTIDATASTREAMS);
        OBSERVED_PROPERTIES.addRelations(DATASTREAMS, MULTIDATASTREAMS);
        SENSOR.addRelations(DATASTREAMS, MULTIDATASTREAMS);
        SENSORS.addRelations(DATASTREAMS, MULTIDATASTREAMS);
        THING.addRelations(DATASTREAMS, MULTIDATASTREAMS, LOCATIONS, HISTORICAL_LOCATIONS, TASKING_CAPABILITIES);
        THINGS.addRelations(DATASTREAMS, MULTIDATASTREAMS, LOCATIONS, HISTORICAL_LOCATIONS, TASKING_CAPABILITIES);
        ACTUATOR.addRelations(TASKING_CAPABILITIES);
        ACTUATORS.addRelations(TASKING_CAPABILITIES);
        TASKING_CAPABILITY.addRelations(ACTUATOR, TASKS, THING);
        TASKING_CAPABILITIES.addRelations(ACTUATOR, TASKS, THING);
        TASK.addRelations(TASKING_CAPABILITY);
        TASKS.addRelations(TASKING_CAPABILITY);
        ACTUATOR.addProperties(EntityProperty.ID, EntityProperty.PROPERTIES, EntityProperty.NAME, EntityProperty.DESCRIPTION, EntityProperty.ENCODINGTYPE, EntityProperty.METADATA);
        DATASTREAM.addProperties(EntityProperty.ID, EntityProperty.PROPERTIES, EntityProperty.NAME, EntityProperty.DESCRIPTION, EntityProperty.OBSERVATIONTYPE, EntityProperty.UNITOFMEASUREMENT, EntityProperty.OBSERVEDAREA, EntityProperty.PHENOMENONTIME, EntityProperty.RESULTTIME);
        FEATURE_OF_INTEREST.addProperties(EntityProperty.ID, EntityProperty.NAME, EntityProperty.DESCRIPTION, EntityProperty.ENCODINGTYPE, EntityProperty.FEATURE);
        HISTORICAL_LOCATION.addProperties(EntityProperty.ID, EntityProperty.TIME);
        LOCATION.addProperties(EntityProperty.ID, EntityProperty.PROPERTIES, EntityProperty.NAME, EntityProperty.DESCRIPTION, EntityProperty.ENCODINGTYPE, EntityProperty.LOCATION);
        MULTIDATASTREAM.addProperties(EntityProperty.ID, EntityProperty.PROPERTIES, EntityProperty.NAME, EntityProperty.DESCRIPTION, EntityProperty.OBSERVATIONTYPE, EntityProperty.MULTIOBSERVATIONDATATYPES, EntityProperty.UNITOFMEASUREMENTS, EntityProperty.OBSERVEDAREA, EntityProperty.PHENOMENONTIME, EntityProperty.RESULTTIME);
        OBSERVATION.addProperties(EntityProperty.ID, EntityProperty.PHENOMENONTIME, EntityProperty.RESULTTIME, EntityProperty.RESULT, EntityProperty.RESULTQUALITY, EntityProperty.VALIDTIME, EntityProperty.PARAMETERS);
        OBSERVED_PROPERTY.addProperties(EntityProperty.ID, EntityProperty.PROPERTIES, EntityProperty.NAME, EntityProperty.DESCRIPTION, EntityProperty.DEFINITION);
        SENSOR.addProperties(EntityProperty.ID, EntityProperty.PROPERTIES, EntityProperty.NAME, EntityProperty.DESCRIPTION, EntityProperty.ENCODINGTYPE, EntityProperty.METADATA);
        TASK.addProperties(EntityProperty.ID, EntityProperty.CREATIONTIME, EntityProperty.TASKINGPARAMETERS);
        TASKING_CAPABILITY.addProperties(EntityProperty.ID, EntityProperty.PROPERTIES, EntityProperty.NAME, EntityProperty.DESCRIPTION, EntityProperty.TASKINGPARAMETERS);
        THING.addProperties(EntityProperty.ID, EntityProperty.PROPERTIES, EntityProperty.NAME, EntityProperty.DESCRIPTION);
        for (EntityType type : EntityType.values()) {
            if (type.isList) {
                listForClass.put(type.type, type);
                continue;
            }
            singleForClass.put(type.type, type);
        }
    }
}

