/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.service;

import java.util.Optional;
import java.util.stream.Stream;

public enum SensorThingsAPIVersion {
    v1_0(1, 0),
    V1_1(1, 1);

    private final int major;
    private final int minor;

    public static SensorThingsAPIVersion fromString(String value) {
        Optional<SensorThingsAPIVersion> result = Stream.of(SensorThingsAPIVersion.values()).filter(x -> x.getUrlPattern().equals(value)).findFirst();
        if (result.isPresent()) {
            return result.get();
        }
        return null;
    }

    private SensorThingsAPIVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public String getUrlPattern() {
        return String.format("v%d.%d", this.getMajor(), this.getMinor());
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }
}

