/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.dao;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.fraunhofer.iosb.ilt.sta.MqttException;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.Utils;
import de.fraunhofer.iosb.ilt.sta.dao.BaseDao;
import de.fraunhofer.iosb.ilt.sta.jackson.ObjectMapperFactory;
import de.fraunhofer.iosb.ilt.sta.model.Id;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.ext.DataArrayDocument;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservationDao
extends BaseDao<Observation> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObservationDao.class);
    public static final TypeReference<List<String>> LIST_OF_STRING = new TypeReference<List<String>>(){};

    public ObservationDao(SensorThingsService service) {
        super(service, Observation.class);
    }

    @Override
    public void create(Observation entity) throws ServiceFailureException {
        if (!entity.isResultSet()) {
            throw new IllegalArgumentException("Result must be set on Observation.");
        }
        super.create(entity);
    }

    public void createMqtt(Observation entity) throws MqttException {
        if (!entity.isResultSet()) {
            throw new IllegalArgumentException("Result must be set on Observation.");
        }
        this.getService().publish(this.getMqttTopic(), entity);
    }

    public List<String> create(DataArrayDocument dataArray) throws ServiceFailureException {
        HttpPost httpPost;
        String json;
        List<String> result = new ArrayList();
        ObjectMapper mapper = ObjectMapperFactory.get();
        try {
            json = mapper.writeValueAsString(dataArray.getValue());
            URIBuilder uriBuilder = new URIBuilder(this.getService().getEndpoint() + "CreateObservations");
            httpPost = new HttpPost(uriBuilder.build());
        }
        catch (JsonProcessingException | URISyntaxException ex) {
            throw new ServiceFailureException("Failed to create Observations.", ex);
        }
        LOGGER.debug("Posting to: {}", (Object)httpPost.getURI());
        httpPost.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        try (CloseableHttpResponse response = this.getService().execute((HttpRequestBase)httpPost);){
            Utils.throwIfNotOk((HttpRequestBase)httpPost, response);
            String jsonResponse = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
            result = (List)mapper.readValue(jsonResponse, LIST_OF_STRING);
            List<Observation> observations = dataArray.getObservations();
            if (observations.size() != result.size()) {
                LOGGER.error("Size of returned location list ({}) is not equal to number of sent Observations ({})!", (Object)result.size(), (Object)observations.size());
            }
            int i = 0;
            for (Observation o : observations) {
                String newLocation = result.get(i);
                if (newLocation.startsWith("error")) {
                    LOGGER.warn("Failed to insert Observation. Error: {}.", (Object)newLocation);
                } else {
                    int pos1 = newLocation.indexOf(40) + 1;
                    int pos2 = newLocation.indexOf(41, pos1);
                    String stringId = newLocation.substring(pos1, pos2);
                    o.setId(Id.tryToParse(stringId));
                    o.setService(this.getService());
                }
                ++i;
            }
        }
        catch (IOException exc) {
            throw new ServiceFailureException("Failed to create Observations.", exc);
        }
        return result;
    }
}

