/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.EntityType;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityListDeserializer<T extends Entity<T>>
extends StdDeserializer<EntityList<T>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 8376494553925868647L;
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityListDeserializer.class);
    private Class<T> type;

    public EntityListDeserializer() {
        super(EntityList.class);
    }

    public EntityListDeserializer(Class<T> type) {
        super(EntityList.class);
        this.type = type;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JavaType wrapperType = property == null ? ctxt.getContextualType() : property.getType();
        JavaType valueType = wrapperType.containedType(0);
        return new EntityListDeserializer<T>(valueType.getRawClass());
    }

    public EntityList<T> deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        EntityList<Entity> entities;
        block21: {
            block20: {
                entities = new EntityList<Entity>(EntityType.listForClass(this.type));
                JsonToken currentToken = parser.getCurrentToken();
                if (currentToken != JsonToken.START_ARRAY) break block20;
                JsonToken nextToken = parser.nextToken();
                if (nextToken == JsonToken.END_ARRAY) break block21;
                Iterator readValuesAs = parser.readValuesAs(this.type);
                while (readValuesAs.hasNext()) {
                    Entity next = (Entity)readValuesAs.next();
                    entities.add(next);
                }
                break block21;
            }
            boolean done = false;
            block17: while (!done) {
                JsonToken mainToken = parser.nextToken();
                switch (mainToken) {
                    case END_OBJECT: {
                        done = true;
                        continue block17;
                    }
                    case FIELD_NAME: {
                        String fieldName = parser.getCurrentName();
                        JsonToken valueToken = parser.nextToken();
                        switch (fieldName) {
                            case "@iot.count": {
                                entities.setCount(parser.getValueAsLong());
                                break;
                            }
                            case "@iot.nextLink": {
                                try {
                                    entities.setNextLink(URI.create(parser.getValueAsString()));
                                }
                                catch (IllegalArgumentException e) {
                                    LOGGER.warn("@iot.nextLink field contains malformed URI", (Throwable)e);
                                }
                                break;
                            }
                            case "value": {
                                if (valueToken == JsonToken.START_ARRAY) {
                                    JsonToken nextToken = parser.nextToken();
                                    if (nextToken == JsonToken.END_ARRAY) break;
                                    Iterator values = parser.readValuesAs(this.type);
                                    while (values.hasNext()) {
                                        Entity value = (Entity)values.next();
                                        entities.add(value);
                                    }
                                    continue block17;
                                }
                                LOGGER.warn("value field is not an array!");
                            }
                        }
                        continue block17;
                    }
                }
                LOGGER.warn("Unhandled token: {}", (Object)mainToken);
            }
        }
        return entities;
    }
}

