/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.dao.BaseDao;
import de.fraunhofer.iosb.ilt.sta.dao.DatastreamDao;
import de.fraunhofer.iosb.ilt.sta.dao.ObservationDao;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.EntityType;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.ObservedProperty;
import de.fraunhofer.iosb.ilt.sta.model.Sensor;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import de.fraunhofer.iosb.ilt.sta.model.ext.UnitOfMeasurement;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.geojson.GeoJsonObject;
import org.threeten.extra.Interval;

public class Datastream
extends Entity<Datastream> {
    private String name;
    private String description;
    private String observationType;
    private UnitOfMeasurement unitOfMeasurement;
    private GeoJsonObject observedArea;
    private Interval phenomenonTime;
    private Map<String, Object> properties;
    private Interval resultTime;
    @JsonProperty(value="Thing")
    private Thing thing;
    @JsonProperty(value="Sensor")
    private Sensor sensor;
    @JsonProperty(value="ObservedProperty")
    private ObservedProperty observedProperty;
    private final EntityList<Observation> observations = new EntityList(EntityType.OBSERVATIONS);

    public Datastream() {
        super(EntityType.DATASTREAM);
    }

    public Datastream(String name, String description, String observationType, UnitOfMeasurement unitOfMeasurement) {
        this();
        this.name = name;
        this.description = description;
        this.observationType = observationType;
        this.unitOfMeasurement = unitOfMeasurement;
    }

    @Override
    protected void ensureServiceOnChildren(SensorThingsService service) {
        if (this.thing != null) {
            this.thing.setService(service);
        }
        if (this.sensor != null) {
            this.sensor.setService(service);
        }
        if (this.observedProperty != null) {
            this.observedProperty.setService(service);
        }
        if (this.observations != null) {
            this.observations.setService(service, Observation.class);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Datastream other = (Datastream)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.observationType, other.observationType) && Objects.equals(this.unitOfMeasurement, other.unitOfMeasurement) && Objects.equals(this.properties, other.properties) && Objects.equals(this.resultTime, other.resultTime) && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.description, this.observationType, this.unitOfMeasurement, this.properties, this.resultTime);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getObservationType() {
        return this.observationType;
    }

    public void setObservationType(String observationType) {
        this.observationType = observationType;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public UnitOfMeasurement getUnitOfMeasurement() {
        return this.unitOfMeasurement;
    }

    public void setUnitOfMeasurement(UnitOfMeasurement unitOfMeasurement) {
        this.unitOfMeasurement = unitOfMeasurement;
    }

    public GeoJsonObject getObservedArea() {
        return this.observedArea;
    }

    public void setObservedArea(GeoJsonObject observedArea) {
        this.observedArea = observedArea;
    }

    public Interval getPhenomenonTime() {
        return this.phenomenonTime;
    }

    public void setPhenomenonTime(Interval phenomenonTime) {
        this.phenomenonTime = phenomenonTime;
    }

    public Interval getResultTime() {
        return this.resultTime;
    }

    public void setResultTime(Interval resultTime) {
        this.resultTime = resultTime;
    }

    public Thing getThing() throws ServiceFailureException {
        if (this.thing == null && this.getService() != null) {
            this.thing = (Thing)this.getService().things().find(this);
        }
        return this.thing;
    }

    public void setThing(Thing thing) {
        this.thing = thing;
    }

    public Sensor getSensor() throws ServiceFailureException {
        if (this.sensor == null && this.getService() != null) {
            this.sensor = (Sensor)this.getService().sensors().find(this);
        }
        return this.sensor;
    }

    public void setSensor(Sensor sensor) {
        this.sensor = sensor;
    }

    public ObservedProperty getObservedProperty() throws ServiceFailureException {
        if (this.observedProperty == null && this.getService() != null) {
            this.observedProperty = (ObservedProperty)this.getService().observedProperties().find(this);
        }
        return this.observedProperty;
    }

    public void setObservedProperty(ObservedProperty observedProperty) {
        this.observedProperty = observedProperty;
    }

    public ObservationDao observations() {
        ObservationDao result = this.getService().observations();
        result.setParent(this);
        return result;
    }

    @JsonProperty(value="Observations")
    public EntityList<Observation> getObservations() {
        return this.observations;
    }

    @JsonProperty(value="Observations")
    public void setObservations(List<Observation> observations) {
        this.observations.replaceAll(observations);
    }

    @Override
    public BaseDao<Datastream> getDao(SensorThingsService service) {
        return new DatastreamDao(service);
    }

    @Override
    public Datastream withOnlyId() {
        Datastream copy = new Datastream();
        copy.setId(this.id);
        return copy;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.getName();
    }
}

